/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.irsa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.SearchCondition;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.gui.CatalogUIHandler;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.catalog.irsa.IRSACatalogQueryTool;
import jsky.catalog.irsa.IRSAConfig;
import jsky.catalog.irsa.IRSADataDictXML;
import jsky.catalog.irsa.IRSAFieldDesc;
import jsky.catalog.irsa.IRSAQueryArgs;
import jsky.catalog.irsa.IRSATable;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.WorldCoords;
import jsky.util.Logger;
import jsky.util.NameValue;
import jsky.util.StringUtil;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressPanel;

public class IRSACatalog
implements PlotableCatalog,
CatalogUIHandler {
    static final Integer MINI_COLUMN_LIST = new Integer(0);
    static final Integer SHORT_COLUMN_LIST = new Integer(1);
    static final Integer STANDARD_COLUMN_LIST = new Integer(2);
    static final Integer ALL_COLUMNS = new Integer(3);
    static final Integer CUSTOM_SQL = new Integer(4);
    static final String OBJECT = "Object";
    static final String NAME_SERVER = "Name Server";
    static final String RA = "RA";
    static final String DEC = "Dec";
    static final String EQUINOX = "Equinox";
    static final String RADIUS = "Radius";
    static final String SELECT = "Select";
    static final String MAX_OBJECTS = "Max Objects";
    private static final String J2000 = "2000";
    private static final String B1950 = "1950";
    private static NameValue[] _equinoxOptions = new NameValue[]{new NameValue("J2000", "2000"), new NameValue("B1950", "1950")};
    private URL _url;
    private CatalogDirectory _parent;
    private String _id;
    private String _name;
    private String _description;
    private String _docURL = "http://irsa.ipac.caltech.edu/";
    private String _type = "catalog";
    private String _protocol = "http";
    private String _host = "irsa.ipac.caltech.edu";
    private int _port = 80;
    private String _path = "/cgi-bin/Oasis/CatSearch/nph-catsearch";
    private String _ddPath = "/cgi-bin/Oasis/DD/nph-dd";
    private String _server;
    private String _database;
    private String _ddname;
    private FieldDescAdapter[] _paramDesc;
    private TablePlotSymbol[] _symbols;
    private boolean _symbolsEdited = false;
    private HTMLQueryResultHandler _htmlQueryResultHandler;
    private ProgressPanel _progressPanel;
    private IRSATable _table;
    private JComponent _uiComponent;
    private IRSAFieldDesc[] _fieldDesc;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public IRSACatalog(String desc, String server, String database, String catname, String ddname, URL url) {
        this._name = desc;
        this._id = catname;
        this._description = "IRSA Catalog Search Service";
        this._server = server;
        this._database = database;
        this._ddname = ddname;
        this._url = url;
    }

    public IRSACatalog(File file, IRSATable table) {
        this._type = "local";
        this._id = this._description = file.getName();
        this._name = this._description;
        this._description = "Accessed via the NASA/IPAC Infrared Science Archive";
        this._protocol = "file";
        this._host = "localhost";
        this._path = file.getPath();
        this._table = table;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public CatalogDirectory getParent() {
        return this._parent;
    }

    public void setParent(CatalogDirectory dir) {
        this._parent = dir;
    }

    public Catalog[] getPath() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getPath(this);
    }

    public String toString() {
        return this.getName();
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDocURL(String docURL) {
        this._docURL = docURL;
    }

    public URL getDocURL() {
        try {
            return new URL(this._docURL);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setURLPath(String path) {
        this._path = path;
    }

    public String getURLPath() {
        return this._path;
    }

    public void setSymbols(TablePlotSymbol[] symbols) {
        this._symbols = symbols;
    }

    public void setSymbolsEdited(boolean edited) {
        this._symbolsEdited = edited;
    }

    public boolean isSymbolsEdited() {
        return this._symbolsEdited;
    }

    public void saveSymbolConfig() {
        IRSAConfig.getConfigFile().save();
    }

    public String getTitle() {
        return this._name;
    }

    public int getNumParams() {
        if (this._paramDesc == null) {
            this._initSearchParameters();
        }
        return this._paramDesc.length;
    }

    public FieldDesc getParamDesc(int i) {
        if (this._paramDesc == null) {
            this._initSearchParameters();
        }
        return this._paramDesc[i];
    }

    public FieldDesc getParamDesc(String name) {
        if (this._paramDesc == null) {
            this._initSearchParameters();
        }
        int i = 0;
        while (i < this._paramDesc.length) {
            if (this._paramDesc[i] != null && this._paramDesc[i].getName().equals(name)) {
                return this._paramDesc[i];
            }
            ++i;
        }
        return null;
    }

    public int getNumSymbols() {
        if (this._symbols == null) {
            this._initPlotSymbols();
        }
        if (this._symbols == null) {
            return 0;
        }
        return this._symbols.length;
    }

    public TablePlotSymbol getSymbolDesc(int i) {
        return this._symbols[i];
    }

    public TablePlotSymbol[] getSymbols() {
        if (this._symbols == null) {
            this._initPlotSymbols();
        }
        return this._symbols;
    }

    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
        Coordinates coords = region.getCenterPosition();
        String equinoxStr = (String)queryArgs.getParamValue(EQUINOX);
        double equinox = this._getEquinox(queryArgs);
        WorldCoords pos = (WorldCoords)coords;
        String[] radec = pos.format(equinox);
        queryArgs.setParamValue(RA, (Object)radec[0]);
        queryArgs.setParamValue(DEC, (Object)radec[1]);
        queryArgs.setParamValue(EQUINOX, (Object)equinoxStr);
        queryArgs.setParamValue(RADIUS, region.getMaxRadius());
    }

    public boolean isLocal() {
        return this._type.equals("local");
    }

    public boolean isImageServer() {
        return false;
    }

    public QueryResult query(QueryArgs queryArgs) throws IOException {
        if (this._type.equals("catalog")) {
            return this._queryCatalog(queryArgs);
        }
        if (this._type.equals("local")) {
            return this._queryLocalCatalog(queryArgs);
        }
        throw new RuntimeException("Query not supported for this catalog type: " + this._protocol + ":" + this._type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult _queryCatalog(QueryArgs queryArgs) throws IOException {
        QueryResult queryResult;
        block7: {
            URLConnection connection;
            ProgressBarFilterInputStream in;
            block5: {
                URLQueryResult uRLQueryResult;
                block6: {
                    URL queryUrl = this._getQueryUrl(queryArgs);
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug(this, "URL = " + queryUrl);
                    }
                    this._updateProgressPanel("Downloading query results ...");
                    in = null;
                    try {
                        connection = this._progressPanel.openConnection(queryUrl);
                        String contentType = connection.getContentType();
                        if (contentType == null || !contentType.equals("text/html")) break block5;
                        uRLQueryResult = new URLQueryResult(queryUrl);
                        if (in == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            this._progressPanel.stopLoggingInputStream(in);
                        }
                        this._progressPanel.stop();
                        throw throwable;
                    }
                    this._progressPanel.stopLoggingInputStream(in);
                }
                this._progressPanel.stop();
                return uRLQueryResult;
            }
            InputStream ins = connection.getInputStream();
            in = this._progressPanel.getLoggedInputStream(ins, connection.getContentLength());
            queryResult = this._makeQueryResult(in, queryArgs);
            if (in == null) break block7;
            this._progressPanel.stopLoggingInputStream(in);
        }
        this._progressPanel.stop();
        return queryResult;
    }

    private QueryResult _queryLocalCatalog(QueryArgs queryArgs) throws IOException {
        QueryResult result;
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        queryArgs.setParamValues(null);
        IRSATable cat = this._table;
        if (cat == null) {
            if (this._path != null) {
                cat = new IRSATable(this, this._path);
            } else {
                return null;
            }
        }
        if ((result = cat.query(queryArgs)) instanceof IRSATable) {
            ((IRSATable)result).setCatalog(this);
        }
        return result;
    }

    private double _getEquinox(QueryArgs queryArgs) {
        String equinoxStr = (String)queryArgs.getParamValue(EQUINOX);
        if (equinoxStr.equals(B1950)) {
            return 1950.0;
        }
        return 2000.0;
    }

    private void _setQueryRegion(QueryArgs queryArgs, SearchCondition[] sc) throws IOException {
        WorldCoords wcs;
        String objectName;
        if (queryArgs.getRegion() != null || sc == null || sc.length == 0) {
            return;
        }
        Double radius = (Double)queryArgs.getParamValue(RADIUS);
        if (radius == null) {
            radius = new Double(15.0);
        }
        if ((objectName = (String)queryArgs.getParamValue(OBJECT)) == null || objectName.length() == 0) {
            String raStr = (String)queryArgs.getParamValue(RA);
            String decStr = (String)queryArgs.getParamValue(DEC);
            if (raStr == null || decStr == null) {
                return;
            }
            double equinox = this._getEquinox(queryArgs);
            wcs = new WorldCoords(raStr, decStr, equinox, true);
        } else {
            Object o = queryArgs.getParamValue(NAME_SERVER);
            if (!(o instanceof Catalog)) {
                throw new RuntimeException("No name server was specified");
            }
            wcs = this._resolveObjectName(objectName, (Catalog)o);
        }
        queryArgs.setRegion(new CoordinateRadius(wcs, 0.0, radius));
    }

    private WorldCoords _resolveObjectName(String objectName, Catalog cat) throws IOException {
        Coordinates coords;
        BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
        queryArgs.setId(objectName);
        QueryResult r = cat.query(queryArgs);
        if (r instanceof TableQueryResult && (coords = ((TableQueryResult)r).getCoordinates(0)) instanceof WorldCoords) {
            return (WorldCoords)coords;
        }
        throw new RuntimeException("Unexpected result from " + cat.toString());
    }

    protected void _setMaxRows(QueryArgs queryArgs, SearchCondition[] sc) {
        if (queryArgs.getMaxRows() != 0 || sc == null || sc.length == 0) {
            return;
        }
        Integer maxObjects = (Integer)queryArgs.getParamValue(MAX_OBJECTS);
        if (maxObjects != null) {
            queryArgs.setMaxRows(maxObjects);
        }
    }

    private URL _getQueryUrl(QueryArgs queryArgs) throws MalformedURLException, IOException {
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        CoordinateRadius region = queryArgs.getRegion();
        String centerStr = "";
        String radiusStr = "";
        if (region != null) {
            WorldCoords pos = (WorldCoords)region.getCenterPosition();
            centerStr = pos.getRA().toString() + " " + pos.getDec().toString() + " eq J2000";
            radiusStr = "" + region.getMaxRadius() + "%20arcmin";
        }
        String urlStr = this._protocol + "://" + this._host;
        if (this._port != 80) {
            urlStr = urlStr + ":" + this._port;
        }
        urlStr = urlStr + this._path;
        urlStr = urlStr + "?server=" + this._server;
        urlStr = urlStr + "&database=" + this._database;
        urlStr = urlStr + "&catalog=" + this._id;
        urlStr = urlStr + "&sql=" + ((IRSAQueryArgs)queryArgs).getSQLString();
        urlStr = urlStr + "&within=" + radiusStr;
        urlStr = urlStr + "&objstr=" + centerStr;
        urlStr = StringUtil.replace(urlStr, " ", "%20");
        return new URL(urlStr);
    }

    private QueryResult _makeQueryResult(InputStream ins, QueryArgs queryArgs) throws IOException {
        IRSATable result = new IRSATable(this, ins, queryArgs);
        return result;
    }

    private void _initSearchParameters() {
        Vector<FieldDescAdapter> params = new Vector<FieldDescAdapter>(10);
        FieldDescAdapter p = new FieldDescAdapter(OBJECT);
        p.setDescription("Enter the name of the object");
        params.add(p);
        p = new FieldDescAdapter(NAME_SERVER);
        p.setDescription("Select the name server to use to resolve the object name");
        List l = IRSAConfig.getConfigFile().getNameServers();
        NameValue[] ar = new NameValue[l.size()];
        int i = 0;
        while (i < ar.length) {
            Catalog cat = (Catalog)l.get(i);
            ar[i] = new NameValue(cat.getName(), cat);
            ++i;
        }
        p.setOptions(ar);
        params.add(p);
        p = new FieldDescAdapter(RA);
        p.setIsRA(true);
        p.setDescription("Right Ascension in the selected equinox, format: hh:mm:ss.sss");
        params.add(p);
        p = new FieldDescAdapter(DEC);
        p.setDescription("Declination in the selected equinox, format: dd:mm:ss.sss");
        p.setIsDec(true);
        params.add(p);
        p = new FieldDescAdapter(EQUINOX);
        p.setDescription("Equinox of RA and Dec");
        p.setOptions(_equinoxOptions);
        params.add(p);
        p = new FieldDescAdapter(RADIUS);
        p.setDescription("The maximum radius from the center coordinates in arcmin");
        p.setFieldClass(class$java$lang$Double == null ? (class$java$lang$Double = IRSACatalog.class$("java.lang.Double")) : class$java$lang$Double);
        p.setUnits("arcmin");
        params.add(p);
        p = new FieldDescAdapter(SELECT);
        p.setDescription("SQL SELECT statement to be run on the server");
        ar = new NameValue[]{new NameValue("Mini Column List", MINI_COLUMN_LIST), new NameValue("Short Column List", SHORT_COLUMN_LIST), new NameValue("Standard Column List", STANDARD_COLUMN_LIST), new NameValue("All Columns", ALL_COLUMNS)};
        p.setOptions(ar);
        params.add(p);
        p = new FieldDescAdapter(MAX_OBJECTS);
        p.setDescription("The maximum number of objects to return");
        p.setFieldClass(class$java$lang$Integer == null ? (class$java$lang$Integer = IRSACatalog.class$("java.lang.Integer")) : class$java$lang$Integer);
        p.setDefaultValue(new Integer(1000));
        params.add(p);
        this._paramDesc = new FieldDescAdapter[params.size()];
        params.toArray(this._paramDesc);
    }

    private void _updateProgressPanel(String msg) {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel(msg);
        } else {
            this._progressPanel.setTitle(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRSAFieldDesc[] getFieldDesc() throws MalformedURLException, IOException {
        if (this._fieldDesc == null) {
            block5: {
                URL url = this._getDataDictionaryURL();
                this._updateProgressPanel("Downloading the data dictionary ...");
                ProgressBarFilterInputStream in = null;
                try {
                    URLConnection connection = this._progressPanel.openConnection(url);
                    String contentType = connection.getContentType();
                    if (!contentType.equals("text/xml")) {
                        throw new RuntimeException("Error reading the IRSA data dictionary from: " + url);
                    }
                    InputStream ins = connection.getInputStream();
                    in = this._progressPanel.getLoggedInputStream(ins, connection.getContentLength());
                    IRSADataDictXML dd = new IRSADataDictXML();
                    dd.parse(url, in);
                    this._fieldDesc = dd.getColumns();
                    if (in == null) break block5;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        this._progressPanel.stopLoggingInputStream(in);
                    }
                    this._progressPanel.stop();
                    throw throwable;
                }
                this._progressPanel.stopLoggingInputStream(in);
            }
            this._progressPanel.stop();
        }
        return this._fieldDesc;
    }

    private URL _getDataDictionaryURL() throws MalformedURLException {
        String urlStr = this._protocol + "://" + this._host;
        if (this._port != 80) {
            urlStr = urlStr + ":" + this._port;
        }
        urlStr = urlStr + this._ddPath;
        urlStr = urlStr + "?server=" + this._server;
        urlStr = urlStr + "&database=" + this._database;
        urlStr = urlStr + "&datadict=" + this._ddname;
        return new URL(urlStr);
    }

    public JComponent makeComponent(QueryResultDisplay display) {
        if (this._uiComponent == null) {
            try {
                this._uiComponent = new IRSACatalogQueryTool(this, display);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._uiComponent;
    }

    private void _initPlotSymbols() {
        if (this._fieldDesc == null) {
            return;
        }
        int raCol = -1;
        int decCol = -1;
        int i = 0;
        while (i < this._fieldDesc.length) {
            if (this._fieldDesc[i].isRA()) {
                raCol = i;
            } else if (this._fieldDesc[i].isDec()) {
                decCol = i;
            }
            ++i;
        }
        if (raCol == -1 || decCol == -1) {
            return;
        }
        this._symbols = new TablePlotSymbol[1];
        TablePlotSymbol symbol = new TablePlotSymbol();
        symbol.setRaCol(raCol);
        symbol.setDecCol(decCol);
        this._symbols[0] = symbol;
    }

    public static void main(String[] args) {
        String catalogName = "2MASS Second Incremental Release Point Source Catalog (PSC)";
        IRSAConfig configFile = IRSAConfig.getConfigFile();
        IRSACatalog cat = (IRSACatalog)configFile.getCatalog(catalogName);
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        }
        try {
            System.out.println("test query: at center position/radius: ");
            IRSAQueryArgs queryArgs = new IRSAQueryArgs(cat);
            queryArgs.setRegion(new CoordinateRadius(new WorldCoords("03:19:44.44", "+41:30:58.21"), 2.0));
            queryArgs.setSQLString("select ra, dec from " + cat.getId() + ";");
            IRSATable queryResult = (IRSATable)cat.query(queryArgs);
            System.out.println("result: " + queryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Test passed");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

