/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.skycat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.RowCoordinates;
import jsky.catalog.SearchCondition;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.catalog.URLQueryResult;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.catalog.skycat.SkycatTable;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.ImageCoords;
import jsky.coords.WorldCoords;
import jsky.util.Logger;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressPanel;

public class SkycatCatalog
implements PlotableCatalog {
    private SkycatConfigEntry _entry;
    private HTMLQueryResultHandler _htmlQueryResultHandler;
    private ProgressPanel _progressPanel;
    private SkycatTable _table;
    private int _queryCount = 0;

    public SkycatCatalog(SkycatConfigEntry entry) {
        this._entry = entry;
    }

    public SkycatCatalog(SkycatConfigEntry entry, SkycatTable table) {
        this(entry);
        this._table = table;
    }

    public SkycatCatalog(SkycatTable table) {
        this(table.getConfigEntry());
        this._table = table;
        this._table.setCatalog(this);
    }

    public SkycatCatalog(SkycatConfigEntry entry, HTMLQueryResultHandler handler) {
        this(entry);
        this.setHTMLQueryResultHandler(handler);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public void setName(String name) {
        this._entry.setName(name);
    }

    public String getName() {
        return this._entry.getName();
    }

    public SkycatConfigEntry getConfigEntry() {
        return this._entry;
    }

    public int getQueryCount() {
        return this._queryCount;
    }

    public void setConfigEntry(SkycatConfigEntry entry) {
        this._entry = entry;
    }

    public SkycatTable getTable() {
        return this._table;
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return this._entry.getShortName();
    }

    public String getTitle() {
        return this._entry.getName();
    }

    public String getDescription() {
        return this._entry.getProperty("copyright");
    }

    public URL getDocURL() {
        return this._entry.getDocURL();
    }

    public int getNumParams() {
        return this._entry.getNumParams();
    }

    public FieldDesc getParamDesc(int i) {
        return this._entry.getParamDesc(i);
    }

    public FieldDesc getParamDesc(String name) {
        return this._entry.getParamDesc(name);
    }

    public int getNumSymbols() {
        return this._entry.getNumSymbols();
    }

    public TablePlotSymbol getSymbolDesc(int i) {
        return this._entry.getSymbolDesc(i);
    }

    public TablePlotSymbol[] getSymbols() {
        return this._entry.getSymbols();
    }

    public void setSymbols(TablePlotSymbol[] symbols) {
        this._entry.setSymbols(symbols);
    }

    public void setSymbolsEdited(boolean edited) {
        this._entry.setSymbolsEdited(edited);
    }

    public boolean isSymbolsEdited() {
        return this._entry.isSymbolsEdited();
    }

    public void saveSymbolConfig() {
        SkycatConfigFile.getConfigFile().save();
    }

    public String getShortName() {
        return this._entry.getShortName();
    }

    public boolean isWCS() {
        return this._entry.getRowCoordinates().isWCS();
    }

    public double getEquinox() {
        return this._entry.getRowCoordinates().getEquinox();
    }

    public boolean isPix() {
        return this._entry.getRowCoordinates().isPix();
    }

    public boolean isLocal() {
        return this._entry.getServType().equals("local");
    }

    public boolean isImageServer() {
        return this._entry.getServType().equals("imagesvr");
    }

    public String getType() {
        return this._entry.getServType();
    }

    public void setParent(CatalogDirectory catDir) {
        this._entry.setConfigFile(catDir);
    }

    public CatalogDirectory getParent() {
        return this._entry.getConfigFile();
    }

    public Catalog[] getPath() {
        CatalogDirectory parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getPath(this);
    }

    public QueryResult query(QueryArgs queryArgs) throws IOException {
        ++this._queryCount;
        String servType = this._entry.getServType();
        if (servType.equals("local")) {
            return this._queryLocalCatalog(queryArgs);
        }
        if (servType.equals("catalog") || servType.equals("archive") || servType.equals("namesvr")) {
            return this._queryCatalog(queryArgs);
        }
        if (servType.equals("imagesvr")) {
            return this._queryImageServer(queryArgs);
        }
        if (servType.equals("directory")) {
            return this._queryCatalogDirectory(queryArgs);
        }
        throw new RuntimeException("Query not supported for this catalog type: " + servType);
    }

    private QueryResult _queryLocalCatalog(QueryArgs queryArgs) throws IOException {
        QueryResult result;
        String urlStr = this._entry.getURL(0);
        if (urlStr != null && urlStr.startsWith("java://")) {
            return this._queryJavaCatalog(queryArgs);
        }
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        queryArgs.setParamValues(null);
        SkycatTable cat = this._table;
        if (cat == null) {
            if (urlStr != null) {
                cat = new SkycatTable(this, urlStr);
            } else {
                return null;
            }
        }
        if ((result = cat.query(queryArgs)) instanceof SkycatTable) {
            ((SkycatTable)result).setCatalog(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult _queryCatalog(QueryArgs queryArgs) throws IOException {
        int n = this._entry.getNumURLs();
        int i = 0;
        while (i < n) {
            String urlStr = this._entry.getURL(i);
            if (urlStr != null) {
                SkycatTable skycatTable;
                block12: {
                    URLConnection connection;
                    ProgressBarFilterInputStream in;
                    block10: {
                        URLQueryResult uRLQueryResult;
                        block11: {
                            if ((urlStr = this._getQueryUrl(urlStr, queryArgs)).startsWith(File.separator) || urlStr.length() > 2 && urlStr.charAt(1) == ':') {
                                CatalogDirectory catDir = this._entry.getConfigFile();
                                if (catDir != null && !catDir.isLocal()) {
                                    throw new RuntimeException("Invalid catalog URL: " + urlStr + ", in remote config file");
                                }
                                Process process = Runtime.getRuntime().exec(urlStr);
                                InputStream stdout = process.getInputStream();
                                SkycatTable cat = new SkycatTable(this, stdout, queryArgs);
                                cat.setConfigEntry(this._entry);
                                return cat;
                            }
                            if (urlStr.startsWith("java://")) {
                                return this._queryJavaCatalog(queryArgs);
                            }
                            URL queryUrl = new URL(urlStr);
                            if (this._progressPanel == null) {
                                this._progressPanel = ProgressPanel.makeProgressPanel("Downloading query results ...");
                            }
                            in = null;
                            try {
                                connection = this._progressPanel.openConnection(queryUrl);
                                String contentType = connection.getContentType();
                                if (contentType == null || !contentType.equals("text/html")) break block10;
                                uRLQueryResult = new URLQueryResult(queryUrl);
                                if (in == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (in != null) {
                                    this._progressPanel.stopLoggingInputStream(in);
                                }
                                this._progressPanel.stop();
                                throw throwable;
                            }
                            this._progressPanel.stopLoggingInputStream(in);
                        }
                        this._progressPanel.stop();
                        return uRLQueryResult;
                    }
                    InputStream ins = connection.getInputStream();
                    in = this._progressPanel.getLoggedInputStream(ins, connection.getContentLength());
                    SkycatTable cat = new SkycatTable(this, (InputStream)in, queryArgs);
                    cat.setConfigEntry(this._entry);
                    skycatTable = cat;
                    if (in == null) break block12;
                    this._progressPanel.stopLoggingInputStream(in);
                }
                this._progressPanel.stop();
                return skycatTable;
            }
            ++i;
        }
        throw new RuntimeException("No query URL was specified in the config file.");
    }

    private QueryResult _queryImageServer(QueryArgs queryArgs) throws IOException {
        int n = this._entry.getNumURLs();
        int i = 0;
        while (i < n) {
            String urlStr = this._entry.getURL(i);
            if (urlStr != null) {
                if ((urlStr = this._getQueryUrl(urlStr, queryArgs)).startsWith(File.separator)) {
                    throw new RuntimeException("Local commands not supported for image server (yet)");
                }
                return new URLQueryResult(new URL(urlStr));
            }
            ++i;
        }
        throw new RuntimeException("No query URL was specified in the config file.");
    }

    private QueryResult _queryCatalogDirectory(QueryArgs queryArgs) {
        int numURLs = this._entry.getNumURLs();
        int i = 0;
        while (i < numURLs) {
            try {
                return new URLQueryResult(new URL(this._entry.getURL(0)));
            }
            catch (Exception e) {
                if (i == numURLs - 1) {
                    throw new RuntimeException(e);
                }
                ++i;
            }
        }
        throw new RuntimeException("No URL was specified in the config file.");
    }

    private QueryResult _queryJavaCatalog(QueryArgs queryArgs) throws IOException {
        QueryResult result = null;
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        String urlStr = this._entry.getURL(0);
        if (urlStr != null) {
            StringTokenizer token = new StringTokenizer(urlStr.substring(7), "?\t");
            urlStr = this._getQueryUrl(urlStr, queryArgs);
            String className = token.nextToken();
            try {
                this.getClass();
                Class<?> catalogClass = Class.forName(className);
                Catalog catalog = (Catalog)catalogClass.newInstance();
                result = catalog.query(queryArgs);
                if (result instanceof MemoryCatalog && !(result instanceof SkycatTable)) {
                    MemoryCatalog mcat = (MemoryCatalog)result;
                    result = new SkycatTable(this._entry, mcat.getDataVector(), mcat.getFields());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }
        if (result instanceof SkycatTable) {
            ((SkycatTable)result).setCatalog(this);
        }
        return result;
    }

    private String _getQueryUrl(String urlStr, QueryArgs queryArgs) throws IOException {
        if (this._entry.getNumParams() == 0) {
            return urlStr;
        }
        int n = urlStr.length();
        StringBuffer buf = new StringBuffer(n * 2);
        boolean urlHasId = false;
        boolean urlHasRaDec = false;
        boolean urlHasXy = false;
        SearchCondition[] sc = queryArgs.getConditions();
        this._setQueryRegion(queryArgs, sc);
        this._setMaxRows(queryArgs, sc);
        int c = 0;
        while (c < n) {
            if (urlStr.charAt(c) == '%') {
                String id;
                FieldDesc p;
                if (urlStr.charAt(++c) == '%') {
                    buf.append('%');
                    ++c;
                    continue;
                }
                if (urlStr.startsWith("id", c)) {
                    String id2 = queryArgs.getId();
                    if (id2 == null) {
                        id2 = queryArgs.getParamValueAsString("id", null);
                    }
                    if (id2 != null) {
                        buf.append(id2);
                    }
                    c += 2;
                    urlHasId = true;
                    continue;
                }
                if (urlStr.startsWith("ra", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        WorldCoords pos = (WorldCoords)region.getCenterPosition();
                        buf.append(pos.getRA().toString());
                    }
                    c += 2;
                    urlHasRaDec = true;
                    continue;
                }
                if (urlStr.startsWith("dec", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        WorldCoords pos = (WorldCoords)region.getCenterPosition();
                        buf.append(pos.getDec().toString());
                    }
                    c += 3;
                    urlHasRaDec = true;
                    continue;
                }
                if (urlStr.charAt(c) == 'x') {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        ImageCoords pos = (ImageCoords)region.getCenterPosition();
                        buf.append(pos.getX());
                    }
                    ++c;
                    urlHasXy = true;
                    continue;
                }
                if (urlStr.charAt(c) == 'y') {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null) {
                        ImageCoords pos = (ImageCoords)region.getCenterPosition();
                        buf.append(pos.getY());
                    }
                    ++c;
                    urlHasXy = true;
                    continue;
                }
                if (urlStr.startsWith("r1", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null && (region.getMinRadius() != 0.0 || region.getMaxRadius() != 0.0)) {
                        buf.append(region.getMinRadius());
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.startsWith("r2", c)) {
                    CoordinateRadius region = queryArgs.getRegion();
                    if (region != null && (region.getMinRadius() != 0.0 || region.getMaxRadius() != 0.0)) {
                        buf.append(region.getMaxRadius());
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.charAt(c) == 'w') {
                    if (sc != null && sc.length > 0) {
                        int i = 0;
                        while (i < sc.length) {
                            if (sc[i].getName().equals("Width")) {
                                buf.append(sc[i].getVal());
                                break;
                            }
                            ++i;
                        }
                    }
                    ++c;
                    continue;
                }
                if (urlStr.charAt(c) == 'h') {
                    if (sc != null && sc.length > 0) {
                        int i = 0;
                        while (i < sc.length) {
                            if (sc[i].getName().equals("Height")) {
                                buf.append(sc[i].getVal());
                                break;
                            }
                            ++i;
                        }
                    }
                    ++c;
                    continue;
                }
                if (urlStr.startsWith("m1", c)) {
                    if (sc != null && sc.length > 0) {
                        String m1 = "0";
                        int i = 0;
                        while (i < sc.length) {
                            p = sc[i].getFieldDesc();
                            if (p.isMin() && (id = p.getId()) != null && id.equalsIgnoreCase("mag")) {
                                m1 = sc[i].getVal().toString();
                                break;
                            }
                            ++i;
                        }
                        buf.append(m1);
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.startsWith("m2", c)) {
                    if (sc != null && sc.length > 0) {
                        String m2 = "0";
                        int i = 0;
                        while (i < sc.length) {
                            p = sc[i].getFieldDesc();
                            if (p.isMax() && (id = p.getId()) != null && id.equalsIgnoreCase("mag")) {
                                m2 = sc[i].getVal().toString();
                                break;
                            }
                            ++i;
                        }
                        buf.append(m2);
                    }
                    c += 2;
                    continue;
                }
                if (urlStr.charAt(c) == 'n') {
                    if (queryArgs.getMaxRows() > 0) {
                        buf.append(queryArgs.getMaxRows());
                    }
                    ++c;
                    continue;
                }
                if (urlStr.startsWith("cond", c)) {
                    if (sc != null && sc.length > 0) {
                        int i = 0;
                        while (i < sc.length) {
                            String name = sc[i].getName();
                            if (!(this.isWCS() && (name.equalsIgnoreCase("Object") || name.equalsIgnoreCase("RA") || name.equalsIgnoreCase("Dec") || name.equalsIgnoreCase("Equinox")) || this.isPix() && (name.equalsIgnoreCase("X") || name.equalsIgnoreCase("Y")) || name.equalsIgnoreCase("Min Radius") || name.equalsIgnoreCase("Max Radius") || name.equalsIgnoreCase("Width") || name.equalsIgnoreCase("Height") || name.equalsIgnoreCase("Max Objects"))) {
                                String id3 = sc[i].getFieldDesc().getId();
                                if (id3 == null) {
                                    id3 = name;
                                }
                                if (sc[i].isRange()) {
                                    buf.append(id3 + "=" + sc[i].getMinVal() + "," + sc[i].getMaxVal());
                                } else {
                                    buf.append(id3 + "=" + sc[i].getMinVal());
                                }
                                if (sc.length - i > 1) {
                                    buf.append('&');
                                }
                            }
                            ++i;
                        }
                    }
                    c += 4;
                    continue;
                }
                if (!urlStr.startsWith("mime-type", c)) continue;
                buf.append("application/x-fits");
                c += 9;
                continue;
            }
            buf.append(urlStr.charAt(c++));
        }
        if (!urlHasId && queryArgs.getId() != null && queryArgs.getId().length() != 0) {
            throw new RuntimeException(this._entry.getName() + " does not support search by id");
        }
        if (queryArgs.getRegion() != null) {
            if (queryArgs.getRegion().getCenterPosition() instanceof WorldCoords && !urlHasRaDec) {
                throw new RuntimeException(this._entry.getName() + " does not support search by World Coordinates");
            }
            if (queryArgs.getRegion().getCenterPosition() instanceof ImageCoords && !urlHasXy) {
                throw new RuntimeException(this._entry.getName() + " does not support search by image coordinates");
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(this, "URL = " + buf.toString());
        }
        return buf.toString();
    }

    private double _getEquinox(QueryArgs queryArgs) {
        String equinoxStr = (String)queryArgs.getParamValue("Equinox");
        double equinox = 2000.0;
        if (equinoxStr != null && equinoxStr.endsWith("1950")) {
            equinox = 1950.0;
        }
        return equinox;
    }

    protected void _setQueryRegion(QueryArgs queryArgs, SearchCondition[] sc) throws IOException {
        Double r2;
        Double r1;
        block15: {
            block13: {
                block14: {
                    if (queryArgs.getRegion() != null || sc == null || sc.length == 0) {
                        return;
                    }
                    r1 = (Double)queryArgs.getParamValue("Min Radius");
                    r2 = (Double)queryArgs.getParamValue("Max Radius");
                    if (r1 == null && r2 == null) break block13;
                    if (r1 == null) break block14;
                    if (r2 == null) {
                        r2 = r1;
                        r1 = new Double(0.0);
                    }
                    break block15;
                }
                if (r2 == null || r1 != null) break block15;
                r1 = new Double(0.0);
                break block15;
            }
            int i = 0;
            while (i < sc.length) {
                String name = sc[i].getName();
                if (name.equalsIgnoreCase("radius")) {
                    r1 = (Double)sc[i].getMinVal();
                    r2 = (Double)sc[i].getMaxVal();
                    break;
                }
                ++i;
            }
        }
        if (r1 == null && r2 == null) {
            r1 = new Double(0.0);
            r2 = new Double(10.0);
        }
        if (this.isWCS()) {
            WorldCoords wcs;
            String objectName = (String)queryArgs.getParamValue("Object");
            if (objectName == null || objectName.length() == 0) {
                String raStr = (String)queryArgs.getParamValue("RA");
                String decStr = (String)queryArgs.getParamValue("Dec");
                if (raStr == null || decStr == null) {
                    return;
                }
                double equinox = this._getEquinox(queryArgs);
                wcs = new WorldCoords(raStr, decStr, equinox, true);
            } else {
                Object o = queryArgs.getParamValue("Name Server");
                if (!(o instanceof Catalog)) {
                    throw new RuntimeException("No name server was specified");
                }
                wcs = this._resolveObjectName(objectName, (Catalog)o);
            }
            queryArgs.setRegion(new CoordinateRadius(wcs, r1, r2));
        } else if (this.isPix()) {
            Double x = (Double)queryArgs.getParamValue("X");
            Double y = (Double)queryArgs.getParamValue("Y");
            if (x == null || y == null) {
                return;
            }
            ImageCoords ic = new ImageCoords(x.intValue(), y.intValue());
            queryArgs.setRegion(new CoordinateRadius(ic, r1, r2));
        }
    }

    private WorldCoords _resolveObjectName(String objectName, Catalog cat) throws IOException {
        Coordinates coords;
        BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
        queryArgs.setId(objectName);
        QueryResult r = cat.query(queryArgs);
        if (r instanceof TableQueryResult && (coords = ((TableQueryResult)r).getCoordinates(0)) instanceof WorldCoords) {
            return (WorldCoords)coords;
        }
        throw new RuntimeException("Unexpected result from " + cat.toString());
    }

    protected void _setMaxRows(QueryArgs queryArgs, SearchCondition[] sc) {
        if (queryArgs.getMaxRows() != 0 || sc == null || sc.length == 0) {
            return;
        }
        Integer maxObjects = (Integer)queryArgs.getParamValue("Max Objects");
        if (maxObjects != null) {
            queryArgs.setMaxRows(maxObjects);
        }
    }

    public void setHTMLQueryResultHandler(HTMLQueryResultHandler handler) {
        this._htmlQueryResultHandler = handler;
    }

    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
        Coordinates coords = region.getCenterPosition();
        RowCoordinates rowCoordinates = this._entry.getRowCoordinates();
        String equinoxStr = (String)queryArgs.getParamValue("Equinox");
        double equinox = this._getEquinox(queryArgs);
        if (rowCoordinates.isWCS()) {
            WorldCoords pos = (WorldCoords)coords;
            String[] radec = pos.format(equinox);
            queryArgs.setParamValue("RA", (Object)radec[0]);
            queryArgs.setParamValue("Dec", (Object)radec[1]);
            queryArgs.setParamValue("Equinox", (Object)equinoxStr);
            queryArgs.setParamValue("Min Radius", region.getMinRadius());
            queryArgs.setParamValue("Max Radius", region.getMaxRadius());
            queryArgs.setParamValue("Width", region.getWidth());
            queryArgs.setParamValue("Height", region.getHeight());
        } else if (rowCoordinates.isPix()) {
            ImageCoords pos = (ImageCoords)coords;
            queryArgs.setParamValue("X", pos.getX());
            queryArgs.setParamValue("Y", pos.getY());
            queryArgs.setParamValue("Min Radius", region.getMinRadius());
            queryArgs.setParamValue("Max Radius", region.getMaxRadius());
            queryArgs.setParamValue("Width", region.getWidth());
            queryArgs.setParamValue("Height", region.getHeight());
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java -classpath ... SkycatCatalog catalogName");
            System.exit(1);
        }
        String catalogName = args[0];
        SkycatConfigFile configFile = SkycatConfigFile.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName);
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        }
        try {
            BasicQueryArgs q1 = new BasicQueryArgs(cat);
            q1.setId("GSC0285601186");
            QueryResult r1 = cat.query(q1);
            System.out.println("result: " + r1);
            System.out.println("");
            System.out.println("test query: at center position/radius: ");
            BasicQueryArgs q2 = new BasicQueryArgs(cat);
            q2.setRegion(new CoordinateRadius(new WorldCoords("03:19:44.44", "+41:30:58.21"), 2.0));
            QueryResult r2 = cat.query(q2);
            System.out.println("result: " + r2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

