/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.io.Serializable;
import jsky.coords.Coordinates;

public class CoordinateRadius
implements Serializable {
    protected Coordinates centerPosition;
    protected double minRadius;
    protected double maxRadius;
    protected double width;
    protected double height;

    public CoordinateRadius(Coordinates pos, double minRadius, double maxRadius) {
        this.centerPosition = pos;
        this.minRadius = Math.min(minRadius, maxRadius);
        this.maxRadius = Math.max(minRadius, maxRadius);
        this.width = this.height = 2.0 * Math.sqrt(0.5 * maxRadius * maxRadius);
    }

    public CoordinateRadius(Coordinates pos, double maxRadius) {
        this.centerPosition = pos;
        this.minRadius = 0.0;
        this.maxRadius = maxRadius;
        this.width = this.height = 2.0 * Math.sqrt(0.5 * maxRadius * maxRadius);
    }

    public CoordinateRadius(Coordinates pos, double maxRadius, double width, double height) {
        this.centerPosition = pos;
        this.width = width;
        this.height = height;
        this.minRadius = 0.0;
        this.maxRadius = maxRadius;
    }

    public Coordinates getCenterPosition() {
        return this.centerPosition;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean contains(Coordinates pos) {
        double dist = this.centerPosition.dist(pos);
        return dist >= this.minRadius && dist <= this.maxRadius;
    }

    public String toString() {
        return "(" + this.centerPosition + ", " + this.minRadius + ", " + this.maxRadius + ")";
    }
}

