/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.toolbox.LabelFigure;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class ImageLabel
extends LabelFigure
implements CanvasFigure {
    protected Object clientData;
    protected CanvasFigureListenerManager listenerManager;
    protected LinkedList slaves;
    protected Composite composite = AlphaComposite.getInstance(3, 1.0f);

    public ImageLabel(String text, Point2D.Double pos, Paint fill, Font font, Interactor interactor) {
        super(text, font);
        this.listenerManager = new CanvasFigureListenerManager(this);
        this.setAnchor(6);
        this.setFillPaint(fill);
        if (interactor != null) {
            this.setInteractor(interactor);
        }
        this.translate(pos.x, pos.y);
    }

    public void setClientData(Object o) {
        this.clientData = o;
    }

    public Object getClientData() {
        return this.clientData;
    }

    public Rectangle2D getBoundsWithoutLabel() {
        return this.getBounds();
    }

    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    public void paint(Graphics2D g) {
        g.setComposite(this.composite);
        super.paint(g);
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.repaint();
    }

    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.addCanvasFigureListener(listener);
    }

    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.removeCanvasFigureListener(listener);
    }

    public void fireCanvasFigureEvent(int eventType) {
        this.listenerManager.fireCanvasFigureEvent(eventType);
    }

    public void addSlave(CanvasFigure fig) {
        if (this.slaves == null) {
            this.slaves = new LinkedList();
        }
        this.slaves.add(fig);
    }

    public void translate(double x, double y) {
        super.translate(x, y);
        if (this.slaves != null) {
            ListIterator it = this.slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = (Figure)it.next();
                fig.translate(x, y);
            }
        }
    }

    public Point2D getAnchorPoint() {
        return CanvasUtilities.getLocation((Rectangle2D)this.getBounds(), (int)6);
    }
}

