/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.LabelFigure;
import diva.canvas.toolbox.LabelWrapper;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class LabeledImageFigure
extends LabelWrapper
implements CanvasFigure {
    protected Object clientData;
    protected CanvasFigureListenerManager listenerManager = new CanvasFigureListenerManager(this);
    protected LinkedList slaves;

    public LabeledImageFigure(Figure fig, String label, int anchor, Paint color, Font font, Interactor interactor) {
        super(fig, label);
        this.setAnchor(anchor);
        LabelFigure labelFig = this.getLabel();
        labelFig.setFillPaint(color);
        labelFig.setFont(font);
        labelFig.setAnchor(7);
        if (interactor != null) {
            this.setInteractor(interactor);
        }
    }

    public void setClientData(Object o) {
        this.clientData = o;
    }

    public Object getClientData() {
        return this.clientData;
    }

    public Rectangle2D getBoundsWithoutLabel() {
        return this.getChild().getBounds();
    }

    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        Interactor interactor = this.getInteractor();
        if (interactor instanceof SelectionInteractor) {
            SelectionModel model = ((SelectionInteractor)interactor).getSelectionModel();
            model.removeSelection((Object)this);
        }
        this.repaint();
    }

    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.addCanvasFigureListener(listener);
    }

    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this.listenerManager.removeCanvasFigureListener(listener);
    }

    public void fireCanvasFigureEvent(int eventType) {
        this.listenerManager.fireCanvasFigureEvent(eventType);
    }

    public void addSlave(CanvasFigure fig) {
        if (this.slaves == null) {
            this.slaves = new LinkedList();
        }
        this.slaves.add(fig);
    }

    public void translate(double x, double y) {
        super.translate(x, y);
        if (this.slaves != null) {
            ListIterator it = this.slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = (Figure)it.next();
                fig.translate(x, y);
            }
        }
    }
}

