/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import diva.canvas.GraphicsPane;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.fits.gui.FITSHDUChooser;
import jsky.image.fits.gui.FITSHDUChooserFrame;
import jsky.image.fits.gui.FITSHDUChooserInternalFrame;
import jsky.image.fits.gui.FITSKeywordsFrame;
import jsky.image.fits.gui.FITSKeywordsInternalFrame;
import jsky.image.graphics.MeasureBand;
import jsky.image.graphics.gui.CanvasDraw;
import jsky.image.graphics.gui.FITSGraphics;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.image.gui.ImageColorsFrame;
import jsky.image.gui.ImageColorsInternalFrame;
import jsky.image.gui.ImageCutLevelsFrame;
import jsky.image.gui.ImageCutLevelsInternalFrame;
import jsky.image.gui.ImageDisplayControlFrame;
import jsky.image.gui.ImageDisplayControlInternalFrame;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.ImageHistoryItem;
import jsky.image.gui.ImagePrintDialog;
import jsky.image.gui.ImagePropertiesFrame;
import jsky.image.gui.ImagePropertiesInternalFrame;
import jsky.image.gui.ImageSaveDialog;
import jsky.image.gui.MainImageDisplay;
import jsky.image.gui.PickObject;
import jsky.image.gui.PickObjectFrame;
import jsky.image.gui.PickObjectInternalFrame;
import jsky.util.FileUtil;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.LookAndFeelMenu;
import jsky.util.gui.ProgressBarFilterInputStream;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import jsky.util.gui.SwingUtil;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.util.BufferedFile;

public class DivaMainImageDisplay
extends DivaGraphicsImageDisplay
implements MainImageDisplay {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$DivaMainImageDisplay == null ? (class$jsky$image$gui$DivaMainImageDisplay = DivaMainImageDisplay.class$("jsky.image.gui.DivaMainImageDisplay")) : class$jsky$image$gui$DivaMainImageDisplay);
    private Component _parent;
    private ProgressPanel _progressPanel;
    private JFileChooser _fileChooser;
    private ImageSaveDialog _saveDialog;
    private ImagePrintDialog _printDialog;
    protected String _filename;
    private boolean saveNeeded = false;
    private boolean _firstTime = true;
    protected URL _url;
    protected URL _origURL;
    private String _title = _I18N.getString("imageDisplay");
    private CanvasDraw _canvasDraw;
    private Component _imageCutLevelsFrame;
    private Component _fitsKeywordsFrame;
    private Component _imagePropertiesFrame;
    private Component _imageColorsFrame;
    private Component _pickObjectFrame;
    private PickObject _pickObjectPanel;
    private Component _fitsHDUChooserFrame;
    private FITSHDUChooser _fitsHDUChooser;
    private FITSGraphics _fitsGraphics;
    private JDesktopPane _desktop = null;
    private ImageChangeEvent _imageChangeEvent = new ImageChangeEvent(this);
    private SwingWorker _worker;
    private Stack _backStack = new Stack();
    private Stack _forwStack = new Stack();
    private boolean _noStack = false;
    private LinkedList _historyList;
    private static final String HISTORY_LIST_NAME = "imageHistoryList";
    private int _maxHistoryItems = 20;
    private AbstractAction _openAction = new AbstractAction(_I18N.getString("open")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.open();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _backAction = new AbstractAction(_I18N.getString("back")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.back();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _forwAction = new AbstractAction(_I18N.getString("forward")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.forward();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _saveAction = new AbstractAction(_I18N.getString("save")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.save();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _saveAsAction = new AbstractAction(_I18N.getString("saveAs")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.saveAs();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _printPreviewAction = new AbstractAction(_I18N.getString("printPreview")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.printPreview();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _printAction = new AbstractAction(_I18N.getString("print") + "..."){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.print();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _cutLevelsAction = new AbstractAction(_I18N.getString("cutLevels")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.editCutLevels();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _colorsAction = new AbstractAction(_I18N.getString("colors")){

        public void actionPerformed(ActionEvent evt) {
            try {
                DivaMainImageDisplay.this.editColors();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    static /* synthetic */ Class class$jsky$image$gui$DivaMainImageDisplay;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public DivaMainImageDisplay(GraphicsPane pane) {
        this(pane, new ImageProcessor());
    }

    public DivaMainImageDisplay(GraphicsPane pane, ImageProcessor processor) {
        super(pane, processor, "Main Image");
        this.setDownloadState(false);
        this.updateEnabledStates();
        new MeasureBand(this);
        this._canvasDraw = new CanvasDraw(this);
        this._fitsGraphics = new FITSGraphics(this);
        this.loadHistory();
        this.cleanupHistoryList();
        if (this._firstTime) {
            this._firstTime = false;
            this.cleanupImageCache();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DivaMainImageDisplay.this.saveHistory(true);
            }
        });
    }

    public DivaMainImageDisplay() {
        this(new GraphicsPane());
    }

    public DivaMainImageDisplay(GraphicsPane pane, Component parent, ImageProcessor processor) {
        this(pane, processor);
        this._parent = parent;
    }

    public DivaMainImageDisplay(GraphicsPane pane, Component parent) {
        this(pane);
        this._parent = parent;
    }

    public DivaMainImageDisplay(Component parent) {
        this(new GraphicsPane());
        this._parent = parent;
    }

    public Component newWindow() {
        if (this._desktop != null) {
            ImageDisplayControlInternalFrame f = new ImageDisplayControlInternalFrame(this._desktop);
            f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
            this._desktop.add((Component)f, JLayeredPane.DEFAULT_LAYER);
            this._desktop.moveToFront(f);
            f.setVisible(true);
            return f;
        }
        ImageDisplayControlFrame f = new ImageDisplayControlFrame();
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
        f.setVisible(true);
        return f;
    }

    public CanvasDraw getCanvasDraw() {
        return this._canvasDraw;
    }

    public void setCanvasDraw(CanvasDraw canvasDraw) {
        this._canvasDraw = canvasDraw;
    }

    public void setFilename(String fileOrUrl) {
        if (fileOrUrl.startsWith("http:")) {
            this.setURL(FileUtil.makeURL(null, fileOrUrl));
            return;
        }
        if (!this.checkSave()) {
            return;
        }
        this.addToHistory();
        this._filename = fileOrUrl;
        this._url = this._origURL = FileUtil.makeURL(null, fileOrUrl);
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null) {
            fitsImage.close();
            fitsImage.clearTileCache();
            fitsImage = null;
        }
        if (this.isJAIImageType(this._filename)) {
            try {
                this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)this._filename));
            }
            catch (Exception e) {
                DialogUtil.error(e);
                this._filename = null;
                this._origURL = null;
                this._url = null;
                this.clear();
            }
        } else {
            try {
                fitsImage = new FITSImage(this._filename);
                this.initFITSImage(fitsImage);
                this.setImage(fitsImage);
            }
            catch (Exception e) {
                try {
                    this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)this._filename));
                }
                catch (Exception ex) {
                    DialogUtil.error(e);
                    this._filename = null;
                    this._origURL = null;
                    this._url = null;
                    this.clear();
                }
            }
            this.updateTitle();
        }
    }

    public void setFilename(String fileOrUrl, URL url) {
        this.setFilename(fileOrUrl);
        this._origURL = url;
    }

    public String getFilename() {
        return this._filename;
    }

    public boolean isJAIImageType(String filename) {
        return filename.endsWith("jpg") || filename.endsWith("jpeg") || filename.endsWith("gif") || filename.endsWith("tif") || filename.endsWith("tiff") || filename.endsWith("ppm") || filename.endsWith("png") || filename.endsWith("pgm") || filename.endsWith("pnm") || filename.endsWith("bmp");
    }

    public void clear() {
        super.clear();
        this.updateEnabledStates();
    }

    public void displayFITSTable(int hdu) {
    }

    public String getObjectName() {
        Object o;
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null && (o = fitsImage.getKeywordValue("OBJECT")) instanceof String) {
            return o.toString();
        }
        return null;
    }

    public void setURL(URL url) {
        this._origURL = url;
        String s = url.getProtocol();
        if (s.equals("file")) {
            this.setFilename(url.getFile());
        } else if (s.equals("http")) {
            this.downloadImageToTempFile(url);
        } else {
            DialogUtil.error("Unsupported URL syntax: " + s);
            return;
        }
    }

    public URL getURL() {
        return this._url;
    }

    protected void initFITSImage(FITSImage fitsImage) throws IOException, FitsException {
        ImageHistoryItem hi;
        float scale;
        int numHDUs = fitsImage.getNumHDUs();
        if (numHDUs >= 2 && fitsImage.isEmpty() && fitsImage.getHDU(1) instanceof ImageHDU) {
            fitsImage.setHDU(1);
        }
        if ((scale = (hi = this.getImageHistoryItem(new File(this._filename))) != null ? hi.scale : this.getScale()) != 1.0f) {
            fitsImage.setScale(scale);
        }
    }

    public void updateImageData() {
        if (this._filename != null) {
            this.setFilename(this._filename);
        } else if (this._url != null) {
            this.setURL(this._url);
        }
    }

    protected void addToHistory() {
        if (this._filename == null) {
            return;
        }
        ImageHistoryItem historyItem = this.makeImageHistoryItem();
        if (!this._noStack) {
            this._backStack.push(historyItem);
            this._backAction.setEnabled(true);
            if (this._forwStack.size() != 0) {
                this._forwStack.clear();
                this._forwAction.setEnabled(false);
            }
        }
        this.addToHistory(historyItem);
    }

    protected void addToHistory(ImageHistoryItem historyItem) {
        ImageHistoryItem item;
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            item = (ImageHistoryItem)it.next();
            if (item.title.equals(historyItem.title)) {
                this._historyList.remove(i);
            }
            ++i;
        }
        this._historyList.addFirst(historyItem);
        if (this._historyList.size() > this._maxHistoryItems) {
            item = (ImageHistoryItem)this._historyList.removeLast();
            String cacheDir = Preferences.getPreferences().getCacheDir().getPath();
            if (item.filename.startsWith(cacheDir)) {
                new File(item.filename).deleteOnExit();
            }
        }
    }

    protected ImageHistoryItem makeImageHistoryItem() {
        String object;
        double ra = Double.NaN;
        double dec = Double.NaN;
        String radecStr = "";
        if (this.isWCS()) {
            WorldCoordinateConverter wcs = this.getWCS();
            WorldCoords center = new WorldCoords(wcs.getWCSCenter(), wcs.getEquinox());
            radecStr = radecStr + center.toString();
            ra = center.getRaDeg();
            dec = center.getDecDeg();
        }
        String name = "";
        if (this._filename != null) {
            name = new File(this._filename).getName();
        }
        object = (object = this.getObjectName()) == null || object.startsWith("dss") ? "" : object + ": ";
        String title = name;
        if (object.length() != 0 || radecStr.length() != 0) {
            title = title + " [" + object + radecStr + "]";
        }
        return new ImageHistoryItem(this, ra, dec, title, this._origURL, this._filename);
    }

    public int getMaxHistoryItems() {
        return this._maxHistoryItems;
    }

    public void setMaxHistoryItems(int n) {
        this._maxHistoryItems = n;
    }

    protected LinkedList mergeHistoryList() {
        Object[] items = this._historyList.toArray();
        this.loadHistory();
        int i = items.length - 1;
        while (i >= 0) {
            this.addToHistory((ImageHistoryItem)items[i]);
            --i;
        }
        return this._historyList;
    }

    protected void clearHistory() {
        String cacheDir = Preferences.getPreferences().getCacheDir().getPath();
        ListIterator it = this._historyList.listIterator(0);
        while (it.hasNext()) {
            File file;
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            if (!historyItem.filename.startsWith(cacheDir) || !(file = new File(historyItem.filename)).exists()) continue;
            try {
                file.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._historyList = new LinkedList();
        this._backAction.setEnabled(false);
        this._backStack.clear();
        this._forwAction.setEnabled(false);
        this._forwStack.clear();
        this.saveHistory(false);
    }

    protected void saveHistory(boolean merge) {
        try {
            LinkedList l = merge ? this.mergeHistoryList() : this._historyList;
            Preferences.getPreferences().serialize(HISTORY_LIST_NAME, l);
        }
        catch (Exception e) {}
    }

    protected void loadHistory() {
        try {
            this._historyList = (LinkedList)Preferences.getPreferences().deserialize(HISTORY_LIST_NAME);
        }
        catch (Exception e) {
            this._historyList = new LinkedList();
        }
    }

    protected void cleanupHistoryList() {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            File file = new File(historyItem.filename);
            if (file.exists()) continue;
            this._historyList.remove(historyItem);
        }
    }

    protected void cleanupImageCache() {
        String cacheDir = Preferences.getPreferences().getCacheDir().getPath();
        File dir = new File(cacheDir);
        if (dir.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("jsky");
                }
            };
            File[] files = dir.listFiles(filter);
            int i = 0;
            while (i < files.length) {
                if (!this.fileInHistoryList(files[i])) {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    public boolean fileInHistoryList(File file) {
        return this.getImageHistoryItem(file) != null;
    }

    protected ImageHistoryItem getImageHistoryItem(File file) {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            File f = new File(historyItem.filename);
            if (!f.equals(file)) continue;
            return historyItem;
        }
        return null;
    }

    protected void initProgressPanel() {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel("Downloading image data ...", this._parent);
            this._progressPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DivaMainImageDisplay.this._worker != null) {
                        DivaMainImageDisplay.this._worker.interrupt();
                        DivaMainImageDisplay.this._worker = null;
                    }
                }
            });
        }
        this._progressPanel.start();
    }

    protected void loadImageFromURL(final URL url) {
        if (!this.checkSave()) {
            return;
        }
        this.addToHistory();
        this._url = this._origURL = url;
        this._filename = null;
        this.initProgressPanel();
        this._worker = new SwingWorker(){

            public Object construct() {
                DivaMainImageDisplay.this.setDownloadState(true);
                try {
                    ProgressBarFilterInputStream in = DivaMainImageDisplay.this._progressPanel.getLoggedInputStream(url);
                    SeekableStream stream = SeekableStream.wrapInputStream((InputStream)in, (boolean)true);
                    DivaMainImageDisplay.this.setImage((PlanarImage)JAI.create((String)"stream", (Object)stream));
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }

            public void finished() {
                DivaMainImageDisplay.this._progressPanel.stop();
                Object o = this.getValue();
                if (o instanceof Exception && !(o instanceof ProgressException)) {
                    DialogUtil.error((Exception)o);
                }
                DivaMainImageDisplay.this.setDownloadState(false);
                DivaMainImageDisplay.this._worker = null;
            }
        };
        this._worker.start();
    }

    protected void downloadImageToTempFile(final URL url) {
        this.initProgressPanel();
        this._worker = new SwingWorker(){
            String filename;

            public Object construct() {
                DivaMainImageDisplay.this.setDownloadState(true);
                try {
                    String suffix = FileUtil.getSuffix(url.getPath());
                    if (suffix.equals("")) {
                        suffix = ".tmp";
                    }
                    String dir = Preferences.getPreferences().getCacheDir().getPath();
                    File file = File.createTempFile("jsky", suffix, new File(dir));
                    ProgressBarFilterInputStream in = DivaMainImageDisplay.this._progressPanel.getLoggedInputStream(url);
                    FileOutputStream out = new FileOutputStream(file);
                    FileUtil.copy(in, out);
                    in.close();
                    out.close();
                    this.filename = file.toString();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }

            public void finished() {
                DivaMainImageDisplay.this._progressPanel.stop();
                DivaMainImageDisplay.this.setDownloadState(false);
                DivaMainImageDisplay.this._worker = null;
                Object o = this.getValue();
                if (o instanceof Exception && !(o instanceof ProgressException)) {
                    DialogUtil.error((Exception)o);
                    return;
                }
                if (!DivaMainImageDisplay.this._progressPanel.isInterrupted()) {
                    DivaMainImageDisplay.this.setFilename(this.filename);
                }
            }
        };
        this._worker.start();
    }

    protected void setDownloadState(boolean downloading) {
        if (downloading) {
            this._backAction.setEnabled(false);
            this._forwAction.setEnabled(false);
            this._openAction.setEnabled(false);
        } else {
            this._backAction.setEnabled(this._backStack.size() > 0);
            this._forwAction.setEnabled(this._forwStack.size() > 0);
            this._openAction.setEnabled(true);
        }
    }

    protected void updateEnabledStates() {
        boolean fileLoaded = this._filename != null;
        boolean imageLoaded = fileLoaded || this._url != null;
        this._saveAction.setEnabled(fileLoaded && this.saveNeeded);
        this._saveAsAction.setEnabled(imageLoaded);
        this._cutLevelsAction.setEnabled(imageLoaded);
        this._colorsAction.setEnabled(imageLoaded);
    }

    public void back() {
        if (this._backStack.size() == 0) {
            return;
        }
        if (!this.checkSave()) {
            return;
        }
        if (this._filename != null) {
            this._forwStack.push(this.makeImageHistoryItem());
            this._forwAction.setEnabled(true);
        }
        ImageHistoryItem historyItem = (ImageHistoryItem)this._backStack.pop();
        if (this._backStack.size() == 0) {
            this._backAction.setEnabled(false);
        }
        ImageDisplayMenuBar.setCurrentImageDisplay(this);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
    }

    public void forward() {
        if (this._forwStack.size() == 0) {
            return;
        }
        if (!this.checkSave()) {
            return;
        }
        if (this._filename != null) {
            this._backStack.push(this.makeImageHistoryItem());
            this._backAction.setEnabled(true);
        }
        ImageHistoryItem historyItem = (ImageHistoryItem)this._forwStack.pop();
        if (this._forwStack.size() == 0) {
            this._forwAction.setEnabled(false);
        }
        ImageDisplayMenuBar.setCurrentImageDisplay(this);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
    }

    public void loadCachedImage(double ra, double dec) {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            File file = new File(historyItem.filename);
            if (!file.exists()) {
                this._historyList.remove(historyItem);
                continue;
            }
            if (!historyItem.match(ra, dec)) continue;
            if (this._filename != null && this._filename.equals(historyItem.filename)) {
                return;
            }
            ImageDisplayMenuBar.setCurrentImageDisplay(this);
            historyItem.actionPerformed(null);
            return;
        }
        this.blankImage(ra, dec);
    }

    public void addHistoryMenuItems(JMenu menu) {
        ListIterator it = this._historyList.listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            File file = new File(historyItem.filename);
            if (!file.exists()) {
                it.remove();
                continue;
            }
            menu.add(historyItem);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DivaMainImageDisplay.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = DivaMainImageDisplay.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChange(ImageChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ChangeListener == null ? DivaMainImageDisplay.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            i -= 2;
        }
        e.reset();
    }

    public boolean isMainWindow() {
        return true;
    }

    public void exit() {
        if (!this.checkSave()) {
            return;
        }
        System.exit(0);
    }

    protected void newImage(boolean before) {
        super.newImage(before);
        if (!before) {
            this.checkExtensions(false);
            this._fitsGraphics.loadGraphicsFromImage(".GRAPHICS");
            this.updateEnabledStates();
        }
        this._imageChangeEvent.setNewImage(true);
        this._imageChangeEvent.setBefore(before);
        this.fireChange(this._imageChangeEvent);
    }

    protected void updateImage(PlanarImage im) {
        super.updateImage(im);
        if (im == null) {
            this.fireChange(this._imageChangeEvent);
            return;
        }
        this.fireChange(this._imageChangeEvent);
    }

    public void setOrigin(Point2D.Double origin) {
        super.setOrigin(origin);
        this._imageChangeEvent.setNewOrigin(true);
    }

    public void setScale(float scale) {
        super.setScale(scale);
        this._imageChangeEvent.setNewScale(true);
    }

    public void checkExtensions(boolean show) {
        boolean skipEmptyPrimary;
        FITSImage fitsImage = this.getFitsImage();
        int numHDUs = 0;
        if (fitsImage == null || (numHDUs = fitsImage.getNumHDUs()) <= 1) {
            if (this._fitsHDUChooser != null) {
                this._fitsHDUChooser.clear();
                this._fitsHDUChooser.setShow(false);
            }
            return;
        }
        if (!show) {
            show = this._fitsHDUChooserFrame != null && this._fitsHDUChooserFrame.isVisible();
        }
        int currentHDU = fitsImage.getCurrentHDUIndex();
        boolean bl = skipEmptyPrimary = numHDUs >= 2 && currentHDU == 0 && fitsImage.isEmpty() && fitsImage.getHDU(1) instanceof ImageHDU;
        if (!show) {
            boolean bl2 = show = skipEmptyPrimary && numHDUs > 2;
        }
        if (!show && numHDUs <= 1) {
            return;
        }
        if (this._fitsHDUChooser != null) {
            this._fitsHDUChooser.updateDisplay(fitsImage);
        } else if (this._desktop != null) {
            this._fitsHDUChooserFrame = new FITSHDUChooserInternalFrame(this, fitsImage);
            this._desktop.add(this._fitsHDUChooserFrame, JLayeredPane.POPUP_LAYER);
            this._desktop.moveToFront(this._fitsHDUChooserFrame);
            this._fitsHDUChooser = ((FITSHDUChooserInternalFrame)this._fitsHDUChooserFrame).getFitsHDUChooser();
        } else {
            this._fitsHDUChooserFrame = new FITSHDUChooserFrame(this, fitsImage);
            this._fitsHDUChooser = ((FITSHDUChooserFrame)this._fitsHDUChooserFrame).getFitsHDUChooser();
        }
        if (skipEmptyPrimary) {
            this._fitsHDUChooser.selectImage(1);
        }
        this._fitsHDUChooser.setShow(show);
    }

    public void saveGraphicsWithImage() {
        try {
            this._fitsGraphics.saveGraphicsWithImage(".GRAPHICS");
            this.setSaveNeeded(true);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void close() {
        if (this.isMainWindow()) {
            if (!this.checkSave()) {
                return;
            }
            this.dispose();
        } else if (this._parent != null) {
            this._parent.setVisible(false);
        }
    }

    public void dispose() {
        if (this._imageCutLevelsFrame != null) {
            if (this._imageCutLevelsFrame instanceof JFrame) {
                ((JFrame)this._imageCutLevelsFrame).dispose();
            } else {
                ((JInternalFrame)this._imageCutLevelsFrame).dispose();
            }
        }
        if (this._imagePropertiesFrame != null) {
            if (this._imagePropertiesFrame instanceof JFrame) {
                ((JFrame)this._imagePropertiesFrame).dispose();
            } else {
                ((JInternalFrame)this._imagePropertiesFrame).dispose();
            }
        }
        if (this._imageColorsFrame != null) {
            if (this._imageColorsFrame instanceof JFrame) {
                ((JFrame)this._imageColorsFrame).dispose();
            } else {
                ((JInternalFrame)this._imageColorsFrame).dispose();
            }
        }
        if (this._pickObjectFrame != null) {
            if (this._pickObjectFrame instanceof JFrame) {
                ((JFrame)this._pickObjectFrame).dispose();
            } else {
                ((JInternalFrame)this._pickObjectFrame).dispose();
            }
        }
        if (this._fitsHDUChooserFrame != null) {
            if (this._fitsHDUChooserFrame instanceof JFrame) {
                ((JFrame)this._fitsHDUChooserFrame).dispose();
            } else {
                ((JInternalFrame)this._fitsHDUChooserFrame).dispose();
            }
        }
        if (this._parent instanceof JFrame) {
            ((JFrame)this._parent).dispose();
        } else if (this._parent instanceof JInternalFrame) {
            ((JInternalFrame)this._parent).dispose();
        }
    }

    public void editCutLevels() {
        if (this._imageCutLevelsFrame != null) {
            SwingUtil.showFrame(this._imageCutLevelsFrame);
        } else if (this._desktop != null) {
            this._imageCutLevelsFrame = new ImageCutLevelsInternalFrame(this);
            this._desktop.add(this._imageCutLevelsFrame, JLayeredPane.POPUP_LAYER);
            this._desktop.moveToFront(this._imageCutLevelsFrame);
        } else {
            this._imageCutLevelsFrame = new ImageCutLevelsFrame(this);
        }
    }

    public void editColors() {
        if (this._imageColorsFrame != null) {
            SwingUtil.showFrame(this._imageColorsFrame);
        } else if (this._desktop != null) {
            this._imageColorsFrame = new ImageColorsInternalFrame(this);
            this._desktop.add(this._imageColorsFrame, JLayeredPane.POPUP_LAYER);
            this._desktop.moveToFront(this._imageColorsFrame);
        } else {
            this._imageColorsFrame = new ImageColorsFrame(this);
        }
    }

    public void pickObject() {
        if (this._pickObjectFrame != null) {
            SwingUtil.showFrame(this._pickObjectFrame);
        } else {
            if (this._desktop != null) {
                this._pickObjectFrame = new PickObjectInternalFrame(this);
                this._pickObjectPanel = ((PickObjectInternalFrame)this._pickObjectFrame).getPickObject();
                this._desktop.add(this._pickObjectFrame, JLayeredPane.DEFAULT_LAYER);
                this._desktop.moveToFront(this._pickObjectFrame);
            } else {
                this._pickObjectFrame = new PickObjectFrame(this);
                this._pickObjectPanel = ((PickObjectFrame)this._pickObjectFrame).getPickObject();
            }
            this._pickObjectPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DivaMainImageDisplay.this.pickedObject();
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DivaMainImageDisplay.this._pickObjectPanel.pickObject();
            }
        });
    }

    protected void pickedObject() {
    }

    public void viewFitsExtensions() {
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null && fitsImage.getNumHDUs() > 1) {
            this.checkExtensions(true);
        } else {
            DialogUtil.error("There are no FITS extensions for this image.");
        }
    }

    public void viewFitsKeywords() {
        if (this._fitsKeywordsFrame != null) {
            SwingUtil.showFrame(this._fitsKeywordsFrame);
            if (this._fitsKeywordsFrame instanceof FITSKeywordsFrame) {
                ((FITSKeywordsFrame)this._fitsKeywordsFrame).getFITSKeywords().updateDisplay();
            } else if (this._fitsKeywordsFrame instanceof FITSKeywordsInternalFrame) {
                ((FITSKeywordsInternalFrame)this._fitsKeywordsFrame).getFITSKeywords().updateDisplay();
            }
        } else if (this._desktop != null) {
            this._fitsKeywordsFrame = new FITSKeywordsInternalFrame(this);
            this._desktop.add(this._fitsKeywordsFrame, JLayeredPane.POPUP_LAYER);
            this._desktop.moveToFront(this._fitsKeywordsFrame);
        } else {
            this._fitsKeywordsFrame = new FITSKeywordsFrame(this);
        }
    }

    public void viewImageProperties() {
        if (this._imagePropertiesFrame != null) {
            SwingUtil.showFrame(this._imagePropertiesFrame);
            if (this._imagePropertiesFrame instanceof ImagePropertiesFrame) {
                ((ImagePropertiesFrame)this._imagePropertiesFrame).getImageProperties().updateDisplay();
            } else if (this._imagePropertiesFrame instanceof ImagePropertiesInternalFrame) {
                ((ImagePropertiesInternalFrame)this._imagePropertiesFrame).getImageProperties().updateDisplay();
            }
        } else if (this._desktop != null) {
            this._imagePropertiesFrame = new ImagePropertiesInternalFrame(this);
            this._desktop.add(this._imagePropertiesFrame, JLayeredPane.POPUP_LAYER);
            this._desktop.moveToFront(this._imagePropertiesFrame);
        } else {
            this._imagePropertiesFrame = new ImagePropertiesFrame(this);
        }
    }

    public JDesktopPane getDesktop() {
        return this._desktop;
    }

    public void setDesktop(JDesktopPane desktop) {
        this._desktop = desktop;
    }

    public Component getRootComponent() {
        return this._parent;
    }

    public void open() {
        int option;
        if (this._fileChooser == null) {
            this._fileChooser = DivaMainImageDisplay.makeImageFileChooser();
        }
        if ((option = this._fileChooser.showOpenDialog((Component)((Object)this))) == 0 && this._fileChooser.getSelectedFile() != null) {
            this.setFilename(this._fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static JFileChooser makeImageFileChooser() {
        JFileChooser _fileChooser = new JFileChooser(new File("."));
        LookAndFeelMenu.addWindow(_fileChooser);
        ExampleFileFilter fitsFilter = new ExampleFileFilter(new String[]{"fits", "fits.gz", "fits.Z", "hfits"}, "FITS Image Files");
        _fileChooser.addChoosableFileFilter(fitsFilter);
        ExampleFileFilter jpgFilter = new ExampleFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Compressed Image Files");
        _fileChooser.addChoosableFileFilter(jpgFilter);
        ExampleFileFilter gifFilter = new ExampleFileFilter("gif", "GIF Image Files");
        _fileChooser.addChoosableFileFilter(gifFilter);
        ExampleFileFilter tifFilter = new ExampleFileFilter(new String[]{"tif", "tiff"}, "TIFF Image Files");
        _fileChooser.addChoosableFileFilter(tifFilter);
        ExampleFileFilter ppmFilter = new ExampleFileFilter(new String[]{"ppm", "png", "pgm"}, "PPM Image Files");
        _fileChooser.addChoosableFileFilter(ppmFilter);
        _fileChooser.setFileFilter(fitsFilter);
        return _fileChooser;
    }

    public JFileChooser getFileChooser() {
        return this._fileChooser;
    }

    public void setFileChooser(JFileChooser chooser) {
        this._fileChooser = chooser;
    }

    public void openURL() {
        String urlStr = DialogUtil.input("Enter the World Wide Web location (URL) to display:");
        if (urlStr != null) {
            URL url = null;
            try {
                url = new URL(urlStr);
            }
            catch (Exception e) {
                DialogUtil.error(e);
                return;
            }
            this.setURL(url);
        }
    }

    public void blankImage(double ra, double dec) {
        if (!this.checkSave()) {
            return;
        }
        this.addToHistory();
        super.blankImage(ra, dec);
        this._filename = null;
        this._url = null;
        this._origURL = null;
        this.updateEnabledStates();
    }

    public void setSaveNeeded(boolean b) {
        this.saveNeeded = b;
        this._imageChangeEvent.setEditStateChanged(true);
        this.fireChange(this._imageChangeEvent);
    }

    public boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    protected boolean checkSave() {
        if (this.saveNeeded) {
            String s = this._filename;
            s = s != null ? new File(s).getName() : (this._url != null ? this._url.toString() : "unknown");
            int ans = DialogUtil.confirm("Save changes to '" + s + "'?");
            if (ans == 0) {
                if (this._filename != null) {
                    this.save();
                } else {
                    this.saveAs();
                }
            } else if (ans == 2) {
                return false;
            }
            this.setSaveNeeded(false);
        }
        return true;
    }

    public void save() {
        if (this._filename != null) {
            this.saveAs(this._filename);
        } else {
            this.saveAs();
        }
    }

    public void saveAs() {
        if (this._saveDialog == null) {
            this._saveDialog = new ImageSaveDialog(this);
        }
        this._saveDialog.save();
    }

    public void saveAs(String filename) {
        String s = filename.toLowerCase();
        String tmpFile = filename + ".TMP";
        File tf = new File(tmpFile);
        if (tf.exists() && !tf.delete()) {
            DialogUtil.error("Can't delete temp file: " + tmpFile);
            return;
        }
        if (s.endsWith(".jpeg") || s.endsWith(".jpg")) {
            JAI.create((String)"filestore", (RenderedImage)this.getDisplayImage(), (Object)tmpFile, (Object)"JPEG", (Object)new JPEGEncodeParam());
        } else if (s.endsWith(".png")) {
            JAI.create((String)"filestore", (RenderedImage)this.getImage(), (Object)tmpFile, (Object)"PNG", (Object)new PNGEncodeParam.Gray());
        } else if (s.endsWith(".pnm")) {
            JAI.create((String)"filestore", (RenderedImage)this.getImage(), (Object)tmpFile, (Object)"PNM", (Object)new PNMEncodeParam());
        } else if (s.endsWith(".tiff") || s.endsWith(".tif")) {
            JAI.create((String)"filestore", (RenderedImage)this.getImage(), (Object)tmpFile, (Object)"TIFF", (Object)new TIFFEncodeParam());
        } else if (s.endsWith(".bmp")) {
            JAI.create((String)"filestore", (RenderedImage)this.getDisplayImage(), (Object)tmpFile, (Object)"BMP", (Object)new BMPEncodeParam());
        } else {
            FITSImage fitsImage = this.getFitsImage();
            if (fitsImage != null && this._url != null) {
                try {
                    BufferedFile bf = new BufferedFile(tmpFile, "rw");
                    fitsImage.getFits().write((DataOutput)bf);
                    bf.close();
                    fitsImage.getFits().getStream().close();
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                }
            } else {
                DialogUtil.error("Can't determine image format for: " + filename);
            }
        }
        File file = new File(filename);
        if (file.exists()) {
            File backup = new File(filename + ".BAK");
            if (backup.exists() && !backup.delete()) {
                DialogUtil.error("Can't delete backup file: " + backup);
                return;
            }
            if (!file.renameTo(backup)) {
                DialogUtil.error("Rename " + file + " to " + backup + " failed");
                return;
            }
        }
        if (!new File(tmpFile).renameTo(file)) {
            DialogUtil.error("Rename " + tmpFile + " to " + file + " failed");
            return;
        }
        this.setSaveNeeded(false);
        this._noStack = true;
        try {
            this.setFilename(filename);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
    }

    public void paintImageAndGraphics(Graphics2D g2D) {
        this.getCanvasPane().paint(g2D);
    }

    public void printPreview() {
        if (this._printDialog == null) {
            this._printDialog = new ImagePrintDialog(this);
        }
        this._printDialog.preview();
    }

    public void print() {
        if (this._printDialog == null) {
            this._printDialog = new ImagePrintDialog(this);
        }
        this._printDialog.print();
    }

    public void setTitle(String s) {
        this._title = s;
        this.updateTitle();
    }

    public String getTitle() {
        return this._title;
    }

    protected void updateTitle() {
        String s = this._title;
        if (this._filename != null) {
            s = s + " - " + new File(this._filename).getName();
        }
        if (this._parent != null) {
            if (this._parent instanceof JFrame) {
                ((JFrame)this._parent).setTitle(s);
            } else {
                ((JInternalFrame)this._parent).setTitle(s);
            }
        }
    }

    public Component getParentFrame() {
        return this._parent;
    }

    public void setParentFrame(Component p) {
        this._parent = p;
    }

    public AbstractAction getOpenAction() {
        return this._openAction;
    }

    public AbstractAction getBackAction() {
        return this._backAction;
    }

    public AbstractAction getForwAction() {
        return this._forwAction;
    }

    public AbstractAction getColorsAction() {
        return this._colorsAction;
    }

    public AbstractAction getCutLevelsAction() {
        return this._cutLevelsAction;
    }

    public AbstractAction getSaveAction() {
        return this._saveAction;
    }

    public AbstractAction getSaveAsAction() {
        return this._saveAsAction;
    }

    public AbstractAction getPrintPreviewAction() {
        return this._printPreviewAction;
    }

    public AbstractAction getPrintAction() {
        return this._printAction;
    }

    public Component getImageCutLevelsFrame() {
        return this._imageCutLevelsFrame;
    }

    public Component getFitsKeywordsFrame() {
        return this._fitsKeywordsFrame;
    }

    public Component getImagePropertiesFrame() {
        return this._imagePropertiesFrame;
    }

    public Component getImageColorsFrame() {
        return this._imageColorsFrame;
    }

    public Component getPickObjectFrame() {
        return this._pickObjectFrame;
    }

    public PickObject getPickObjectPanel() {
        return this._pickObjectPanel;
    }

    public Component getFitsHDUChooserFrame() {
        return this._fitsHDUChooserFrame;
    }

    public FITSHDUChooser getFitsHDUChooser() {
        return this._fitsHDUChooser;
    }

    public FITSGraphics getFitsGraphics() {
        return this._fitsGraphics;
    }

    public WorldCoords getBasePos() {
        if (this.isWCS()) {
            WorldCoordinateConverter wcs = this.getWCS();
            return new WorldCoords(wcs.getWCSCenter(), wcs.getEquinox());
        }
        return new WorldCoords();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

