/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.media.jai.LookupTableJAI;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import jsky.image.BasicImageReadableProcessor;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;

public class ImageColorbar
extends JComponent
implements MouseInputListener {
    protected BasicImageReadableProcessor imageDisplay;
    protected ImageProcessor imageProcessor;
    protected int componentWidth;
    protected int componentHeight;
    protected int orient = 0;
    protected byte[][] lut;
    protected int mark;

    public ImageColorbar() {
        this.defaultColormap();
    }

    public ImageColorbar(BasicImageReadableProcessor imageDisplay) {
        this.orient = 0;
        this.setImageDisplay(imageDisplay);
    }

    public ImageColorbar(BasicImageReadableProcessor imageDisplay, int orient) {
        this.orient = orient;
        this.setImageDisplay(imageDisplay);
    }

    public void setImageDisplay(BasicImageReadableProcessor imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.imageProcessor = imageDisplay.getImageProcessor();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.imageProcessor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewColormap()) {
                    ImageColorbar.this.newColormap();
                }
            }
        });
        this.newColormap();
    }

    public int getOrient() {
        return this.orient;
    }

    public void setOrient(int orient) {
        this.orient = orient;
    }

    public void newColormap() {
        LookupTableJAI lutJAI = this.imageProcessor.getColorLookupTable();
        if (lutJAI != null) {
            this.lut = lutJAI.getByteData();
        } else {
            this.defaultColormap();
        }
        this.repaint();
    }

    protected void defaultColormap() {
        this.lut = new byte[3][256];
        int i = 0;
        while (i < 256) {
            this.lut[0][i] = (byte)i;
            this.lut[1][i] = (byte)i;
            this.lut[2][i] = (byte)i;
            ++i;
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.componentWidth = width;
        this.componentHeight = height;
        super.setBounds(x, y, width, height);
    }

    public synchronized void paintComponent(Graphics g) {
        block3: {
            block2: {
                Graphics2D g2D = (Graphics2D)g;
                g2D.setColor(this.getBackground());
                g2D.fillRect(0, 0, this.componentWidth, this.componentHeight);
                if (this.orient != 0) break block2;
                float slope = (float)this.componentWidth / 256.0f;
                int n = 0;
                while (n < this.lut[0].length) {
                    int w = this.componentWidth - (int)((float)n * slope);
                    int v = this.lut[0].length - n - 1;
                    int red = this.lut[0][v] & 0xFF;
                    int green = this.lut[1][v] & 0xFF;
                    int blue = this.lut[2][v] & 0xFF;
                    g.setColor(new Color(red, green, blue));
                    g.fillRect(0, 0, w, this.componentHeight);
                    ++n;
                }
                break block3;
            }
            if (this.orient != 1) break block3;
            float slope = (float)this.componentHeight / 256.0f;
            int n = 0;
            while (n < this.lut[0].length) {
                int h = this.componentHeight - (int)((float)n * slope);
                int red = this.lut[0][n] & 0xFF;
                int green = this.lut[1][n] & 0xFF;
                int blue = this.lut[2][n] & 0xFF;
                g.setColor(new Color(red, green, blue));
                g.fillRect(0, 0, this.componentWidth, h);
                ++n;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mark = e.getX();
        if ((e.getModifiers() & 0x10) == 0) {
            this.imageProcessor.resetColormap();
            this.imageProcessor.update();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int amount = e.getX() - this.mark;
        if ((e.getModifiers() & 0x10) != 0) {
            if (e.isShiftDown()) {
                this.imageProcessor.rotateColormap(amount);
                this.mark = e.getX();
                this.imageProcessor.update();
            } else {
                this.imageProcessor.shiftColormap(amount);
                this.imageProcessor.update();
            }
        } else {
            this.imageProcessor.scaleColormap(amount);
            this.imageProcessor.update();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.imageProcessor.saveColormap();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

