/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.PrintPreview;
import jsky.util.gui.ProgressPanel;

public class ImagePrintDialog
implements Printable,
ActionListener {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImagePrintDialog == null ? (class$jsky$image$gui$ImagePrintDialog = ImagePrintDialog.class$("jsky.image.gui.ImagePrintDialog")) : class$jsky$image$gui$ImagePrintDialog);
    protected MainImageDisplay imageDisplay;
    protected ProgressPanel progressPanel;
    private static final Font PRINTING_FONT = Font.decode("SansSerif-8");
    private boolean fNewPrint;
    private double fPrintOffsetX;
    private double fPrintOffsetY;
    private final SimpleDateFormat fDateFormatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    static /* synthetic */ Class class$jsky$image$gui$ImagePrintDialog;

    public ImagePrintDialog(MainImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    public void preview() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    String title = ImagePrintDialog.this.imageDisplay.getObjectName();
                    if (title == null) {
                        title = ImagePrintDialog.this.imageDisplay.getFilename();
                    }
                    if (title == null) {
                        title = _I18N.getString("printPreview");
                    }
                    ImagePrintDialog.this.startPrint(_I18N.getString("preparingImage"));
                    return new PrintPreview(ImagePrintDialog.this, ImagePrintDialog.this, title);
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                ImagePrintDialog.this.progressPanel.stop();
                ImagePrintDialog.this.progressPanel.setTitle(_I18N.getString("printingImage"));
                Object o = this.getValue();
                if (o instanceof Exception) {
                    DialogUtil.error((Exception)o);
                }
            }
        };
        worker.start();
    }

    public void actionPerformed(ActionEvent e) {
        this.print();
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setJobName(_I18N.getString("imageDisplay"));
        PageFormat format = job.pageDialog(job.defaultPage());
        Book document = new Book();
        document.append(this, format);
        job.setPageable(document);
        if (job.printDialog()) {
            this.startPrint(_I18N.getString("printing"));
            new PrintWorker(job).start();
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)g;
        JComponent canvas = this.imageDisplay.getCanvas();
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        if (pageIndex > 0) {
            return 1;
        }
        boolean progress = true;
        if (this.fNewPrint) {
            this.fNewPrint = false;
            progress = false;
            Rectangle r = g2d.getClipBounds();
            if (r != null) {
                this.fPrintOffsetX = r.x;
                this.fPrintOffsetY = r.y;
            }
        }
        double scale = Math.min((pf.getImageableWidth() - 20.0) / (double)canvasWidth, (pf.getImageableHeight() - 20.0) / (double)canvasHeight);
        String footer = this.imageDisplay.getObjectName();
        if (footer == null) {
            footer = this.imageDisplay.getFilename();
        }
        if (footer == null) {
            if (this.imageDisplay.isWCS()) {
                WorldCoordinateConverter wcc = this.imageDisplay.getWCS();
                WorldCoords center = new WorldCoords(wcc.getWCSCenter(), wcc.getEquinox());
                footer = center.toString();
            } else {
                footer = _I18N.getString("blankImage");
            }
        }
        FontMetrics metrics = canvas.getFontMetrics(PRINTING_FONT);
        int width = metrics.stringWidth(footer) + 6;
        int height = metrics.getHeight() + 4;
        g2d.setColor(Color.black);
        g2d.setFont(PRINTING_FONT);
        g2d.drawString(footer, (float)this.fPrintOffsetX, (float)((double)(canvasHeight + height) * scale + pf.getImageableY()));
        footer = this.fDateFormatter.format(new Date());
        width = metrics.stringWidth(footer) + 6;
        g2d.drawString(footer, (float)(this.fPrintOffsetX + (double)(canvasWidth - width) * scale - 15.0), (float)((double)(canvasHeight + height) * scale + pf.getImageableY()));
        g2d.translate(this.fPrintOffsetX, this.fPrintOffsetY);
        g2d.scale(scale, scale);
        int y = 0;
        int x = 0;
        int h = canvasHeight;
        int w = canvasWidth;
        if (g2d.getClipBounds() != null) {
            x = g2d.getClipBounds().x;
            y = g2d.getClipBounds().y;
            w = g2d.getClipBounds().width;
            h = g2d.getClipBounds().height;
            if (x + w > canvasWidth) {
                w = canvasWidth;
            }
            if (y + h > canvasHeight) {
                h = Math.max(0, canvasHeight - y);
            }
        }
        g2d.setClip(x, y, w, h);
        this.imageDisplay.paintImageAndGraphics(g2d);
        if (progress) {
            int percent = (int)Math.min(100.0, Math.floor((double)(y + h) / (double)canvasHeight * 100.0));
            this.progressPanel.setProgress(percent);
        }
        return 0;
    }

    public void startPrint(String msg) {
        this.fNewPrint = true;
        this.fPrintOffsetX = 0.0;
        this.fPrintOffsetY = 0.0;
        if (this.progressPanel == null) {
            this.progressPanel = ProgressPanel.makeProgressPanel(msg);
        } else {
            this.progressPanel.setTitle(msg);
        }
        this.progressPanel.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PrintWorker
    extends SwingWorker {
        private PrinterJob fJob;

        public PrintWorker(PrinterJob job) {
            this.fJob = job;
        }

        public Object construct() {
            try {
                ImagePrintDialog.this.progressPanel.setProgress(5);
                this.fJob.print();
                ImagePrintDialog.this.progressPanel.setProgress(99);
            }
            catch (Exception ex) {
                DialogUtil.error(_I18N.getString("printError") + ": " + ex.toString());
            }
            return null;
        }

        public void finished() {
            ImagePrintDialog.this.progressPanel.stop();
        }
    }
}

