/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

import jsky.science.AbstractScienceObject;
import jsky.science.Coordinates;
import jsky.science.CoordinatesOffset;

public class ProperMotion
extends AbstractScienceObject {
    private CoordinatesOffset fOffset;
    private double fRaError;
    private double fDecError;
    private static final long serialVersionUID = 1L;
    public static final String OFFSET_PROPERTY = "Offset".intern();
    public static final String RAERROR_PROPERTY = "RaError".intern();
    public static final String DECERROR_PROPERTY = "DecError".intern();

    public ProperMotion() {
        this(0.0, 0.0);
    }

    public ProperMotion(ProperMotion pm) {
        this(pm.getOffset().getRa(), pm.getOffset().getDec(), pm.getRaError(), pm.getDecError());
    }

    public ProperMotion(double ra, double dec) {
        this(ra, dec, 0.0, 0.0);
    }

    public ProperMotion(double ra, double dec, String units) {
        this(ra, dec, 0.0, 0.0, units);
    }

    public ProperMotion(double ra, double dec, double raErr, double decErr, String units) {
        this(Coordinates.convert(ra, units, Coordinates.DEGREE), Coordinates.convert(dec, units, Coordinates.DEGREE), Coordinates.convert(raErr, units, Coordinates.DEGREE), Coordinates.convert(decErr, units, Coordinates.DEGREE));
    }

    public ProperMotion(double ra, double dec, double raErr, double decErr) {
        this.setOffset(new CoordinatesOffset(ra, dec));
        this.setRaError(raErr);
        this.setDecError(decErr);
    }

    public CoordinatesOffset getOffset() {
        return this.fOffset;
    }

    public void setOffset(CoordinatesOffset offset) {
        CoordinatesOffset old = this.fOffset;
        this.fOffset = offset;
        this.firePropertyChange(OFFSET_PROPERTY, old, this.fOffset);
    }

    public double getRaError() {
        return this.fRaError;
    }

    public double getDecError() {
        return this.fDecError;
    }

    public void setRaError(double err) {
        double hold = this.fRaError;
        this.fRaError = err;
        this.firePropertyChange(RAERROR_PROPERTY, new Double(hold), new Double(this.fRaError));
    }

    public void setDecError(double err) {
        double hold = this.fDecError;
        this.fDecError = err;
        this.firePropertyChange(DECERROR_PROPERTY, new Double(hold), new Double(this.fDecError));
    }

    public Coordinates computePosition(Coordinates oldPosition, double endYear) {
        return this.computePosition(oldPosition, endYear, oldPosition.getEpoch());
    }

    public Coordinates computePosition(Coordinates oldPosition, double endYear, double startYear) {
        return oldPosition.add(new CoordinatesOffset((endYear - startYear) * this.getOffset().getRa(), (endYear - startYear) * this.getOffset().getDec()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProperMotion)) {
            return false;
        }
        ProperMotion that = (ProperMotion)obj;
        return this.fRaError == that.fRaError && this.fDecError == that.fDecError;
    }

    public String toString() {
        return this.getOffset().getRa(Coordinates.ARCSEC) + ", " + this.getOffset().getDec(Coordinates.ARCSEC) + " +/- " + Coordinates.convert(this.fRaError, Coordinates.DEGREE, Coordinates.ARCSEC) + ", " + Coordinates.convert(this.fDecError, Coordinates.DEGREE, Coordinates.ARCSEC) + " arcsec/year";
    }
}

