/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jsky.science.Time;
import jsky.timeline.TimeLineModel;
import jsky.timeline.TimeLineNodeModel;

public class DefaultTimeLineModel
implements TimeLineModel {
    protected Comparator sComparator = new TimeLineNodeModel.TimeLineNodeComparator();
    protected List fNodes;
    protected List fChangeListeners;
    private int fIntervalCount;
    private Time fStartTime;
    private Time fEndTime;
    private Date fStartDate;
    protected PropertyChangeListener fMyChildListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            evt.setPropagationId(DefaultTimeLineModel.this);
            DefaultTimeLineModel.this.firePropertyChange(evt);
        }
    };

    public DefaultTimeLineModel(int interval) {
        this(0, 50, interval);
    }

    public DefaultTimeLineModel(int start, int end, int intervals) {
        this(new Time(start, Time.MINUTE), new Time(end, Time.MINUTE), intervals);
    }

    public DefaultTimeLineModel(Time start, Time end, int intervals) {
        this.fIntervalCount = intervals;
        this.fStartTime = start;
        this.fEndTime = end;
        this.fNodes = Collections.synchronizedList(new ArrayList(5));
        this.fChangeListeners = Collections.synchronizedList(new ArrayList(5));
    }

    public void addTimeLineNode(TimeLineNodeModel node) {
        if (!this.fNodes.contains(node)) {
            node.setParent(this);
            this.fNodes.add(node);
            node.addPropertyChangeListener(this.fMyChildListener);
            Collections.sort(this.fNodes, this.sComparator);
            this.updateExternal();
            this.firePropertyChange(new PropertyChangeEvent(this, "node added", null, node));
        }
    }

    public synchronized void removeTimeLineNode(TimeLineNodeModel node) {
        if (this.fNodes.contains(node)) {
            node.removePropertyChangeListener(this.fMyChildListener);
            node.setParent(null);
            this.fNodes.remove(node);
            this.firePropertyChange(new PropertyChangeEvent(node, "node removed", node, null));
        }
    }

    public void removeAllTimeLineNodes() {
        Iterator iter = this.fNodes.iterator();
        while (iter.hasNext()) {
            TimeLineNodeModel node = (TimeLineNodeModel)iter.next();
            node.removePropertyChangeListener(this.fMyChildListener);
            iter.remove();
        }
        this.firePropertyChange(new PropertyChangeEvent(this, "all nodes removed", this, null));
    }

    public int getIntervalCount() {
        return this.fIntervalCount;
    }

    public Iterator getTimeLineNodesIterator() {
        return this.fNodes.iterator();
    }

    public List getTimeLineNodes() {
        Collections.sort(this.fNodes, this.sComparator);
        return Collections.unmodifiableList(this.fNodes);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public Date getDateForTime(Time time) {
        Date result = null;
        if (this.fStartDate != null) {
            long dateMilliSecs = this.fStartDate.getTime();
            long timeMilliSecs = (long)(time.getValue(Time.SECOND) * 1000.0);
            result = new Date(dateMilliSecs + timeMilliSecs);
        }
        return result;
    }

    public Time getTimeForDate(Date date) {
        Time result = null;
        if (this.fStartDate != null) {
            double startMilliSecs = this.fStartDate.getTime();
            double dateMilliSecs = date.getTime();
            result = new Time((dateMilliSecs - startMilliSecs) / 1000.0, Time.SECOND);
        }
        return result;
    }

    public void setStartDate(Date date) {
        this.fStartDate = date;
    }

    public Date getStartDate() {
        return this.fStartDate;
    }

    public Time getStartTime() {
        return this.fStartTime;
    }

    public Time getEndTime() {
        return this.fEndTime;
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        Iterator listIterator = this.fChangeListeners.iterator();
        while (listIterator.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)listIterator.next();
            if (listener == evt.getSource()) continue;
            listener.propertyChange(evt);
        }
    }

    public boolean contains(TimeLineNodeModel model) {
        return this.fNodes.contains(model);
    }

    protected void updateExternal() {
    }
}

