/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.text.DecimalFormat;
import jsky.science.Time;
import jsky.timeline.DefaultVetoableTimeLineNodeModel;
import jsky.timeline.DetailedPropertyVetoException;
import jsky.timeline.TimeLine;
import jsky.timeline.TimeLineModel;
import jsky.timeline.TimeLineNode;
import jsky.timeline.TimeLineNodeModel;
import jsky.timeline.VetoableTimeLineNodeModel;

public class DefaultTimeLineNode
implements TimeLineNode {
    protected float fThumbHeight = 8.0f;
    protected float fHandleHeight = 12.0f;
    protected float fHandleWidth = 6.0f;
    protected Color fSelectedColor = new Color(102, 204, 255, 160);
    protected Color fUnselectedColor = Color.blue;
    protected VetoableTimeLineNodeModel fModel;
    protected int fMode = 0;
    protected int fDragMode = 0;
    protected VetoableChangeSupport fChangeSupport = null;
    protected float fThumbBegin = 0.0f;
    protected float fThumbEnd = 0.0f;
    protected BasicStroke fDefaultStroke = new BasicStroke();
    protected BasicStroke fShadowStroke = new BasicStroke(1.0f);
    protected Line2D.Float fThumbShadowLine = new Line2D.Float();
    protected Line2D.Float fThumbTopShadowLine = new Line2D.Float();
    protected Line2D.Float fLHandleTopShadowLine = new Line2D.Float();
    protected Line2D.Float fLHandleBottomShadowLine = new Line2D.Float();
    protected Line2D.Float fLHandleRightShadowLine = new Line2D.Float();
    protected Line2D.Float fLHandleLeftShadowLine = new Line2D.Float();
    protected Line2D.Float fRHandleTopShadowLine = new Line2D.Float();
    protected Line2D.Float fRHandleBottomShadowLine = new Line2D.Float();
    protected Line2D.Float fRHandleRightShadowLine = new Line2D.Float();
    protected Line2D.Float fRHandleLeftShadowLine = new Line2D.Float();
    protected Rectangle2D.Float fThumb = new Rectangle2D.Float();
    protected Rectangle2D.Float fLeftHandle = new Rectangle2D.Float();
    protected Rectangle2D.Float fRightHandle = new Rectangle2D.Float();
    protected TimeLine fTimeLine = null;
    protected boolean fForceRecalculation = false;
    protected VetoableChangeListener fMyVetoListener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            DefaultTimeLineNode.this.fChangeSupport.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };
    private float fTempMouseOffset = 0.0f;
    private float fTempThumbWidth = 0.0f;

    public DefaultTimeLineNode() {
    }

    public DefaultTimeLineNode(Time start, Time end) {
        this(start, end, "unknown");
    }

    public DefaultTimeLineNode(Time startTime, Time endTime, String name) {
        this.fModel = new DefaultVetoableTimeLineNodeModel(startTime, endTime, name);
        this.init();
    }

    public DefaultTimeLineNode(VetoableTimeLineNodeModel model) {
        this.fModel = model;
        this.init();
    }

    protected void init() {
        this.fChangeSupport = new VetoableChangeSupport(this);
        this.fModel.addVetoableChangeListener(this.fMyVetoListener);
    }

    public void setSelectionMode(int mode) {
        block3: {
            if (this.fMode == mode) break block3;
            int oldMode = this.fMode;
            try {
                this.fChangeSupport.fireVetoableChange("Mode", oldMode, mode);
                this.fMode = mode;
            }
            catch (DetailedPropertyVetoException ex) {
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int getSelectionMode() {
        return this.fMode;
    }

    public void setUnselectedColor(Color color) {
        block3: {
            if (color == this.fUnselectedColor) break block3;
            Color oldColor = this.fUnselectedColor;
            try {
                this.fUnselectedColor = color;
                this.fChangeSupport.fireVetoableChange("UnselectedColor", oldColor, color);
            }
            catch (DetailedPropertyVetoException ex) {
                this.fUnselectedColor = oldColor;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Color getUnselectedColor() {
        return this.fUnselectedColor;
    }

    public void setSelectedColor(Color color) {
        block3: {
            if (color == this.fSelectedColor) break block3;
            Color oldColor = this.fSelectedColor;
            try {
                this.fSelectedColor = color;
                this.fChangeSupport.fireVetoableChange("UnselectedColor", oldColor, color);
            }
            catch (DetailedPropertyVetoException ex) {
                this.fSelectedColor = oldColor;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Color getSelectedColor() {
        return this.fSelectedColor;
    }

    public Time getStartTime() {
        return this.fModel.getStartTime();
    }

    public void setStartTime(Time time) throws DetailedPropertyVetoException {
        if (time.getValue(Time.SECOND) != this.fModel.getStartTime().getValue(Time.SECOND)) {
            Time oldTime = this.fModel.getStartTime();
            try {
                this.fModel.setValidStartTime(time);
                Time displayEdge = this.fTimeLine.getDisplayStart();
                if (this.getStartTime().getValue() < displayEdge.getValue() && oldTime.getValue() >= displayEdge.getValue()) {
                    this.fChangeSupport.fireVetoableChange("HitLeftEdge", oldTime, time);
                    this.fForceRecalculation = true;
                }
            }
            catch (DetailedPropertyVetoException ex) {
                this.fForceRecalculation = true;
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void moveTimeLineNodeBy(Time time) throws DetailedPropertyVetoException {
        block5: {
            if (time.getValue() != 0.0) {
                Time oldStartTime = this.fModel.getStartTime();
                Time oldEndTime = this.fModel.getEndTime();
                try {
                    this.fModel.moveTimeLineNodeByValid(time);
                    if (this.fTimeLine == null) break block5;
                    if (time.getValue() < 0.0) {
                        Time displayEdge = this.fTimeLine.getDisplayStart();
                        if (!(this.getStartTime().getValue() < displayEdge.getValue()) || !(oldStartTime.getValue() >= displayEdge.getValue())) break block5;
                        this.fChangeSupport.fireVetoableChange("HitLeftEdge", oldStartTime, this.getStartTime());
                        this.fForceRecalculation = true;
                        break block5;
                    }
                    Time displayEdge = this.fTimeLine.getDisplayEnd();
                    if (!(this.getEndTime().getValue() > displayEdge.getValue()) || !(oldEndTime.getValue() <= displayEdge.getValue())) break block5;
                    this.fChangeSupport.fireVetoableChange("HitRightEdge", oldEndTime, time);
                    this.fForceRecalculation = true;
                }
                catch (DetailedPropertyVetoException ex) {
                    this.fModel.revertToPrevious();
                    this.fForceRecalculation = true;
                    throw ex;
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public Time getEndTime() {
        return this.fModel.getEndTime();
    }

    public void setEndTime(Time time) throws DetailedPropertyVetoException {
        block5: {
            if (time.getValue(Time.SECOND) != this.fModel.getEndTime().getValue(Time.SECOND)) {
                Time oldTime = this.fModel.getEndTime();
                try {
                    if (time.getValue(Time.SECOND) > this.getStartTime().getValue(Time.SECOND)) {
                        this.fModel.setValidEndTime(time);
                        Time displayEdge = this.fTimeLine.getDisplayEnd();
                        if (!(this.fModel.getEndTime().getValue() > displayEdge.getValue()) || !(oldTime.getValue() <= displayEdge.getValue())) break block5;
                        this.fChangeSupport.fireVetoableChange("HitRightEdge", oldTime, time);
                        this.fForceRecalculation = true;
                        break block5;
                    }
                    throw new DetailedPropertyVetoException(this, "The Node minimum size has been exceeded", "invalid end time", null);
                }
                catch (DetailedPropertyVetoException ex) {
                    this.fModel.revertToPrevious();
                    this.fForceRecalculation = true;
                    throw ex;
                }
                catch (PropertyVetoException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public Time getDuration() {
        return this.fModel.getDuration();
    }

    public void setDuration(Time durationLength) throws DetailedPropertyVetoException {
        if (this.fTimeLine != null) {
            Time val = this.getStartTime();
            this.setEndTime(new Time(this.fModel.getStartTime().getValue(Time.SECOND) + durationLength.getValue(Time.SECOND), Time.SECOND));
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.fChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.fChangeSupport.removeVetoableChangeListener(listener);
    }

    public void paintTimeLineNode(Graphics2D graphics) {
        Font origFont = graphics.getFont();
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Time startTime = this.fModel.getStartTime();
        Time endTime = this.fModel.getEndTime();
        boolean addHandles = true;
        if (!(startTime.getValue(Time.SECOND) > this.fTimeLine.getDisplayEnd().getValue(Time.SECOND)) && !(endTime.getValue(Time.SECOND) < this.fTimeLine.getDisplayStart().getValue(Time.SECOND))) {
            if (this.fDragMode == 0 || this.fForceRecalculation) {
                this.calculateNodeDimensions();
                this.fForceRecalculation = false;
            } else {
                float thumbMin = this.fTimeLine.getPointForTime(this.fTimeLine.getDisplayStart());
                float thumbMax = this.fTimeLine.getPointForTime(this.fTimeLine.getDisplayEnd());
                if (this.fThumbBegin < thumbMin) {
                    this.fThumbBegin = thumbMin;
                }
                if (this.fThumbEnd > thumbMax) {
                    this.fThumbEnd = thumbMax;
                }
            }
            float thumbLengthMin = 2.0f * this.fHandleWidth;
            float thumbWidth = this.fThumbEnd - this.fThumbBegin;
            float thumbHeight = this.fThumbHeight;
            if (thumbWidth < thumbLengthMin) {
                thumbHeight = this.fHandleHeight;
                addHandles = false;
            }
            this.fThumb.height = thumbHeight;
            this.fThumb.width = thumbWidth;
            this.fThumb.x = this.fThumbBegin;
            this.fThumb.y = (float)this.fTimeLine.getHeight() / 2.0f - thumbHeight / 2.0f;
            graphics.setStroke(this.fDefaultStroke);
            if (this.fMode == 2) {
                graphics.setColor(this.fSelectedColor);
            } else {
                graphics.setColor(this.fUnselectedColor);
            }
            graphics.draw(this.fThumb);
            graphics.fill(this.fThumb);
            this.fThumbShadowLine.x1 = this.fThumb.x;
            this.fThumbShadowLine.y1 = this.fThumb.y + thumbHeight;
            this.fThumbShadowLine.x2 = this.fThumb.x + thumbWidth;
            this.fThumbShadowLine.y2 = this.fThumb.y + thumbHeight;
            graphics.setStroke(this.fShadowStroke);
            graphics.setColor(Color.black);
            graphics.draw(this.fThumbShadowLine);
            this.fThumbTopShadowLine.x1 = this.fThumb.x;
            this.fThumbTopShadowLine.y1 = this.fThumb.y;
            this.fThumbTopShadowLine.x2 = this.fThumb.x + thumbWidth;
            this.fThumbTopShadowLine.y2 = this.fThumb.y;
            graphics.setStroke(this.fShadowStroke);
            graphics.setColor(Color.white);
            graphics.draw(this.fThumbTopShadowLine);
            double length = endTime.getValue(Time.MINUTE) - startTime.getValue(Time.MINUTE);
            if (startTime.getValue(Time.SECOND) >= this.fTimeLine.getDisplayStart().getValue(Time.SECOND) && addHandles) {
                this.fLeftHandle.height = this.fHandleHeight;
                this.fLeftHandle.width = this.fHandleWidth;
                this.fLeftHandle.x = this.fThumb.x;
                this.fLeftHandle.y = (float)this.fTimeLine.getHeight() / 2.0f - this.fHandleHeight / 2.0f;
                graphics.setStroke(this.fDefaultStroke);
                if (this.fMode == 1 || this.fMode == 2) {
                    graphics.setColor(this.fSelectedColor);
                } else {
                    graphics.setColor(this.fUnselectedColor);
                }
                graphics.draw(this.fLeftHandle);
                graphics.fill(this.fLeftHandle);
                graphics.setStroke(this.fShadowStroke);
                this.fLHandleBottomShadowLine.x1 = this.fLeftHandle.x;
                this.fLHandleBottomShadowLine.y1 = this.fLeftHandle.y + this.fHandleHeight;
                this.fLHandleBottomShadowLine.x2 = this.fLeftHandle.x + this.fHandleWidth;
                this.fLHandleBottomShadowLine.y2 = this.fLeftHandle.y + this.fHandleHeight;
                this.fLHandleRightShadowLine.x1 = this.fLeftHandle.x + this.fHandleWidth;
                this.fLHandleRightShadowLine.y1 = this.fLeftHandle.y;
                this.fLHandleRightShadowLine.x2 = this.fLeftHandle.x + this.fHandleWidth;
                this.fLHandleRightShadowLine.y2 = this.fLeftHandle.y + this.fHandleHeight;
                this.fLHandleLeftShadowLine.x1 = this.fLeftHandle.x;
                this.fLHandleLeftShadowLine.y1 = this.fLeftHandle.y;
                this.fLHandleLeftShadowLine.x2 = this.fLeftHandle.x;
                this.fLHandleLeftShadowLine.y2 = this.fLeftHandle.y + this.fHandleHeight;
                graphics.setColor(Color.black);
                graphics.draw(this.fLHandleBottomShadowLine);
                graphics.draw(this.fLHandleRightShadowLine);
                this.fLHandleTopShadowLine.x1 = this.fLeftHandle.x;
                this.fLHandleTopShadowLine.y1 = this.fLeftHandle.y;
                this.fLHandleTopShadowLine.x2 = this.fLeftHandle.x + this.fHandleWidth;
                this.fLHandleTopShadowLine.y2 = this.fLeftHandle.y;
                graphics.setColor(Color.white);
                graphics.draw(this.fLHandleTopShadowLine);
                graphics.draw(this.fLHandleLeftShadowLine);
            }
            if (endTime.getValue(Time.SECOND) <= this.fTimeLine.getDisplayEnd().getValue(Time.SECOND) && addHandles) {
                this.fRightHandle.height = this.fHandleHeight;
                this.fRightHandle.width = this.fHandleWidth;
                this.fRightHandle.x = this.fThumb.x + thumbWidth - this.fHandleWidth;
                this.fRightHandle.y = (float)this.fTimeLine.getHeight() / 2.0f - this.fHandleHeight / 2.0f;
                graphics.setStroke(this.fDefaultStroke);
                if (this.fMode == 3 || this.fMode == 2) {
                    graphics.setColor(this.fSelectedColor);
                } else {
                    graphics.setColor(this.fUnselectedColor);
                }
                graphics.draw(this.fRightHandle);
                graphics.fill(this.fRightHandle);
                this.fRHandleBottomShadowLine.x1 = this.fRightHandle.x;
                this.fRHandleBottomShadowLine.y1 = this.fRightHandle.y + this.fHandleHeight;
                this.fRHandleBottomShadowLine.x2 = this.fRightHandle.x + this.fHandleWidth;
                this.fRHandleBottomShadowLine.y2 = this.fRightHandle.y + this.fHandleHeight;
                this.fRHandleRightShadowLine.x1 = this.fRightHandle.x + this.fHandleWidth;
                this.fRHandleRightShadowLine.y1 = this.fRightHandle.y;
                this.fRHandleRightShadowLine.x2 = this.fRightHandle.x + this.fHandleWidth;
                this.fRHandleRightShadowLine.y2 = this.fRightHandle.y + this.fHandleHeight;
                this.fRHandleLeftShadowLine.x1 = this.fRightHandle.x;
                this.fRHandleLeftShadowLine.y1 = this.fRightHandle.y;
                this.fRHandleLeftShadowLine.x2 = this.fRightHandle.x;
                this.fRHandleLeftShadowLine.y2 = this.fRightHandle.y + this.fHandleHeight;
                this.fRHandleTopShadowLine.x1 = this.fRightHandle.x;
                this.fRHandleTopShadowLine.y1 = this.fRightHandle.y;
                this.fRHandleTopShadowLine.x2 = this.fRightHandle.x + this.fHandleWidth;
                this.fRHandleTopShadowLine.y2 = this.fRightHandle.y;
                graphics.setStroke(this.fShadowStroke);
                graphics.setColor(Color.black);
                graphics.draw(this.fRHandleBottomShadowLine);
                graphics.draw(this.fRHandleRightShadowLine);
                graphics.setColor(Color.white);
                graphics.setStroke(this.fDefaultStroke);
                graphics.draw(this.fRHandleTopShadowLine);
            }
            graphics.setFont(TimeLineNode.DEFAULT_FONT);
            Rectangle2D nameBounds = graphics.getFontMetrics().getStringBounds(this.getTimeLineNodeName(), graphics);
            graphics.setColor(Color.black);
            float textX = this.fThumb.x + thumbWidth / 2.0f - (float)(nameBounds.getWidth() / 2.0);
            float textY = !addHandles ? this.fThumb.y - (float)(nameBounds.getHeight() - 2.0) : this.fLeftHandle.y - (float)(nameBounds.getHeight() - 2.0);
            if (nameBounds.getWidth() > (double)thumbWidth) {
                graphics.setFont(TimeLineNode.ROTATED_FONT);
                textX = this.fThumb.x + thumbWidth / 2.0f;
            }
            if ((double)thumbWidth > 18.0) {
                graphics.drawString(this.getTimeLineNodeName(), textX, textY);
            }
            graphics.setFont(origFont);
            graphics.setFont(TimeLineNode.DEFAULT_FONT);
            DecimalFormat lengthForm = new DecimalFormat();
            lengthForm.setMaximumFractionDigits(2);
            String lengthStr = lengthForm.format(length);
            Rectangle2D lengthBounds = graphics.getFontMetrics().getStringBounds(lengthStr, graphics);
            graphics.setColor(Color.black);
            float lengthX = this.fThumb.x + thumbWidth / 2.0f - (float)(lengthBounds.getWidth() / 2.0);
            float lengthY = !addHandles ? this.fThumb.y + this.fHandleHeight + (float)(lengthBounds.getHeight() + 2.0) : this.fLeftHandle.y + this.fHandleHeight + (float)(lengthBounds.getHeight() + 2.0);
            if (lengthBounds.getWidth() > (double)thumbWidth) {
                graphics.setFont(TimeLineNode.REVERSE_ROTATED_FONT);
                lengthX = this.fThumb.x + thumbWidth / 2.0f;
            }
            if ((double)thumbWidth > 18.0) {
                graphics.drawString(lengthStr, lengthX, lengthY);
            }
            graphics.setFont(origFont);
        }
    }

    public synchronized void handleMouseEvent(MouseEvent evt) {
        block8: {
            block12: {
                Point pt;
                block14: {
                    block13: {
                        block9: {
                            block11: {
                                block10: {
                                    pt = evt.getPoint();
                                    if (evt.isPopupTrigger()) break block8;
                                    if (evt.getID() != 500 || evt.getClickCount() != 1) break block9;
                                    if (!this.fLeftHandle.contains(pt.x, pt.y)) break block10;
                                    if (this.fMode == 1 || this.fMode == 2) {
                                        this.setSelectionMode(0);
                                    } else {
                                        this.setSelectionMode(1);
                                    }
                                    break block8;
                                }
                                if (!this.fRightHandle.contains(pt.x, pt.y)) break block11;
                                if (this.fMode == 3 || this.fMode == 2) {
                                    this.setSelectionMode(0);
                                } else {
                                    this.setSelectionMode(3);
                                }
                                break block8;
                            }
                            if (!this.fThumb.contains(pt.x, pt.y)) break block8;
                            if (this.fMode == 2) {
                                this.setSelectionMode(0);
                            } else {
                                this.setSelectionMode(2);
                            }
                            break block8;
                        }
                        if (evt.getID() != 501) break block12;
                        if (!this.fLeftHandle.contains(pt.x, pt.y) || this.fRightHandle.contains(pt.x, pt.y)) break block13;
                        this.fDragMode = 1;
                        break block8;
                    }
                    if (!this.fRightHandle.contains(pt.x, pt.y) || this.fLeftHandle.contains(pt.x, pt.y)) break block14;
                    this.fDragMode = 3;
                    break block8;
                }
                if (!this.fThumb.contains(pt.x, pt.y)) break block8;
                this.fDragMode = 2;
                this.fTempMouseOffset = (float)pt.x - this.fThumbBegin;
                this.fTempThumbWidth = this.fThumbEnd - this.fThumbBegin;
                break block8;
            }
            if (evt.getID() != 502) break block8;
            int oldMode = this.fDragMode;
            this.fDragMode = 0;
            Time oldDuration = this.getDuration();
            try {
                this.setDuration(this.getDuration());
                this.fChangeSupport.fireVetoableChange("Mode", oldMode, this.fDragMode);
            }
            catch (Exception ex) {}
        }
    }

    public synchronized void handleMouseDragEvent(MouseEvent evt) {
        block12: {
            if (this.fDragMode == 0) break block12;
            Point pt = evt.getPoint();
            if (this.fDragMode == 1) {
                this.fThumbBegin = pt.x;
            } else if (this.fDragMode == 3) {
                this.fThumbEnd = pt.x;
            } else if (this.fDragMode == 2) {
                this.fThumbBegin = (float)pt.x - this.fTempMouseOffset;
                this.fThumbEnd = this.fThumbBegin + this.fTempThumbWidth;
            }
            Time newStartTime = this.fTimeLine.getTimeForPoint(this.fThumbBegin);
            Time newEndTime = this.fTimeLine.getTimeForPoint(this.fThumbEnd);
            Time oldStartTime = this.getStartTime();
            try {
                if (this.fDragMode == 2) {
                    if (newStartTime.getValue(Time.SECOND) == oldStartTime.getValue(Time.SECOND)) break block12;
                    double moveByVal = newStartTime.getValue(Time.SECOND) - oldStartTime.getValue(Time.SECOND);
                    this.moveTimeLineNodeBy(new Time(moveByVal, Time.SECOND));
                    break block12;
                }
                if (this.fDragMode == 1) {
                    this.setStartTime(newStartTime);
                } else if (this.fDragMode == 3) {
                    this.setEndTime(newEndTime);
                }
            }
            catch (DetailedPropertyVetoException ex) {
                this.fForceRecalculation = true;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void handleMouseMoveEvent(MouseEvent evt) {
    }

    public void handleKeyEvent(KeyEvent evt) throws DetailedPropertyVetoException {
        block10: {
            if (evt.getID() == 401) {
                int totalIntervals = this.fTimeLine.getIntervalCount();
                int interval = 10;
                if (evt.isControlDown()) {
                    interval = 1;
                } else if (evt.isShiftDown()) {
                    interval = 60;
                }
                interval = evt.getKeyCode() == 37 ? -1 * interval : (evt.getKeyCode() == 39 ? 1 * interval : 0);
                if (interval != 0) {
                    Time anInterval = this.fTimeLine.getIntervalTime();
                    Time intervalTime = new Time(anInterval.getValue(Time.SECOND) * (double)interval, Time.SECOND);
                    try {
                        if (this.getSelectionMode() == 1) {
                            this.setStartTime(new Time(this.getStartTime().getValue(Time.SECOND) + intervalTime.getValue(Time.SECOND), Time.SECOND));
                            break block10;
                        }
                        if (this.getSelectionMode() == 3) {
                            this.setEndTime(new Time(this.getEndTime().getValue(Time.SECOND) + intervalTime.getValue(Time.SECOND), Time.SECOND));
                            break block10;
                        }
                        if (this.getSelectionMode() != 2) break block10;
                        this.moveTimeLineNodeBy(intervalTime);
                    }
                    catch (DetailedPropertyVetoException ex) {
                        throw ex;
                    }
                    catch (PropertyVetoException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void setTimeLineNodeName(String name) {
        this.fModel.setTimeLineNodeName(name);
    }

    public String getTimeLineNodeName() {
        return this.fModel.getTimeLineNodeName();
    }

    public void setParent(TimeLine timeLine) {
        this.fTimeLine = timeLine;
        TimeLineModel model = null;
        if (timeLine != null) {
            model = timeLine.getModel();
        }
        this.fModel.setParent(model);
        this.fDragMode = 0;
        this.fMode = 0;
        this.fForceRecalculation = true;
    }

    public TimeLine getParent() {
        return this.fTimeLine;
    }

    protected void calculateNodeDimensions() {
        this.fThumbBegin = this.fTimeLine.getPointForTime(this.fModel.getStartTime());
        this.fThumbEnd = this.fTimeLine.getPointForTime(this.fModel.getEndTime());
    }

    public boolean isDragging() {
        return this.fDragMode != 0;
    }

    public boolean isSelected() {
        return this.fMode == 2;
    }

    public void revertToPrevious() {
        this.fModel.revertToPrevious();
    }

    public void vetoableChange(PropertyChangeEvent evt) throws DetailedPropertyVetoException {
        TimeLineNode node;
        if (evt.getPropertyName() != "node removed" && evt.getSource() instanceof TimeLineNode && (node = (TimeLineNode)evt.getSource()) != this && (this.intersects(node) || node.intersects(this))) {
            throw new DetailedPropertyVetoException(this, "Node Overlap", "node " + this.getTimeLineNodeName() + " overlaps " + node.getTimeLineNodeName(), evt);
        }
    }

    public int getAreaForPoint(Point pt) {
        int result = 0;
        if (this.fLeftHandle.contains(pt.x, pt.y)) {
            result = 1;
        } else if (this.fRightHandle.contains(pt.x, pt.y)) {
            result = 3;
        } else if (this.fThumb.contains(pt.x, pt.y)) {
            result = 2;
        }
        return result;
    }

    public boolean intersects(TimeLineNode node) {
        return this.fModel.intersects(node.getModel());
    }

    public Point getCenterPoint() {
        double value = this.fModel.getStartTime().getValue() + (this.fModel.getEndTime().getValue() - this.fModel.getStartTime().getValue()) / 2.0;
        Time centerTime = new Time(value);
        float x = this.fTimeLine.getPointForTime(centerTime);
        float y = (float)this.fTimeLine.getHeight() / 2.0f;
        Point pt = new Point(Math.round(x), Math.round(y));
        return pt;
    }

    public synchronized void setTimeLineNode(Time start, Time end) throws DetailedPropertyVetoException {
        block5: {
            Time oldStartTime = this.getStartTime();
            Time oldEndTime = this.getEndTime();
            try {
                this.fModel.setValidTimeLineNode(start, end);
                if (this.fTimeLine == null) break block5;
                Time displayEdge = this.fTimeLine.getDisplayStart();
                if (this.fModel.getStartTime().getValue() < displayEdge.getValue() && oldStartTime.getValue() >= displayEdge.getValue()) {
                    this.fChangeSupport.fireVetoableChange("HitLeftEdge", oldStartTime, this.fModel.getStartTime());
                    this.fForceRecalculation = true;
                }
                displayEdge = this.fTimeLine.getDisplayEnd();
                if (this.fModel.getEndTime().getValue() > displayEdge.getValue() && oldEndTime.getValue() <= displayEdge.getValue()) {
                    this.fChangeSupport.fireVetoableChange("HitRightEdge", oldEndTime, this.fModel.getEndTime());
                    this.fForceRecalculation = true;
                }
            }
            catch (DetailedPropertyVetoException ex) {
                this.fForceRecalculation = true;
                throw ex;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean containsPoint(Point pt) {
        boolean result = false;
        Time time = this.fTimeLine.getTimeForPoint(pt.x);
        if (time.getValue() >= this.fModel.getStartTime().getValue() && time.getValue() <= this.fModel.getEndTime().getValue()) {
            result = true;
        }
        return result;
    }

    public String getDescription(Point pt) {
        String units;
        block9: {
            block8: {
                units = this.fTimeLine.getUnitsType();
                if (units == "Date View") break block8;
                if (units != "Time View") break block9;
            }
            return this.getTimeLineNodeName();
        }
        String result = null;
        if (this.fLeftHandle.contains(pt.x, pt.y)) {
            DecimalFormat form = new DecimalFormat();
            form.setMaximumFractionDigits(2);
            String str = form.format(this.getStartTime().getValue(units));
            result = str + " " + Time.getUnitsAbbrev(units);
        } else if (this.fRightHandle.contains(pt.x, pt.y)) {
            DecimalFormat form = new DecimalFormat();
            form.setMaximumFractionDigits(2);
            String str = form.format(this.getEndTime().getValue(units));
            result = str + " " + Time.getUnitsAbbrev(units);
        } else if (this.fThumb.contains(pt.x, pt.y)) {
            result = this.getTimeLineNodeName();
        }
        return result;
    }

    public TimeLineNodeModel getModel() {
        return this.fModel;
    }

    public void setModel(TimeLineNodeModel model) {
        if (model != this.fModel) {
            if (this.fModel != null) {
                this.fModel.removeVetoableChangeListener(this.fMyVetoListener);
            }
            this.fModel = (VetoableTimeLineNodeModel)model;
            this.init();
        }
    }

    public Cursor getCursor(MouseEvent evt) {
        Cursor result = TimeLine.DEFAULT_CURSOR;
        Point pt = evt.getPoint();
        if ((this.fLeftHandle.contains(pt.x, pt.y) || this.fRightHandle.contains(pt.x, pt.y) || this.fThumb.contains(pt.x, pt.y)) && this.getParent().getMode() == "Selection") {
            result = TimeLineNode.MOVE_CURSOR;
        }
        return result;
    }

    public String toString() {
        return this.fModel.toString();
    }
}

