/*
 * Decompiled with CFR 0.152.
 */
package jsky.timeline;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.VetoableChangeListener;
import javax.swing.JLabel;
import jsky.science.Time;
import jsky.timeline.DetailedPropertyVetoException;
import jsky.timeline.TimeLine;
import jsky.timeline.TimeLineNodeModel;

public interface TimeLineNode
extends VetoableChangeListener {
    public static final int UNSELECTED = 0;
    public static final int LEFT_HANDLE_SELECTED = 1;
    public static final int NODE_SELECTED = 2;
    public static final int RIGHT_HANDLE_SELECTED = 3;
    public static final Font DEFAULT_FONT = new JLabel().getFont().deriveFont(0, 10.0f);
    public static final Font ROTATED_FONT = DEFAULT_FONT.deriveFont(AffineTransform.getRotateInstance(5.759586531581287));
    public static final Font REVERSE_ROTATED_FONT = DEFAULT_FONT.deriveFont(AffineTransform.getRotateInstance(0.5235987755982988));
    public static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(12);
    public static final double DEFAULT_LABEL_SPACE = 2.0;
    public static final String NODE_OVERLAP = "Node Overlap";
    public static final String NODE_MIN_SIZE_EXCEEDED = "The Node minimum size has been exceeded";
    public static final String NODE_MAX_SIZE_EXCEEDED = "The Node maximum size has been exceeded";
    public static final String HIT_LEFT_EDGE = "HitLeftEdge";
    public static final String HIT_RIGHT_EDGE = "HitRightEdge";
    public static final String BIC = "Because I can";
    public static final String MODE = "Mode";
    public static final String SELECTED_COLOR = "SelectedColor";
    public static final String UNSELECTED_COLOR = "UnselectedColor";
    public static final String START_TIME = "StartTime";
    public static final String END_TIME = "EndTime";
    public static final String NODE = "Node";
    public static final String NAME = "Name";

    public void setSelectionMode(int var1);

    public int getSelectionMode();

    public void setUnselectedColor(Color var1);

    public Color getUnselectedColor();

    public void setSelectedColor(Color var1);

    public Color getSelectedColor();

    public Time getStartTime();

    public void setStartTime(Time var1) throws DetailedPropertyVetoException;

    public Time getEndTime();

    public void setEndTime(Time var1) throws DetailedPropertyVetoException;

    public void moveTimeLineNodeBy(Time var1) throws DetailedPropertyVetoException;

    public Time getDuration();

    public void setDuration(Time var1) throws DetailedPropertyVetoException;

    public void setTimeLineNodeName(String var1);

    public String getTimeLineNodeName();

    public void paintTimeLineNode(Graphics2D var1);

    public void addVetoableChangeListener(VetoableChangeListener var1);

    public void removeVetoableChangeListener(VetoableChangeListener var1);

    public void handleMouseEvent(MouseEvent var1);

    public void handleMouseDragEvent(MouseEvent var1);

    public void handleMouseMoveEvent(MouseEvent var1);

    public void handleKeyEvent(KeyEvent var1) throws DetailedPropertyVetoException;

    public void setParent(TimeLine var1);

    public TimeLine getParent();

    public boolean isDragging();

    public boolean isSelected();

    public void revertToPrevious();

    public boolean intersects(TimeLineNode var1);

    public int getAreaForPoint(Point var1);

    public Point getCenterPoint();

    public void setTimeLineNode(Time var1, Time var2) throws DetailedPropertyVetoException;

    public boolean containsPoint(Point var1);

    public String getDescription(Point var1);

    public TimeLineNodeModel getModel();

    public void setModel(TimeLineNodeModel var1);

    public Cursor getCursor(MouseEvent var1);
}

