/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import jsky.util.SwingWorker;

public class ConnectionUtil {
    private URL url;
    private URLConnection connection;
    private boolean interrupted = false;
    private Exception exception;
    private SwingWorker worker;

    public ConnectionUtil(URL url) {
        this.url = url;
    }

    public URLConnection openConnection() throws IOException {
        this.worker = new SwingWorker(){

            public Object construct() {
                try {
                    URLConnection connection = ConnectionUtil.this.url.openConnection();
                    connection.getContentLength();
                    return connection;
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                Object o = this.getValue();
                if (o instanceof URLConnection) {
                    ConnectionUtil.this.connection = (URLConnection)o;
                } else if (o instanceof Exception) {
                    ConnectionUtil.this.exception = (Exception)o;
                }
            }
        };
        this.worker.start();
        this.interrupted = false;
        while (this.connection == null && this.exception == null && !this.interrupted) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.interrupted = true;
                break;
            }
            this.interrupted = Thread.interrupted();
        }
        if (this.interrupted) {
            this.worker.interrupt();
            return null;
        }
        if (this.exception != null) {
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            throw new RuntimeException(this.exception.toString());
        }
        return this.connection;
    }

    public void interrupt() {
        this.interrupted = true;
        this.worker.interrupt();
    }
}

