/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Properties;
import javax.swing.JComponent;
import jsky.util.TclUtil;

public class Preferences {
    private Properties _properties = new Properties();
    private File _dir;
    private File _cacheDir;
    private String _sep;
    private File _file;
    private static Preferences _preferences;

    public Preferences() {
        String home = System.getProperty("user.home");
        this._sep = System.getProperty("file.separator");
        String dirName = home + this._sep + ".jsky";
        this._dir = new File(dirName);
        this._cacheDir = new File(dirName + this._sep + "cache");
        this._file = new File(dirName + this._sep + "jsky.properties");
        try {
            if (!this._dir.isDirectory()) {
                this._dir.mkdirs();
            }
            if (!this._cacheDir.isDirectory()) {
                this._cacheDir.mkdir();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.load();
    }

    public Preferences(String filename) {
        this._file = new File(filename);
        this._dir = this._file.getParentFile();
        this.load();
    }

    public File getDir() {
        return this._dir;
    }

    public File getCacheDir() {
        return this._cacheDir;
    }

    public String getSep() {
        return this._sep;
    }

    public File getFile() {
        return this._file;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public static Preferences getPreferences() {
        if (_preferences == null) {
            _preferences = new Preferences();
        }
        return _preferences;
    }

    public static void setPreferences(Preferences p) {
        _preferences = p;
    }

    public void setPreference(String key, String value) {
        if (value != null) {
            this._properties.setProperty(key, value);
        } else {
            this._properties.remove(key);
        }
    }

    public void unsetPreference(String key) {
        this._properties.remove(key);
    }

    public String getPreference(String key) {
        return this._properties.getProperty(key);
    }

    public String getPreference(String key, String defaultValue) {
        return this._properties.getProperty(key, defaultValue);
    }

    public static void set(String key, String value) {
        if (_preferences == null) {
            _preferences = new Preferences();
        }
        _preferences.setPreference(key, value);
    }

    public static void set(String key, boolean value) {
        if (_preferences == null) {
            _preferences = new Preferences();
        }
        _preferences.setPreference(key, String.valueOf(value));
    }

    public static void unset(String key) {
        if (_preferences == null) {
            return;
        }
        _preferences.unsetPreference(key);
    }

    public static String get(String key) {
        if (_preferences == null) {
            _preferences = new Preferences();
            return null;
        }
        return _preferences.getPreference(key);
    }

    public static String get(String key, String defaultValue) {
        if (_preferences == null) {
            _preferences = new Preferences();
            return defaultValue;
        }
        return _preferences.getPreference(key, defaultValue);
    }

    public static boolean get(String key, boolean defaultValue) {
        if (_preferences == null) {
            _preferences = new Preferences();
            return defaultValue;
        }
        String s = _preferences.getPreference(key);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    private void load() {
        if (this._file.exists()) {
            try {
                this._properties.load(new FileInputStream(this._file));
            }
            catch (Exception e) {
                System.out.println("Error reading preferences file: " + this._file.getPath() + ": " + e.toString());
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Preferences.this.save();
            }
        });
    }

    private void save() {
        try {
            this._properties.store(new FileOutputStream(this._file), "JSky User Preferences");
        }
        catch (Exception e) {
            System.out.println("Error saving preferences file: " + this._file.getPath() + ": " + e.toString());
        }
    }

    public void serialize(String name, Object object) throws FileNotFoundException, OptionalDataException, IOException {
        String filename = this._dir + this._sep + name + ".ser";
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
        out.writeObject(object);
        out.close();
    }

    public Object deserialize(String name) throws FileNotFoundException, ClassNotFoundException, IOException {
        String filename = this._dir + this._sep + name + ".ser";
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        Object object = in.readObject();
        in.close();
        return object;
    }

    public static void manageLocation(Component component) {
        Preferences.manageLocation(component, -1, -1);
    }

    public static void manageLocation(Component component, int x, int y) {
        Preferences.manageLocation(component, x, y, component.getClass().getName() + ".pos");
    }

    public static void manageLocation(Component component, int x, int y, final String name) {
        block6: {
            String s = Preferences.get(name);
            if (s != null) {
                try {
                    String[] ar = TclUtil.splitList(s);
                    if (ar.length == 2) {
                        component.setLocation(Integer.parseInt(ar[0]), Integer.parseInt(ar[1]));
                    }
                    break block6;
                }
                catch (Exception e) {
                    System.out.println("Warning: error reading component location from preferences file: " + Preferences._preferences._file.getPath());
                    if (x >= 0 && y >= 0) {
                        component.setLocation(x, y);
                    }
                    break block6;
                }
            }
            if (x >= 0 && y >= 0) {
                component.setLocation(x, y);
            }
        }
        component.addComponentListener(new ComponentAdapter(){

            private void saveLocation(ComponentEvent e) {
                Component c = e.getComponent();
                String[] ar = new String[]{Integer.toString(c.getX()), Integer.toString(c.getY())};
                Preferences.set(name, TclUtil.makeList(ar));
            }

            public void componentResized(ComponentEvent e) {
                this.saveLocation(e);
            }

            public void componentMoved(ComponentEvent e) {
                this.saveLocation(e);
            }
        });
    }

    public static void manageSize(JComponent component, Dimension defaultSize) {
        Preferences.manageSize(component, defaultSize, component.getClass().getName() + ".size");
    }

    public static void manageSize(JComponent component, Dimension defaultSize, final String name) {
        String s = Preferences.get(name);
        if (s != null) {
            try {
                String[] ar = TclUtil.splitList(s);
                if (ar.length == 2) {
                    component.setPreferredSize(new Dimension(Integer.parseInt(ar[0]), Integer.parseInt(ar[1])));
                }
            }
            catch (Exception e) {
                System.out.println("Warning: error reading component size from preferences file: " + Preferences._preferences._file.getPath());
                component.setPreferredSize(defaultSize);
            }
        } else if (defaultSize != null) {
            component.setPreferredSize(defaultSize);
        }
        component.addComponentListener(new ComponentAdapter(){

            private void saveSize(ComponentEvent e) {
                Component c = e.getComponent();
                String[] ar = new String[]{Integer.toString(c.getWidth()), Integer.toString(c.getHeight())};
                Preferences.set(name, TclUtil.makeList(ar));
            }

            public void componentResized(ComponentEvent e) {
                this.saveSize(e);
            }

            public void componentMoved(ComponentEvent e) {
                this.saveSize(e);
            }
        });
    }
}

