/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsky.science.Coordinates;
import jsky.util.FormatUtilities;

public class CoordinatesPanel
extends JComponent
implements ActionListener,
PropertyChangeListener {
    private JLabel fRaLabel;
    private JLabel fDecLabel;
    private JPanel fRaPanel;
    private JPanel fDecPanel;
    private JTextField fRaField;
    private JTextField fDecField;
    private int fOrientation;
    private Coordinates fOldPosition;
    private JLabel fEquinoxLabel;
    private JComboBox fEquinoxField;
    private boolean fEquinoxShown;
    private int fOldEquinox;
    private String fFormatString;
    private FocusAdapter focusAdapterThatPostsActionEventsToJTextFields;
    protected static final String RA_NOTIFY = "RA Notify".intern();
    protected static final String DEC_NOTIFY = "DEC Notify".intern();
    protected static final String EQUINOX_NOTIFY = "Equinox Notify".intern();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String COORDINATES_PROPERTY = "Coordinates".intern();
    public static final String READ_ONLY_PROPERTY = "ReadOnly".intern();
    public static final String ORIENTATION_PROPERTY = "Orientation".intern();
    public static final String EQUINOX_SHOWN_PROPERTY = "EquinoxShown".intern();
    public static final String EQUINOX_PROPERTY = "Equinox".intern();
    GridBagConstraints constraint = new GridBagConstraints();

    public CoordinatesPanel() {
        this.setLayout(new GridBagLayout());
        this.focusAdapterThatPostsActionEventsToJTextFields = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ((JTextField)e.getSource()).postActionEvent();
            }
        };
        this.fRaLabel = new JLabel("RA:");
        this.fRaField = new JTextField(8);
        this.fDecLabel = new JLabel("Dec:");
        this.fDecField = new JTextField(8);
        this.fRaField.setActionCommand(RA_NOTIFY);
        this.fRaField.addActionListener(this);
        this.fDecField.setActionCommand(DEC_NOTIFY);
        this.fDecField.addActionListener(this);
        Coordinates.addSeparatorStyleChangeListener(this);
        this.updateFromFormatChange();
        this.add(this.fRaLabel);
        this.add(this.fRaField);
        this.add(this.fDecLabel);
        this.add(this.fDecField);
        this.fOldPosition = null;
        this.fEquinoxShown = false;
        this.fEquinoxLabel = null;
        this.fEquinoxField = null;
        this.fOldEquinox = -1;
        this.setOrientation(0);
    }

    public Coordinates getCoordinates() {
        try {
            if (this.fEquinoxShown) {
                String eqstring = (String)this.fEquinoxField.getSelectedItem();
                int equinox = Coordinates.equinoxStringToInt(eqstring);
                return Coordinates.valueOf(this.fRaField.getText(), this.fDecField.getText(), equinox);
            }
            return Coordinates.valueOf(this.fRaField.getText(), this.fDecField.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public void setCoordinates(Coordinates position) {
        Coordinates old = this.getCoordinates();
        this.firePropertyChange(COORDINATES_PROPERTY, old, position);
        this.fOldPosition = position;
        String raString = "";
        String decString = "";
        if (position != null) {
            raString = position.raToString();
            decString = position.decToString();
        }
        if (!this.fRaField.getText().equals(raString)) {
            this.fRaField.setText(raString);
        }
        if (!this.fDecField.getText().equals(decString)) {
            this.fDecField.setText(decString);
        }
    }

    public void setCoordinates(String ra, String dec) {
        try {
            Coordinates newPosition = Coordinates.valueOf(ra, dec);
            this.firePropertyChange(COORDINATES_PROPERTY, this.fOldPosition, newPosition);
            this.fOldPosition = newPosition;
            if (!this.fRaField.getText().equals(ra)) {
                this.fRaField.setText(ra);
            }
            if (!this.fDecField.getText().equals(dec)) {
                this.fDecField.setText(dec);
            }
        }
        catch (NumberFormatException ex) {
            FormatUtilities.writeError(this, "Unable to set coordinates: " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            FormatUtilities.writeError(this, "Unable to set coordinates: " + ex.toString());
        }
    }

    public void setPostActionEventOnFocusLost(boolean postFlag) {
        if (postFlag) {
            this.fRaField.addFocusListener(this.focusAdapterThatPostsActionEventsToJTextFields);
            this.fDecField.addFocusListener(this.focusAdapterThatPostsActionEventsToJTextFields);
        } else {
            this.fRaField.removeFocusListener(this.focusAdapterThatPostsActionEventsToJTextFields);
            this.fDecField.removeFocusListener(this.focusAdapterThatPostsActionEventsToJTextFields);
        }
    }

    public boolean isReadOnly() {
        return !this.fRaField.isEditable();
    }

    public void setReadOnly(boolean readOnly) {
        this.firePropertyChange(READ_ONLY_PROPERTY, !this.fRaField.isEditable(), readOnly);
        this.fRaField.setEditable(!readOnly);
        this.fDecField.setEditable(!readOnly);
        this.fEquinoxField.setEnabled(!readOnly);
    }

    public boolean isEquinoxShown() {
        return this.fEquinoxShown;
    }

    public void setEquinoxShown(boolean show) {
        boolean old = this.fEquinoxShown;
        this.fEquinoxShown = show;
        this.firePropertyChange(EQUINOX_SHOWN_PROPERTY, old, this.fEquinoxShown);
        this.setOrientation(this.fOrientation);
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    private void setConstraints(JComponent comp, int x, int y, int w, int h, int a) {
        this.constraint.weightx = 1.0;
        this.constraint.insets = new Insets(2, 2, 2, 2);
        this.constraint.gridx = x;
        this.constraint.gridy = y;
        this.constraint.gridheight = h;
        this.constraint.gridwidth = w;
        this.constraint.anchor = a;
        ((GridBagLayout)this.getLayout()).setConstraints(comp, this.constraint);
    }

    public void setOrientation(int orient) {
        this.firePropertyChange(ORIENTATION_PROPERTY, this.fOrientation, orient);
        this.fOrientation = orient;
        if (this.fEquinoxShown && this.fEquinoxField == null) {
            this.fEquinoxLabel = new JLabel("Equinox:");
            this.fEquinoxField = new JComboBox();
            String[] eqs = Coordinates.getAllEquinoxes();
            int i = 0;
            while (i < eqs.length) {
                this.fEquinoxField.addItem(eqs[i]);
                ++i;
            }
            this.fEquinoxField.setActionCommand(EQUINOX_NOTIFY);
            this.fEquinoxField.addActionListener(this);
            this.add(this.fEquinoxLabel);
            this.add(this.fEquinoxField);
        } else if (!this.fEquinoxShown && this.fEquinoxField != null) {
            this.fEquinoxField.removeActionListener(this);
            this.remove(this.fEquinoxLabel);
            this.remove(this.fEquinoxField);
            this.fEquinoxLabel = null;
            this.fEquinoxField = null;
        }
        if (this.fOrientation == 1) {
            this.setConstraints(this.fRaLabel, 0, 0, 1, 1, 13);
            this.setConstraints(this.fRaField, 1, 0, 1, 1, 17);
            this.setConstraints(this.fDecLabel, 0, 1, 1, 1, 13);
            this.setConstraints(this.fDecField, 1, 1, 1, 1, 17);
            if (this.fEquinoxShown) {
                this.setConstraints(this.fEquinoxLabel, 0, 2, 1, 1, 13);
                this.setConstraints(this.fEquinoxField, 1, 2, 1, 1, 17);
            }
        } else {
            this.setConstraints(this.fRaLabel, 0, 0, 1, 1, 13);
            this.setConstraints(this.fRaField, 1, 0, 1, 1, 17);
            this.setConstraints(this.fDecLabel, 2, 0, 1, 1, 13);
            this.setConstraints(this.fDecField, 3, 0, 1, 1, 17);
            if (this.fEquinoxShown) {
                this.setConstraints(this.fEquinoxLabel, 4, 0, 1, 1, 13);
                this.setConstraints(this.fEquinoxField, 5, 0, 1, 1, 17);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        block7: {
            if (e.getActionCommand() == RA_NOTIFY || e.getActionCommand() == DEC_NOTIFY) {
                Coordinates newPosition = null;
                try {
                    newPosition = Coordinates.valueOf(this.fRaField.getText(), this.fDecField.getText());
                    this.firePropertyChange(COORDINATES_PROPERTY, this.fOldPosition, newPosition);
                    this.fOldPosition = newPosition;
                }
                catch (NumberFormatException ex) {
                    this.showErrorDialog();
                    if (this.fOldPosition != null) {
                        this.setCoordinates(this.fOldPosition);
                    }
                    break block7;
                }
                catch (IllegalArgumentException ex) {
                    this.showErrorDialog();
                    if (this.fOldPosition != null) {
                        this.setCoordinates(this.fOldPosition);
                    }
                    break block7;
                }
            }
            if (e.getActionCommand() == EQUINOX_NOTIFY) {
                String eqstring = (String)this.fEquinoxField.getSelectedItem();
                int equinox = Coordinates.equinoxStringToInt(eqstring);
                this.firePropertyChange(EQUINOX_PROPERTY, this.fOldEquinox, equinox);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFromFormatChange();
    }

    public void showErrorDialog() {
        String message;
        switch (Coordinates.getSeparatorStyle()) {
            default: {
                message = "Invalid coordinates format.  Coordinates should be\nentered in the following format: ## ## ##.##";
                break;
            }
            case 1: {
                message = "Invalid coordinates format.  Coordinates should be\nentered in the following format: ##:##:##.##";
                break;
            }
            case 2: {
                message = "Invalid coordinates format.  Coordinates should be\nentered in the following format:\nRight-Ascension: ##h##m##.##s\nDeclination: ##d##m##.##s";
            }
        }
        message = message + "\nValid ranges are 0 to 24 hours for RA,\n-90 to 90 degrees for DEC.";
        JOptionPane.showMessageDialog(this, message, "Invalid Coordinates", 0);
    }

    protected void updateFromFormatChange() {
        this.fFormatString = Coordinates.separatorStyleIntToString(Coordinates.getSeparatorStyle());
        this.fRaField.setToolTipText("Format: " + this.fFormatString);
        if (Coordinates.getSeparatorStyle() == 2) {
            this.fDecField.setToolTipText("Format: ##d##m##.##s");
        } else {
            this.fDecField.setToolTipText("Format: " + this.fFormatString);
        }
        if (this.fOldPosition != null) {
            this.setCoordinates(this.fOldPosition);
        }
    }

    public static void main(String[] args) {
        Coordinates offset = new Coordinates(5.0, 5.0);
        CoordinatesPanel panel = new CoordinatesPanel();
        panel.setCoordinates(offset);
        panel.setEquinoxShown(true);
        panel.setOrientation(1);
        JOptionPane.showConfirmDialog(null, panel);
    }
}

