/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.net.UnknownHostException;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import jsky.util.gui.BusyWin;

public class DialogUtil {
    private static JDesktopPane desktop;

    public static void setDesktop(JDesktopPane d) {
        desktop = d;
    }

    public static JDesktopPane getDesktop() {
        return desktop;
    }

    public static void error(Component parentComponent, String msg) {
        if (desktop != null) {
            BusyWin.setBusy(false);
            JOptionPane.showInternalMessageDialog(desktop, msg, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(parentComponent, msg, "Error", 0);
        }
    }

    public static void error(String msg) {
        DialogUtil.error(null, msg);
    }

    public static void error(Component parentComponent, Exception e) {
        e.printStackTrace();
        String s = e.getMessage();
        if (e instanceof UnknownHostException) {
            s = "Unknown host: " + s;
        } else if (s == null || s.trim().length() == 0) {
            s = e.toString();
        }
        if (desktop != null) {
            BusyWin.setBusy(false);
            JOptionPane.showInternalMessageDialog(desktop, s, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(parentComponent, s, "Error", 0);
        }
    }

    public static void error(Exception e) {
        DialogUtil.error(null, e);
    }

    public static void message(Component parentComponent, String msg) {
        if (desktop != null) {
            BusyWin.setBusy(false);
            JOptionPane.showInternalMessageDialog(desktop, msg, "Message", 1);
        } else {
            JOptionPane.showMessageDialog(parentComponent, msg, "Message", 1);
        }
    }

    public static void message(String msg) {
        DialogUtil.message(null, msg);
    }

    public static String input(Component parentComponent, String msg) {
        if (desktop != null) {
            BusyWin.setBusy(false);
            return JOptionPane.showInternalInputDialog(desktop, msg, "Input", 3);
        }
        return JOptionPane.showInputDialog(parentComponent, msg, "Input", 3);
    }

    public static String input(String msg) {
        return DialogUtil.input(null, msg);
    }

    public static int confirm(Component parentComponent, String msg) {
        if (desktop != null) {
            BusyWin.setBusy(false);
            return JOptionPane.showInternalConfirmDialog(desktop, msg);
        }
        return JOptionPane.showConfirmDialog(parentComponent, msg);
    }

    public static int confirm(String msg) {
        return DialogUtil.confirm(null, msg);
    }
}

