/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicArrowButton;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.GridBagUtil;
import jsky.util.gui.NumberEntry;

public class LabelEntrySlider
extends JPanel {
    private JLabel label;
    private JTextField field;
    private BasicArrowButton left;
    private BasicArrowButton right;
    private JSlider slider;
    private double minValue;
    private double maxValue;
    private int numValues;
    private double scale;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent = new ChangeEvent(this);
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public LabelEntrySlider(String text, double minVal, double maxVal, int numVals) {
        this.setLayout(new GridBagLayout());
        GridBagUtil layoutUtil = new GridBagUtil(this, (GridBagLayout)this.getLayout());
        this.label = new JLabel(text);
        this.field = new NumberEntry(8);
        this.field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LabelEntrySlider.this.setValue(Double.parseDouble(LabelEntrySlider.this.field.getText()));
            }
        });
        this.left = new BasicArrowButton(7);
        this.left.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int i = LabelEntrySlider.this.slider.getValue() - 1;
                LabelEntrySlider.this.setValue(LabelEntrySlider.this.minValue + (double)i * LabelEntrySlider.this.scale);
            }
        });
        this.slider = new JSlider();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                LabelEntrySlider.this.setValue(LabelEntrySlider.this.minValue + (double)LabelEntrySlider.this.slider.getValue() * LabelEntrySlider.this.scale);
            }
        });
        this.slider.addMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent me) {
                LabelEntrySlider.this.setValue(LabelEntrySlider.this.minValue + (double)LabelEntrySlider.this.slider.getValue() * LabelEntrySlider.this.scale);
            }
        });
        this.right = new BasicArrowButton(3);
        this.right.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int i = LabelEntrySlider.this.slider.getValue() + 1;
                LabelEntrySlider.this.setValue(LabelEntrySlider.this.minValue + (double)i * LabelEntrySlider.this.scale);
            }
        });
        int east = 13;
        int west = 17;
        boolean none = false;
        int horizontal = 2;
        layoutUtil.add(this.label, 0, 0, 1, 1, 0.0, 0.0, 0, 17);
        layoutUtil.add(this.field, 1, 0, 1, 1, 0.0, 0.0, 0, 17);
        layoutUtil.add(this.left, 2, 0, 1, 1, 0.0, 0.0, 0, 17);
        layoutUtil.add(this.slider, 3, 0, 1, 1, 0.0, 1.0, 2, 17);
        layoutUtil.add(this.right, 4, 0, 1, 1, 0.0, 0.0, 0, 17);
        this.setBounds(minVal, maxVal, numVals);
    }

    public LabelEntrySlider() {
        this("label", 0.0, 100.0, 100);
    }

    public void setValue(double value) {
        String s;
        boolean changed = false;
        if (value < this.minValue) {
            this.minValue = value;
            this.setBounds(this.minValue, this.maxValue, this.numValues);
        } else if (value >= this.maxValue) {
            this.maxValue = value;
            this.setBounds(this.minValue, this.maxValue, this.numValues);
        }
        int val = (int)Math.round((value - this.minValue) / this.scale);
        if (val != this.slider.getValue()) {
            changed = true;
            this.slider.setValue(val);
        }
        if (!(s = String.valueOf((float)value)).equals(this.field.getText())) {
            changed = true;
            this.field.setText(s);
        }
        if (changed || !this.slider.getValueIsAdjusting()) {
            this.fireChange();
        }
    }

    public double getValue() {
        return Double.parseDouble(this.field.getText());
    }

    public boolean getValueIsAdjusting() {
        return this.slider.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean b) {
        this.slider.setValueIsAdjusting(b);
    }

    public void setBounds(double minVal, double maxVal, int numVals) {
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.numValues = numVals;
        this.scale = (this.maxValue - this.minValue) / (double)this.numValues;
        if (this.slider.getMinimum() != 0) {
            this.slider.setMinimum(0);
        }
        if (this.slider.getMaximum() != numVals - 1) {
            this.slider.setMaximum(numVals - 1);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JTextField getTextField() {
        return this.field;
    }

    public BasicArrowButton getLeftButton() {
        return this.left;
    }

    public BasicArrowButton getRightButton() {
        return this.right;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LabelEntrySlider.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LabelEntrySlider.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ChangeListener == null ? LabelEntrySlider.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        LabelEntrySlider les = new LabelEntrySlider("Test", 0.0, 100.0, 100);
        frame.getContentPane().add((Component)les, "North");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

