/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import jsky.coords.DMS;
import jsky.coords.HMS;
import jsky.util.gui.DialogUtil;

public class SexagesimalTableCellEditor
extends DefaultCellEditor {
    private boolean hoursFlag;

    public SexagesimalTableCellEditor(boolean hoursFlag) {
        super(new JTextField());
        this.hoursFlag = hoursFlag;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        double val = Double.NaN;
        if (value != null) {
            if (value instanceof Float) {
                val = ((Float)value).doubleValue();
            } else if (value instanceof Double) {
                val = (Double)value;
            }
        }
        if (!Double.isNaN(val)) {
            if (this.hoursFlag) {
                ((JTextField)component).setText(new HMS(val / 15.0).toString());
            } else {
                ((JTextField)component).setText(new DMS(val).toString());
            }
        }
        return component;
    }

    public Object getCellEditorValue() {
        Object o = super.getCellEditorValue();
        if (o instanceof String) {
            if (this.hoursFlag) {
                try {
                    HMS hms = new HMS((String)o);
                    return new Double(hms.getVal() * 15.0);
                }
                catch (Exception e) {
                    DialogUtil.error("Invalid value: '" + o + "', expected decimal degrees or h:m:s");
                }
            } else {
                try {
                    DMS dms = new DMS((String)o);
                    return new Double(dms.getVal());
                }
                catch (Exception e) {
                    DialogUtil.error("Invalid value: '" + o + "', expected decimal degrees or d:m:s");
                }
            }
        }
        return o;
    }
}

