/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import jsky.util.Resources;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DialogUtil;

public class ZoomControl
extends JPanel {
    protected JComboBox comboBox;
    protected JButton zoomIn;
    protected JButton zoomOut;
    protected String[] labels;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ZoomControl(String[] labels, boolean withButtons) {
        this.labels = labels;
        this.comboBox = new JComboBox<String>(labels);
        this.comboBox.setEditable(true);
        this.comboBox.setAlignmentX(0.0f);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String newSelection = (String)cb.getSelectedItem();
                try {
                    float f = Float.parseFloat(newSelection);
                }
                catch (NumberFormatException ex) {
                    DialogUtil.error("Please enter the numeric zoom factor.");
                    return;
                }
                ZoomControl.this.fireAction(new ActionEvent(this, 0, newSelection));
            }
        });
        this.setTextWidth(55);
        JPanel panel = new JPanel();
        this.add(this.comboBox);
        if (withButtons) {
            this.zoomIn = new JButton(Resources.getIcon("ZoomIn24.gif"));
            this.zoomIn.setBorder(new BevelBorder(0));
            this.zoomIn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ZoomControl.this.zoom(true);
                }
            });
            this.add(this.zoomIn);
            this.zoomOut = new JButton(Resources.getIcon("ZoomOut24.gif"));
            this.zoomOut.setBorder(new BevelBorder(0));
            this.zoomOut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ZoomControl.this.zoom(false);
                }
            });
            this.add(this.zoomOut);
        }
        this.setSelectedItem("1");
    }

    public ZoomControl(String[] labels) {
        this(labels, true);
    }

    public void setTextWidth(int width) {
        Dimension d = this.comboBox.getPreferredSize();
        d.width = width;
        this.comboBox.setPreferredSize(d);
    }

    public void setSelectedItem(String value) {
        this.comboBox.getModel().setSelectedItem(value);
    }

    public void setSelectedItem(float zoomFactor) {
        String s;
        if (zoomFactor < 1.0f) {
            if ((double)zoomFactor < 0.1) {
                return;
            }
            NumberFormat fmt = NumberFormat.getInstance(Locale.US);
            fmt.setMaximumFractionDigits(1);
            s = String.valueOf(fmt.format(zoomFactor));
        } else {
            s = String.valueOf((int)zoomFactor);
        }
        this.comboBox.getModel().setSelectedItem(s);
    }

    protected void zoom(boolean in) {
        String s = (String)this.comboBox.getSelectedItem();
        float zoomFactor = Float.valueOf(s).floatValue();
        zoomFactor = in ? ((double)zoomFactor < 1.0 ? (float)((double)zoomFactor + 0.1) : (zoomFactor += 1.0f)) : ((double)zoomFactor <= 1.0 ? (float)((double)zoomFactor - 0.1) : (zoomFactor -= 1.0f));
        this.setSelectedItem(zoomFactor);
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public JButton getZoomInButton() {
        return this.zoomIn;
    }

    public JButton getZoomOutButton() {
        return this.zoomOut;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ZoomControl.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ZoomControl.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    protected void fireAction(ActionEvent actionEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ActionListener == null ? ZoomControl.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)listeners[i + 1]).actionPerformed(actionEvent);
            }
            i -= 2;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        String[] labels = new String[]{"0.125", "0.25", "0.5", "1", "2", "4", "8", "16"};
        ZoomControl zoomControl = new ZoomControl(labels);
        zoomControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                float f = Float.parseFloat(e.getActionCommand());
                System.out.println("Set zoom factor to: " + f);
            }
        });
        frame.getContentPane().add((Component)zoomControl, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

