/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Logger;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.Driver;
import uk.ac.starlink.topcat.HelpWindow;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatUtils;

public class AuxWindow
extends JFrame {
    private JMenu fileMenu;
    private JToolBar toolBar;
    private JLabel headingLabel;
    private JPanel mainArea;
    private JPanel controlPanel;
    private JMenuBar menuBar;
    private boolean closeIsExit;
    private boolean isStandalone;
    private Action aboutAct;
    private Action controlAct;
    private Action closeAct;
    private Action exitAct;
    private Action helpAct;
    private static final Cursor busyCursor;
    private static final Logger logger;
    private static final Icon LOGO;
    private static HelpSet hset;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$AuxWindow;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$HelpWindow;

    public AuxWindow(String title, Component parent) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        if (parent != null) {
            AuxWindow.positionAfter(parent, this);
        }
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.controlAct = new AuxAction("Control Window", ResourceIcon.CONTROL, "Ensure Control Window is visible");
        this.closeAct = new AuxAction("Close", ResourceIcon.CLOSE, "Close this window");
        this.exitAct = new AuxAction("Exit", ResourceIcon.EXIT, "Exit the application");
        this.fileMenu.add(this.controlAct);
        JMenuItem closeItem = this.fileMenu.add(this.closeAct);
        closeItem.setMnemonic(67);
        this.isStandalone = Driver.isStandalone();
        if (this.isStandalone) {
            JMenuItem exitItem = this.fileMenu.add(this.exitAct);
            exitItem.setMnemonic(88);
        }
        this.toolBar = new JToolBar();
        this.toolBar.addSeparator();
        this.toolBar.setFloatable(false);
        this.getContentPane().add((Component)this.toolBar, "North");
        JPanel overPanel = new JPanel();
        overPanel.setLayout(new BoxLayout(overPanel, 1));
        this.headingLabel = new JLabel();
        this.headingLabel.setAlignmentX(0.0f);
        Box headingBox = new Box(0);
        headingBox.add(this.headingLabel);
        headingBox.add(Box.createHorizontalGlue());
        this.mainArea = new JPanel(new BorderLayout());
        this.controlPanel = new JPanel();
        overPanel.add(headingBox);
        overPanel.add(this.mainArea);
        overPanel.add(this.controlPanel);
        overPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)overPanel, "Center");
    }

    protected void addHelp(String helpID) {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        this.menuBar.add(helpMenu);
        if (AuxWindow.helpIdExists(helpID)) {
            this.helpAct = new HelpAction(helpID);
        } else {
            this.helpAct = new HelpAction(null);
            logger.warning("Unknown help ID " + helpID);
        }
        this.toolBar.add(this.helpAct);
        if (helpID != null) {
            helpMenu.add(new HelpAction(null));
        }
        helpMenu.add(this.helpAct);
        helpMenu.addSeparator();
        this.aboutAct = new AuxAction("About TOPCAT", null, null);
        helpMenu.add(this.aboutAct);
        this.toolBar.add(this.closeIsExit ? this.exitAct : this.closeAct);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.addSeparator();
        this.toolBar.add(new JLabel(LOGO));
        this.toolBar.addSeparator();
    }

    public void setBusy(boolean busy) {
        this.setCursor(busy ? busyCursor : null);
    }

    public void makeVisible() {
        this.setState(0);
        this.setVisible(true);
    }

    public JProgressBar placeProgressBar() {
        JProgressBar progBar = new JProgressBar();
        this.getContentPane().add((Component)progBar, "South");
        return progBar;
    }

    public void setCloseIsExit() {
        if (this.isStandalone) {
            this.closeIsExit = true;
            boolean exitFound = false;
            int i = this.fileMenu.getItemCount() - 1;
            while (i >= 0) {
                JMenuItem item = this.fileMenu.getItem(i);
                if (item != null) {
                    Action act = item.getAction();
                    if (act == this.closeAct) {
                        this.fileMenu.remove(item);
                    } else if (act == this.exitAct) {
                        exitFound = true;
                    } else if (act == this.controlAct) {
                        this.fileMenu.remove(item);
                    }
                }
                --i;
            }
            if (!$assertionsDisabled && !exitFound) {
                throw new AssertionError();
            }
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public void setMainHeading(String text) {
        this.headingLabel.setText(text);
    }

    public JPanel getMainArea() {
        return this.mainArea;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public boolean confirm(String message, String title) {
        return JOptionPane.showConfirmDialog(this, message, title, 2) == 0;
    }

    public Image getIconImage() {
        return ResourceIcon.TOPCAT.getImage();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static Border makeTitledBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), title);
    }

    public static void positionAfter(Component first, Window second) {
        GraphicsConfiguration gc = second.getGraphicsConfiguration();
        if (first == null || gc.equals(first.getGraphicsConfiguration())) {
            Point pos = null;
            if (first != null) {
                pos = first.getLocation();
            }
            if (pos == null) {
                pos = new Point(20, 20);
            }
            pos.x += 60;
            pos.y += 60;
            Rectangle newloc = new Rectangle(second.getBounds());
            newloc.setLocation(pos);
            Rectangle screen = gc.getBounds();
            if (screen.x <= newloc.x && screen.y <= newloc.y && screen.x + screen.width >= newloc.x + newloc.width && screen.y + screen.height >= newloc.y + newloc.height) {
                second.setLocation(pos);
            }
        }
    }

    public static boolean helpIdExists(String helpID) {
        if (hset == null) {
            URL hsResource = (class$uk$ac$starlink$topcat$HelpWindow == null ? (class$uk$ac$starlink$topcat$HelpWindow = AuxWindow.class$("uk.ac.starlink.topcat.HelpWindow")) : class$uk$ac$starlink$topcat$HelpWindow).getResource("help/sun253.hs");
            try {
                hset = new HelpSet(null, hsResource);
            }
            catch (HelpSetException e) {
                logger.warning("Can't locate helpset at " + hsResource);
            }
        }
        try {
            Map.ID.create((String)helpID, (HelpSet)hset);
            return true;
        }
        catch (BadIDException e) {
            return false;
        }
    }

    public static void recursiveSetEnabled(Component comp, boolean enabled) {
        if (comp.isFocusable()) {
            comp.setEnabled(enabled);
        }
        if (comp instanceof Container) {
            Component[] subComps = ((Container)comp).getComponents();
            int i = 0;
            while (i < subComps.length) {
                Component subComp = subComps[i];
                if (!(subComp instanceof JLabel)) {
                    AuxWindow.recursiveSetEnabled(subComp, enabled);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$AuxWindow == null ? (class$uk$ac$starlink$topcat$AuxWindow = AuxWindow.class$("uk.ac.starlink.topcat.AuxWindow")) : class$uk$ac$starlink$topcat$AuxWindow).desiredAssertionStatus();
        busyCursor = new Cursor(3);
        logger = Logger.getLogger("uk.ac.starlink.topcat");
        LOGO = new ImageIcon(ResourceIcon.STAR_LOGO.getImage().getScaledInstance(-1, 34, 4));
    }

    public class HelpAction
    extends AbstractAction {
        private String helpID;
        private HelpWindow helpWin;

        public HelpAction(String helpID) {
            this.helpID = helpID;
            this.putValue("Name", helpID == null ? "Help" : "Help for window");
            this.putValue("SmallIcon", helpID == null ? ResourceIcon.BLANK : ResourceIcon.HELP);
            this.putValue("ShortDescription", helpID == null ? "Display help browser" : "Display help for this window in browser");
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.helpWin == null) {
                this.helpWin = HelpWindow.getInstance(AuxWindow.this);
            }
            this.helpWin.makeVisible();
            this.helpWin.setID(this.helpID);
        }
    }

    private class AuxAction
    extends BasicAction {
        AuxAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == AuxWindow.this.closeAct) {
                AuxWindow.this.dispose();
            } else if (this == AuxWindow.this.exitAct) {
                ControlWindow.getInstance().exit(true);
            }
            if (this == AuxWindow.this.controlAct) {
                ControlWindow.getInstance().makeVisible();
            } else if (this == AuxWindow.this.aboutAct) {
                JOptionPane.showMessageDialog(AuxWindow.this, TopcatUtils.getAbout(), "About TOPCAT", 1, ResourceIcon.TOPCAT_LOGO);
            }
        }
    }
}

