/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public abstract class ColumnConverter {
    static /* synthetic */ Class class$java$lang$Number;

    public abstract Object convertValue(Object var1);

    public abstract String toString();

    public static ColumnConverter[] getConverters(ValueInfo info) {
        String units = info.getUnitString();
        Class clazz = info.getContentClass();
        if (ColumnConverter.matches(info, (ValueInfo)Tables.RA_INFO) && (class$java$lang$Number == null ? (class$java$lang$Number = ColumnConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) && "radians".equalsIgnoreCase(units)) {
            return new ColumnConverter[]{new FactorConverter("degrees", Math.PI / 180), new FactorConverter("hours", 0.2617993877991494), new UnitConverter("radians")};
        }
        if (ColumnConverter.matches(info, (ValueInfo)Tables.DEC_INFO) && (class$java$lang$Number == null ? (class$java$lang$Number = ColumnConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) && "radians".equalsIgnoreCase(units)) {
            return new ColumnConverter[]{new FactorConverter("degrees", Math.PI / 180), new UnitConverter("radians")};
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = ColumnConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) && "radians".equalsIgnoreCase(units)) {
            return new ColumnConverter[]{new FactorConverter("arcsec", 4.84813681109536E-6), new FactorConverter("arcmin", 2.908882086657216E-4), new FactorConverter("degrees", Math.PI / 180), new UnitConverter("radians")};
        }
        return new ColumnConverter[]{new UnitConverter(units)};
    }

    private static boolean matches(ValueInfo info1, ValueInfo info2) {
        return info1 != null && info2 != null && info1.getName().equals(info2.getName()) && info1.getContentClass().equals(info2.getContentClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FactorConverter
    extends ColumnConverter {
        final String name_;
        final double factor_;

        public FactorConverter(String name, double factor) {
            this.name_ = name;
            this.factor_ = factor;
        }

        public Object convertValue(Object value) {
            return value instanceof Number ? new Double(((Number)value).doubleValue() * this.factor_) : null;
        }

        public String toString() {
            return this.name_;
        }
    }

    private static class UnitConverter
    extends ColumnConverter {
        final String name_;

        public UnitConverter(String name) {
            this.name_ = name;
        }

        public Object convertValue(Object value) {
            return value;
        }

        public String toString() {
            return this.name_;
        }
    }
}

