/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Dimension;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class ColumnIndexSpinner
extends JSpinner {
    private TableColumnModel columnModel;
    private ColumnSpinnerModel spinnerModel;

    public ColumnIndexSpinner(TableColumnModel columnModel) {
        super(new ColumnSpinnerModel(columnModel));
        this.columnModel = columnModel;
        this.spinnerModel = (ColumnSpinnerModel)this.getModel();
        Dimension spinSize = this.getPreferredSize();
        this.setPreferredSize(new Dimension(spinSize.width + 32, spinSize.height));
    }

    public int getColumnIndex() {
        Object value = this.getValue();
        if (value instanceof Number) {
            int index1 = ((Number)this.getValue()).intValue();
            return index1 - 1;
        }
        return 0;
    }

    public void setColumnIndex(int index) {
        int index0 = index < 0 ? ((Number)((Object)this.spinnerModel.getMaximum())).intValue() : index + 1;
        this.setValue(new Integer(index0));
    }

    private static class ColumnSpinnerModel
    extends SpinnerNumberModel
    implements TableColumnModelListener {
        TableColumnModel columnModel;

        ColumnSpinnerModel(TableColumnModel columnModel) {
            this.columnModel = columnModel;
            columnModel.addColumnModelListener(this);
            this.reconfigure();
        }

        public void columnAdded(TableColumnModelEvent evt) {
            this.reconfigure();
        }

        public void columnRemoved(TableColumnModelEvent evt) {
            this.reconfigure();
        }

        public void columnMoved(TableColumnModelEvent evt) {
        }

        public void columnMarginChanged(ChangeEvent evt) {
        }

        public void columnSelectionChanged(ListSelectionEvent evt) {
        }

        private void reconfigure() {
            this.setMinimum(new Integer(1));
            this.setMaximum(new Integer(this.columnModel.getColumnCount() + 1));
            Object v = this.getValue();
            if (v instanceof Comparable) {
                Comparable val = (Comparable)v;
                if (val.compareTo(this.getMaximum()) > 0) {
                    this.setValue(this.getMaximum());
                    this.fireStateChanged();
                } else if (val.compareTo(this.getMinimum()) < 0) {
                    this.setValue(this.getMinimum());
                    this.fireStateChanged();
                }
            }
        }
    }
}

