/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ShapeIterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.TableRowHeader;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.SkyColumnQueryWindow;
import uk.ac.starlink.topcat.SortOrder;
import uk.ac.starlink.topcat.SyntheticColumn;
import uk.ac.starlink.topcat.SyntheticColumnQueryWindow;
import uk.ac.starlink.topcat.TableColumnModelAdapter;
import uk.ac.starlink.topcat.TableViewerWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.TopcatViewWindow;
import uk.ac.starlink.topcat.ViewerTableModel;
import uk.ac.starlink.topcat.WindowAction;

public class ColumnInfoWindow
extends TopcatViewWindow {
    private final TopcatModel tcModel;
    private final PlasticStarTable dataModel;
    private final TableColumnModel columnModel;
    private final ViewerTableModel viewModel;
    private final ColumnList columnList;
    private final Action addcolAct;
    private final Action addskycolAct;
    private final Action replacecolAct;
    private final Action hidecolAct;
    private final Action revealcolAct;
    private final Action explodecolAct;
    private ColumnInfo indexColumnInfo;
    private JTable jtab;
    private AbstractTableModel metaTableModel;
    private static final Logger logger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ColumnInfoWindow;
    static /* synthetic */ Class class$java$lang$Long;

    public ColumnInfoWindow(final TopcatModel tcModel, Component parent) {
        super(tcModel, "Table columns", parent);
        this.tcModel = tcModel;
        this.dataModel = tcModel.getDataModel();
        this.columnModel = tcModel.getColumnModel();
        this.columnList = tcModel.getColumnList();
        this.viewModel = tcModel.getViewModel();
        this.indexColumnInfo = ColumnInfoWindow.dummyIndexColumn();
        ArrayList<MetaColumn> metas = new ArrayList<MetaColumn>();
        metas.add(new MetaColumn("Visible", class$java$lang$Boolean == null ? (class$java$lang$Boolean = ColumnInfoWindow.class$("java.lang.Boolean")) : class$java$lang$Boolean){

            public Object getValue(int irow) {
                if (irow == 0) {
                    return null;
                }
                int jrow = ColumnInfoWindow.this.getColumnListIndexFromRow(irow);
                return ColumnInfoWindow.this.columnList.isActive(jrow);
            }

            public boolean isEditable(int irow) {
                return irow > 0;
            }

            public void setValue(int irow, Object value) {
                int jrow = ColumnInfoWindow.this.getColumnListIndexFromRow(irow);
                ColumnInfoWindow.this.columnList.setActive(jrow, Boolean.TRUE.equals(value));
            }
        });
        metas.add(new MetaColumn("Name", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ColumnInfoWindow.this.getColumnInfo(irow).getName();
            }

            public boolean isEditable(int irow) {
                return irow > 0;
            }

            public void setValue(int irow, Object value) {
                tcModel.renameColumn(ColumnInfoWindow.this.getColumnFromRow(irow), (String)value);
            }
        });
        metas.add(new ValueInfoMetaColumn(TopcatUtils.COLID_INFO, false));
        metas.add(new MetaColumn("Class", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return DefaultValueInfo.formatClass((Class)ColumnInfoWindow.this.getColumnInfo(irow).getContentClass());
            }
        });
        metas.add(new MetaColumn("Shape", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return DefaultValueInfo.formatShape((int[])ColumnInfoWindow.this.getColumnInfo(irow).getShape());
            }
        });
        int sizePos = metas.size();
        metas.add(new MetaColumn("Element Size", class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnInfoWindow.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object getValue(int irow) {
                int size = ColumnInfoWindow.this.getColumnInfo(irow).getElementSize();
                return size > 0 ? new Integer(size) : null;
            }

            public boolean isEditable(int irow) {
                return irow > 0;
            }

            public void setValue(int irow, Object value) {
                int size;
                if (value instanceof Number) {
                    size = ((Number)value).intValue();
                } else if (value instanceof String) {
                    try {
                        size = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        size = -1;
                    }
                } else {
                    size = -1;
                }
                if (size <= 0) {
                    size = -1;
                }
                ColumnInfoWindow.this.getColumnInfo(irow).setElementSize(size);
            }
        });
        metas.add(new MetaColumn("Units", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ColumnInfoWindow.this.getColumnInfo(irow).getUnitString();
            }

            public boolean isEditable(int irow) {
                return irow > 0;
            }

            public void setValue(int irow, Object value) {
                ColumnInfoWindow.this.getColumnInfo(irow).setUnitString((String)value);
            }
        });
        metas.add(new ValueInfoMetaColumn(TopcatUtils.EXPR_INFO){

            private SyntheticColumn getSyntheticColumn(int irow) {
                ColumnData coldata = ColumnInfoWindow.this.dataModel.getColumnData(ColumnInfoWindow.this.getModelIndexFromRow(irow));
                return coldata instanceof SyntheticColumn ? (SyntheticColumn)coldata : null;
            }

            public boolean isEditable(int irow) {
                return this.getSyntheticColumn(irow) != null;
            }

            public void setValue(int irow, Object value) {
                try {
                    this.getSyntheticColumn(irow).setExpression((String)value, null);
                    super.setValue(irow, value);
                    ColumnInfoWindow.this.viewModel.fireTableDataChanged();
                }
                catch (CompilationException e) {
                    String[] msg = new String[]{"Syntax error in synthetic column expression \"" + value + "\":", e.getMessage()};
                    JOptionPane.showMessageDialog(ColumnInfoWindow.this, msg, "Expression Syntax Error", 0);
                }
            }
        });
        metas.add(new MetaColumn("Description", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return TopcatUtils.getBaseDescription(ColumnInfoWindow.this.getColumnInfo(irow));
            }

            public boolean isEditable(int irow) {
                return irow > 0;
            }

            public void setValue(int irow, Object value) {
                String sval = (String)value;
                TopcatUtils.setBaseDescription(ColumnInfoWindow.this.getColumnInfo(irow), sval);
            }
        });
        metas.add(new MetaColumn("UCD", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ColumnInfoWindow.this.getColumnInfo(irow).getUCD();
            }

            public boolean isEditable(int irow) {
                return irow > 0;
            }

            public void setValue(int irow, Object value) {
                ColumnInfoWindow.this.getColumnInfo(irow).setUCD((String)value);
                ColumnInfoWindow.this.metaTableModel.fireTableRowsUpdated(irow, irow);
            }
        });
        metas.add(new MetaColumn("UCD description", class$java$lang$String == null ? (class$java$lang$String = ColumnInfoWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                UCD ucd;
                String ucdid = ColumnInfoWindow.this.getColumnInfo(irow).getUCD();
                if (ucdid != null && (ucd = UCD.getUCD((String)ColumnInfoWindow.this.getColumnInfo(irow).getUCD())) != null) {
                    return ucd.getDescription();
                }
                return null;
            }
        });
        ArrayList auxInfos = new ArrayList(this.dataModel.getColumnAuxDataInfos());
        auxInfos.remove(TopcatUtils.EXPR_INFO);
        auxInfos.remove(TopcatUtils.BASE_DESCRIPTION_INFO);
        auxInfos.remove(TopcatUtils.COLID_INFO);
        Iterator it = auxInfos.iterator();
        while (it.hasNext()) {
            metas.add(new ValueInfoMetaColumn((ValueInfo)it.next(), true));
        }
        this.metaTableModel = new MetaColumnTableModel(metas){

            public int getRowCount() {
                return ColumnInfoWindow.this.columnList.size() + 1;
            }

            public boolean isCellEditable(int irow, int icol) {
                return irow > 0 && super.isCellEditable(irow, icol);
            }
        };
        this.jtab = new JTable(this.metaTableModel);
        this.jtab.setAutoResizeMode(0);
        this.jtab.setColumnSelectionAllowed(false);
        this.jtab.setRowSelectionAllowed(true);
        StarJTable.configureColumnWidths((JTable)this.jtab, (int)20000, (int)100);
        MetaColumnModel metaColumnModel = new MetaColumnModel(this.jtab.getColumnModel(), this.metaTableModel);
        metaColumnModel.purgeEmptyColumns();
        this.jtab.setColumnModel(metaColumnModel);
        metaColumnModel.removeColumn(sizePos);
        SizingScrollPane scroller = new SizingScrollPane(this.jtab);
        this.getMainArea().add(scroller);
        TableRowHeader rowHead = new TableRowHeader(this.jtab){

            public int rowNumber(int irow) {
                return irow;
            }
        };
        scroller.setRowHeaderView((Component)rowHead);
        this.columnModel.addColumnModelListener(new TableColumnModelAdapter(){

            public void columnAdded(TableColumnModelEvent evt) {
                ColumnInfoWindow.this.metaTableModel.fireTableDataChanged();
            }

            public void columnMoved(TableColumnModelEvent evt) {
                ColumnInfoWindow.this.metaTableModel.fireTableDataChanged();
            }

            public void columnRemoved(TableColumnModelEvent evt) {
                ColumnInfoWindow.this.metaTableModel.fireTableDataChanged();
            }
        });
        this.addcolAct = new ColumnInfoAction("New Synthetic Column", ResourceIcon.ADD, "Add a new column defined algebraically from existing ones");
        this.addskycolAct = new ColumnInfoAction("New Sky Coordinate Columns", ResourceIcon.ADDSKY, "Add new sky coordinate columns based on existing ones");
        this.replacecolAct = new ColumnInfoAction("Replace Column With Synthetic", ResourceIcon.MODIFY, "Replace the selected column with a new one based on it");
        this.hidecolAct = new ColumnInfoAction("Hide Selected Column(s)", ResourceIcon.HIDE, "Hide all selected columns");
        this.revealcolAct = new ColumnInfoAction("Reveal Selected Column(s)", ResourceIcon.REVEAL, "Reveal All Selected columns");
        this.explodecolAct = new ColumnInfoAction("Explode Array Column", ResourceIcon.EXPLODE, "Replace N-element array column with N scalar columns");
        final SortAction sortupAct = new SortAction(true);
        final SortAction sortdownAct = new SortAction(false);
        this.addcolAct.setEnabled(TopcatUtils.canJel());
        this.replacecolAct.setEnabled(TopcatUtils.canJel());
        JMenu colMenu = new JMenu("Columns");
        colMenu.setMnemonic(67);
        colMenu.add(this.addcolAct);
        colMenu.add(this.addskycolAct);
        colMenu.add(this.replacecolAct);
        colMenu.add(this.hidecolAct);
        colMenu.add(this.revealcolAct);
        colMenu.add(this.explodecolAct);
        colMenu.add(sortupAct);
        colMenu.add(sortdownAct);
        this.getJMenuBar().add(colMenu);
        JMenu displayMenu = metaColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        ListSelectionListener selList = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                boolean hasArraySelection;
                boolean hasUniqueSelection;
                int nsel = ColumnInfoWindow.this.jtab.getSelectedRowCount();
                boolean hasSelection = nsel > 0;
                boolean bl = hasUniqueSelection = nsel == 1;
                if (hasUniqueSelection && ColumnInfoWindow.this.jtab.getSelectedRow() == 0) {
                    hasUniqueSelection = false;
                    hasSelection = false;
                }
                if (hasUniqueSelection) {
                    StarTableColumn tcol = (StarTableColumn)ColumnInfoWindow.this.getColumnFromRow(ColumnInfoWindow.this.jtab.getSelectedRow());
                    int nel = ColumnInfoWindow.this.getElementCount((ValueInfo)tcol.getColumnInfo());
                    hasArraySelection = nel > 0;
                    WindowAction viewAct = tcModel.getViewerAction();
                    if (viewAct.hasWindow()) {
                        int viewCol = tcol.getModelIndex();
                        TableViewerWindow tv = (TableViewerWindow)viewAct.getWindow(ColumnInfoWindow.this);
                        tv.scrollToColumn(viewCol);
                    }
                } else {
                    hasArraySelection = false;
                }
                ColumnInfoWindow.this.hidecolAct.setEnabled(hasSelection);
                ColumnInfoWindow.this.revealcolAct.setEnabled(hasSelection);
                ColumnInfoWindow.this.explodecolAct.setEnabled(hasArraySelection);
                sortupAct.setEnabled(hasUniqueSelection);
                sortdownAct.setEnabled(hasUniqueSelection);
                ColumnInfoWindow.this.replacecolAct.setEnabled(hasUniqueSelection && TopcatUtils.canJel());
            }
        };
        ListSelectionModel selectionModel = this.jtab.getSelectionModel();
        selectionModel.addListSelectionListener(selList);
        selList.valueChanged(null);
        this.getToolBar().add(this.addcolAct);
        this.getToolBar().add(this.addskycolAct);
        this.getToolBar().add(this.replacecolAct);
        this.getToolBar().add(this.hidecolAct);
        this.getToolBar().add(this.revealcolAct);
        this.getToolBar().add(this.explodecolAct);
        this.getToolBar().addSeparator();
        this.getToolBar().add(sortupAct);
        this.getToolBar().add(sortdownAct);
        this.getToolBar().addSeparator();
        this.addHelp("ColumnInfoWindow");
        this.pack();
        this.setVisible(true);
    }

    private int getModelIndexFromRow(int irow) {
        if (!$assertionsDisabled && irow == 0) {
            throw new AssertionError();
        }
        return this.getColumnFromRow(irow).getModelIndex();
    }

    private int getColumnListIndexFromRow(int irow) {
        if (!$assertionsDisabled && irow <= 0) {
            throw new AssertionError();
        }
        return irow - 1;
    }

    private int getActiveIndexFromRow(int irow) {
        int iActive = 0;
        int i = 1;
        while (i <= irow) {
            if (this.columnList.isActive(this.getColumnListIndexFromRow(i))) {
                ++iActive;
            }
            ++i;
        }
        return iActive;
    }

    private TableColumn getColumnFromRow(int irow) {
        return this.columnList.getColumn(this.getColumnListIndexFromRow(irow));
    }

    private ColumnInfo getColumnInfo(int irow) {
        if (irow == 0) {
            return this.indexColumnInfo;
        }
        return this.dataModel.getColumnInfo(this.getModelIndexFromRow(irow));
    }

    private int getElementCount(ValueInfo info) {
        if (info.isArray()) {
            int[] shape = info.getShape();
            int nel = 1;
            int i = 0;
            while (i < shape.length) {
                int dim = shape[i];
                if (dim >= 0) {
                    nel *= dim;
                } else {
                    return -1;
                }
                ++i;
            }
            return nel;
        }
        return 0;
    }

    private void explodeColumn(StarTableColumn tcol) {
        ColumnInfo baseInfo = tcol.getColumnInfo();
        int insertPos = this.columnList.getModelIndex(this.columnList.indexOf((TableColumn)tcol));
        String baseName = baseInfo.getName();
        String baseDesc = baseInfo.getDescription();
        String baseExpr = baseInfo.getAuxDatum(TopcatUtils.COLID_INFO).getValue().toString();
        ColumnInfo elInfo = new ColumnInfo(baseInfo);
        elInfo.setShape(null);
        int ipos = 0;
        ShapeIterator it = new ShapeIterator(baseInfo.getShape());
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            StringBuffer postxt = new StringBuffer();
            int i = 0;
            while (i < pos.length) {
                postxt.append('_');
                postxt.append(Integer.toString(pos[i] + 1));
                ++i;
            }
            ColumnInfo colInfo = new ColumnInfo(elInfo);
            colInfo.setName(baseName + postxt.toString());
            colInfo.setDescription("Element " + (ipos + 1) + " of " + baseName);
            String colExpr = baseExpr + '[' + ipos + ']';
            try {
                SyntheticColumn elcol = new SyntheticColumn((ValueInfo)colInfo, (StarTable)this.dataModel, null, colExpr, null);
                this.tcModel.appendColumn(elcol, ++insertPos);
            }
            catch (CompilationException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)e.getMessage()))).initCause(e));
            }
            ++ipos;
        }
        this.columnModel.removeColumn((TableColumn)tcol);
    }

    public static ColumnInfo dummyIndexColumn() {
        DefaultValueInfo indexInfo = new DefaultValueInfo("Index", class$java$lang$Long == null ? (class$java$lang$Long = ColumnInfoWindow.class$("java.lang.Long")) : class$java$lang$Long, "Table row index");
        ColumnInfo cinfo = new ColumnInfo((ValueInfo)indexInfo);
        cinfo.setAuxDatum(new DescribedValue(TopcatUtils.COLID_INFO, (Object)"$0"));
        return cinfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$ColumnInfoWindow == null ? (class$uk$ac$starlink$topcat$ColumnInfoWindow = ColumnInfoWindow.class$("uk.ac.starlink.topcat.ColumnInfoWindow")) : class$uk$ac$starlink$topcat$ColumnInfoWindow).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.topcat");
    }

    private class SortAction
    extends AbstractAction {
        private boolean ascending;

        public SortAction(boolean ascending) {
            super("Sort Selected " + (ascending ? "Up" : "Down"), ascending ? ResourceIcon.UP : ResourceIcon.DOWN);
            this.ascending = ascending;
            this.putValue("ShortDescription", "Sort rows by " + (ascending ? "a" : "de") + "scending value of selected column");
        }

        public void actionPerformed(ActionEvent evt) {
            int irow = ColumnInfoWindow.this.jtab.getSelectedRow();
            SortOrder order = irow > 0 ? new SortOrder(ColumnInfoWindow.this.getColumnFromRow(irow)) : SortOrder.NONE;
            ColumnInfoWindow.this.tcModel.sortBy(order, this.ascending);
        }
    }

    private class ColumnInfoAction
    extends BasicAction {
        ColumnInfoAction(String name, Icon icon, String description) {
            super(name, icon, description);
        }

        public void actionPerformed(ActionEvent evt) {
            ColumnInfoWindow parent = ColumnInfoWindow.this;
            if (this == ColumnInfoWindow.this.addcolAct) {
                int insertPos;
                int[] selrows = ColumnInfoWindow.this.jtab.getSelectedRows();
                if (selrows.length > 0) {
                    int iSel = selrows[selrows.length - 1];
                    insertPos = ColumnInfoWindow.this.getActiveIndexFromRow(iSel);
                } else {
                    insertPos = -1;
                }
                new SyntheticColumnQueryWindow(ColumnInfoWindow.this.tcModel, insertPos, parent);
            } else if (this == ColumnInfoWindow.this.addskycolAct) {
                new SkyColumnQueryWindow(ColumnInfoWindow.this.tcModel, (Component)parent);
            } else if (this == ColumnInfoWindow.this.replacecolAct) {
                if (ColumnInfoWindow.this.jtab.getSelectedRowCount() == 1) {
                    int selrow = ColumnInfoWindow.this.jtab.getSelectedRow();
                    StarTableColumn tcol = (StarTableColumn)ColumnInfoWindow.this.getColumnFromRow(selrow);
                    SyntheticColumnQueryWindow.replaceColumnDialog(ColumnInfoWindow.this.tcModel, tcol, parent);
                } else {
                    logger.warning("Replace column enabled erroneously");
                }
            } else if (this == ColumnInfoWindow.this.explodecolAct) {
                int selrow;
                StarTableColumn tcol;
                ColumnInfo cinfo;
                int nel;
                if (ColumnInfoWindow.this.jtab.getSelectedRowCount() == 1 && (nel = ColumnInfoWindow.this.getElementCount((ValueInfo)(cinfo = (tcol = (StarTableColumn)ColumnInfoWindow.this.getColumnFromRow(selrow = ColumnInfoWindow.this.jtab.getSelectedRow())).getColumnInfo()))) > 0) {
                    String yesOpt = "OK";
                    String noOpt = "Cancel";
                    String msg = "Replace array column " + cinfo.getName() + " with " + nel + " scalar columns?";
                    if (JOptionPane.showOptionDialog(parent, msg, "Explode Column", 0, 3, null, new String[]{yesOpt, noOpt}, yesOpt) == 0) {
                        ColumnInfoWindow.this.explodeColumn(tcol);
                    }
                }
            } else if (this == ColumnInfoWindow.this.hidecolAct || this == ColumnInfoWindow.this.revealcolAct) {
                boolean active = this == ColumnInfoWindow.this.revealcolAct;
                int[] selected = ColumnInfoWindow.this.jtab.getSelectedRows();
                Arrays.sort(selected);
                int i = 0;
                while (i < selected.length) {
                    if (selected[i] > 0) {
                        int jrow = ColumnInfoWindow.this.getColumnListIndexFromRow(selected[i]);
                        ColumnInfoWindow.this.columnList.setActive(jrow, active);
                    }
                    ++i;
                }
            } else {
                throw new AssertionError();
            }
        }
    }

    private class ValueInfoMetaColumn
    extends MetaColumn {
        private ValueInfo vinfo;
        private Class vclass;
        private boolean isEditable;

        ValueInfoMetaColumn(ValueInfo vinfo, boolean isEditable) {
            super(vinfo.getName(), vinfo.getContentClass());
            this.vinfo = vinfo;
            this.vclass = vinfo.getContentClass();
            this.isEditable = isEditable;
        }

        ValueInfoMetaColumn(ValueInfo vinfo) {
            this(vinfo, false);
        }

        private DescribedValue getAuxDatum(int irow) {
            return ColumnInfoWindow.this.getColumnInfo(irow).getAuxDatum(this.vinfo);
        }

        public Object getValue(int irow) {
            Object value;
            DescribedValue auxDatum = this.getAuxDatum(irow);
            if (auxDatum != null && (value = auxDatum.getValue()) != null && this.vclass.isAssignableFrom(value.getClass())) {
                return value;
            }
            return null;
        }

        public boolean isEditable(int irow) {
            return this.isEditable;
        }

        public void setValue(int irow, Object value) {
            DescribedValue auxDatum = this.getAuxDatum(irow);
            if (auxDatum == null) {
                auxDatum = new DescribedValue(this.vinfo);
                ColumnInfoWindow.this.getColumnInfo(irow).getAuxData().add(auxDatum);
            }
            if (value instanceof String) {
                auxDatum.setValue(this.vinfo.unformatString((String)value));
            } else if (value == null) {
                auxDatum.setValue(null);
            }
        }
    }
}

