/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ColumnCellRenderer;
import uk.ac.starlink.topcat.ColumnConverter;
import uk.ac.starlink.topcat.ColumnSelectorModel;
import uk.ac.starlink.topcat.TopcatModel;

public class ColumnSelector
extends JComponent {
    private ColumnSelectorModel model_;
    private final ValueInfo info_;
    private final JComboBox colComboBox_;
    private final JComboBox convComboBox_;
    private final Component[] components_;

    public ColumnSelector(ValueInfo info) {
        this.info_ = info;
        String units = this.info_.getUnitString();
        ArrayList<JComponent> compList = new ArrayList<JComponent>();
        JLabel label = new JLabel(this.info_.getName() + " column:");
        label.setToolTipText("Select column for " + this.info_.getDescription());
        this.colComboBox_ = new JComboBox();
        this.colComboBox_.setRenderer(new ColumnCellRenderer(this.colComboBox_));
        ColumnConverter[] converters = ColumnConverter.getConverters(this.info_);
        if (converters.length > 1) {
            this.convComboBox_ = new JComboBox<ColumnConverter>(converters);
            this.convComboBox_.setSelectedIndex(0);
            this.convComboBox_.setToolTipText("Units for column " + this.info_.getName());
        } else {
            this.convComboBox_ = null;
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(label);
        compList.add(label);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.colComboBox_);
        compList.add(this.colComboBox_);
        if (this.convComboBox_ != null) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.convComboBox_);
            compList.add(this.convComboBox_);
        } else if (units != null && units.toString().length() > 0) {
            this.add(Box.createHorizontalStrut(5));
            JLabel ulabel = new JLabel(" (" + units.trim() + ") ");
            this.add(ulabel);
            compList.add(ulabel);
        }
        this.components_ = compList.toArray(new Component[0]);
        this.setEnabled(false);
    }

    public ColumnSelector(ColumnSelectorModel model) {
        this(model.getValueInfo());
        this.setModel(model);
    }

    public void setModel(ColumnSelectorModel model) {
        if (model != null && model.getValueInfo() != this.info_) {
            throw new IllegalArgumentException("Model ValueInfo doesn't match this selector");
        }
        this.model_ = model;
        if (model == null) {
            this.setEnabled(false);
            DefaultComboBoxModel dummy = new DefaultComboBoxModel();
            this.colComboBox_.setModel(dummy);
            if (this.convComboBox_ != null) {
                this.convComboBox_.setModel(dummy);
            }
        } else {
            this.setEnabled(true);
            this.colComboBox_.setModel(model.getColumnModel());
            if (this.convComboBox_ != null) {
                this.convComboBox_.setModel(model.getConverterModel());
            }
        }
    }

    public void setTable(TopcatModel tcModel) {
        this.setModel(tcModel.getColumnSelectorModel(this.info_));
    }

    public ColumnData getColumnData() {
        return this.model_.getColumnData();
    }

    public ColumnSelectorModel getModel() {
        return this.model_;
    }

    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < this.components_.length) {
            this.components_[i].setEnabled(enabled);
            ++i;
        }
        super.setEnabled(enabled);
    }
}

