/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.ConcatStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ColumnComboBoxModel;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.TablesListComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;

public class ConcatWindow
extends AuxWindow
implements ItemListener,
TableColumnModelListener {
    private final JComboBox t1selector;
    private final JComboBox t2selector;
    private final JScrollPane colScroller;
    private final Action goAct;
    private JComboBox[] colSelectors;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ConcatWindow;

    public ConcatWindow(Component parent) {
        super("Concatenate Tables", parent);
        JPanel main = this.getMainArea();
        main.setLayout(new BorderLayout());
        this.t1selector = new JComboBox(new TablesListComboBoxModel());
        this.t1selector.setToolTipText("Table supplying the columns and top rows");
        this.t1selector.addItemListener(this);
        this.t2selector = new JComboBox(new TablesListComboBoxModel());
        this.t2selector.setToolTipText("Table supplying the bottom rows");
        this.t2selector.addItemListener(this);
        Box tBox = Box.createVerticalBox();
        main.add((Component)tBox, "North");
        Box line = Box.createHorizontalBox();
        line.add(Box.createHorizontalGlue());
        line.add(new JLabel("Base Table: "));
        line.add(this.t1selector);
        tBox.add(line);
        line = Box.createHorizontalBox();
        line.add(Box.createHorizontalGlue());
        line.add(new JLabel("Appended Table: "));
        line.add(this.t2selector);
        tBox.add(line);
        this.colScroller = new JScrollPane();
        this.colScroller.setPreferredSize(new Dimension(300, 250));
        this.colScroller.setBorder(AuxWindow.makeTitledBorder("Column Assignments"));
        main.add((Component)this.colScroller, "Center");
        this.goAct = new ConcatAction("Concatenate", null, "Create new concatenated table");
        Box controlBox = Box.createHorizontalBox();
        this.getControlPanel().add(controlBox);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(new JButton(this.goAct));
        controlBox.add(Box.createHorizontalGlue());
        this.addHelp("ConcatWindow");
        this.updateDisplay();
        this.pack();
        this.setVisible(true);
    }

    private TopcatModel getBaseTable() {
        return (TopcatModel)this.t1selector.getSelectedItem();
    }

    private TopcatModel getAddedTable() {
        return (TopcatModel)this.t2selector.getSelectedItem();
    }

    public void updateDisplay() {
        TopcatModel tc1 = this.getBaseTable();
        TopcatModel tc2 = this.getAddedTable();
        JPanel colPanel = new JPanel(new GridLayout(0, 2)){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
            }
        };
        Box colBox = Box.createVerticalBox();
        colBox.add(colPanel);
        colBox.add(Box.createVerticalGlue());
        this.colScroller.setViewportView(colBox);
        if (tc1 != null && tc2 != null) {
            JLabel tl1 = new JLabel("Base Table", 0);
            JLabel tl2 = new JLabel("Appended Table", 0);
            tl1.setBorder(BorderFactory.createBevelBorder(0));
            tl2.setBorder(BorderFactory.createBevelBorder(0));
            colPanel.add(tl1);
            colPanel.add(tl2);
            TableColumnModel colModel1 = tc1.getColumnModel();
            TableColumnModel colModel2 = tc2.getColumnModel();
            int ncol = colModel1.getColumnCount();
            this.colSelectors = new JComboBox[ncol];
            int icol = 0;
            while (icol < ncol) {
                ColumnInfo cinfo = ((StarTableColumn)colModel1.getColumn(icol)).getColumnInfo();
                colPanel.add(new JLabel(cinfo.getName() + ": "));
                RestrictedColumnComboBoxModel comboModel = RestrictedColumnComboBoxModel.makeClassColumnComboBoxModel(colModel2, true, cinfo.getContentClass());
                JComboBox combo = comboModel.makeComboBox();
                ConcatWindow.guessColumn(comboModel, cinfo);
                this.colSelectors[icol] = combo;
                colPanel.add(combo);
                ++icol;
            }
        }
    }

    private StarTable makeTable() {
        StarTable t1 = this.getBaseTable().getApparentStarTable();
        final StarTable t2base = this.getAddedTable().getApparentStarTable();
        int ncol = this.colSelectors.length;
        ColumnStarTable t2 = ColumnStarTable.makeTableWithRows((long)t2base.getRowCount());
        int icol = 0;
        while (icol < ncol) {
            ColumnData cdata;
            TableColumn tcol = (TableColumn)this.colSelectors[icol].getSelectedItem();
            if (tcol instanceof StarTableColumn && tcol != ColumnComboBoxModel.NO_COLUMN) {
                int ic2 = -1;
                ColumnInfo cinfo = ((StarTableColumn)tcol).getColumnInfo();
                int jcol = 0;
                while (jcol < t2base.getColumnCount()) {
                    if (t2base.getColumnInfo(jcol) == cinfo) {
                        ic2 = jcol;
                    }
                    ++jcol;
                }
                final int icol2 = ic2;
                if (!$assertionsDisabled && icol2 < 0) {
                    throw new AssertionError();
                }
                cdata = new ColumnData(cinfo){

                    public Object readValue(long irow) throws IOException {
                        return t2base.getCell(irow, icol2);
                    }
                };
            } else {
                cdata = new ColumnData(t1.getColumnInfo(icol)){

                    public Object readValue(long irow) {
                        return null;
                    }
                };
            }
            t2.addColumn(cdata);
            ++icol;
        }
        return new ConcatStarTable(new StarTable[]{t1, t2});
    }

    public void itemStateChanged(ItemEvent evt) {
        TopcatModel item;
        Object source = evt.getSource();
        if ((source == this.t1selector || source == this.t2selector) && (item = (TopcatModel)evt.getItem()) != null) {
            if (evt.getStateChange() == 2) {
                item.getColumnModel().removeColumnModelListener(this);
            } else if (evt.getStateChange() == 1) {
                item.getColumnModel().addColumnModelListener(this);
            }
        }
        this.updateDisplay();
    }

    public void columnAdded(TableColumnModelEvent evt) {
        this.t2selector.setSelectedItem(null);
        this.updateDisplay();
    }

    public void columnMoved(TableColumnModelEvent evt) {
        this.t2selector.setSelectedItem(null);
        this.updateDisplay();
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        this.t2selector.setSelectedItem(null);
        this.updateDisplay();
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    private static void guessColumn(ComboBoxModel comboModel, ColumnInfo cinfo1) {
        int iSel = 0;
        String name1 = cinfo1.getName();
        String ucd1 = cinfo1.getUCD();
        int i = 1;
        while (i < comboModel.getSize()) {
            boolean match;
            ColumnInfo cinfo2 = ((StarTableColumn)comboModel.getElementAt(i)).getColumnInfo();
            boolean bl = match = name1 != null && name1.equalsIgnoreCase(cinfo2.getName()) || ucd1 != null && ucd1.equals(cinfo2.getUCD());
            if (match) {
                if (iSel == 0) {
                    iSel = i;
                } else {
                    iSel = 0;
                    break;
                }
            }
            ++i;
        }
        comboModel.setSelectedItem(comboModel.getElementAt(iSel));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$ConcatWindow == null ? (class$uk$ac$starlink$topcat$ConcatWindow = ConcatWindow.class$("uk.ac.starlink.topcat.ConcatWindow")) : class$uk$ac$starlink$topcat$ConcatWindow).desiredAssertionStatus();
    }

    private class ConcatAction
    extends BasicAction {
        ConcatAction(String name, Icon icon, String description) {
            super(name, icon, description);
        }

        public void actionPerformed(ActionEvent evt) {
            ConcatWindow parent = ConcatWindow.this;
            if (this == ConcatWindow.this.goAct) {
                boolean ok;
                int msgType;
                String msg;
                String title;
                try {
                    String label = "concat(" + ConcatWindow.this.getBaseTable().getID() + "+" + ConcatWindow.this.getAddedTable().getID() + ")";
                    TopcatModel tcModel = ControlWindow.getInstance().addTable(ConcatWindow.this.makeTable(), label, true);
                    title = "Tables Concatenated";
                    msg = "New concatenated table " + tcModel + " created";
                    msgType = 1;
                    ok = true;
                }
                catch (Exception e) {
                    title = "No Concatenation";
                    msg = e.getMessage();
                    msgType = 2;
                    ok = false;
                }
                JOptionPane.showMessageDialog(parent, msg, title, msgType);
                if (ok) {
                    ConcatWindow.this.dispose();
                }
            } else {
                throw new AssertionError();
            }
        }
    }
}

