/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.ColumnSelector;
import uk.ac.starlink.topcat.IntSelector;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.func.Sdss;
import uk.ac.starlink.topcat.func.SuperCosmos;
import uk.ac.starlink.topcat.func.TwoMass;

public class CutoutSelector
extends JPanel
implements ItemListener {
    private final TopcatModel tcModel_;
    private final JComboBox serviceSelector_;
    private final ColumnSelector raSelector_;
    private final ColumnSelector decSelector_;
    private final IntSelector npixSelector_;
    private final JLabel pixsizeLabel_;
    private final Component[] enablables_;
    private static final CutoutService[] SERVICES = new CutoutService[]{new CutoutService("SuperCOSMOS All-Sky Blue", 0.67){

        String displayCutout(int tableID, double ra, double dec, int npix) {
            return SuperCosmos.sssCutoutBlue(ra, dec, npix);
        }
    }, new CutoutService("SuperCOSMOS All-Sky Red", 0.67){

        String displayCutout(int tableID, double ra, double dec, int npix) {
            return SuperCosmos.sssCutoutRed(ra, dec, npix);
        }
    }, new TwoMassCutoutService('J'), new TwoMassCutoutService('H'), new TwoMassCutoutService('K'), new CutoutService("SDSS Colour Images", 0.4){

        String displayCutout(int tableID, double ra, double dec, int npix) {
            return Sdss.sdssCutout("SDSS (" + tableID + ")", ra, dec, npix);
        }
    }};

    public CutoutSelector(TopcatModel tcModel) {
        super(new BorderLayout());
        this.tcModel_ = tcModel;
        JLabel serviceLabel = new JLabel("Cutout Service: ");
        this.serviceSelector_ = new JComboBox<CutoutService>(SERVICES);
        this.serviceSelector_.addItemListener(this);
        this.raSelector_ = new ColumnSelector(this.tcModel_.getColumnSelectorModel((ValueInfo)Tables.RA_INFO));
        this.decSelector_ = new ColumnSelector(this.tcModel_.getColumnSelectorModel((ValueInfo)Tables.DEC_INFO));
        int[] sizes = new int[]{25, 50, 75, 100, 150, 200, 300, 400, 500};
        JLabel npixLabel = new JLabel("Width/Height in Pixels: ");
        this.npixSelector_ = new IntSelector(sizes);
        this.npixSelector_.setValue(100);
        this.pixsizeLabel_ = new JLabel("");
        this.enablables_ = new Component[]{serviceLabel, this.serviceSelector_, this.raSelector_, this.decSelector_, npixLabel, this.npixSelector_, this.pixsizeLabel_};
        Box box = Box.createVerticalBox();
        this.add(box);
        Box cutoutLine = Box.createHorizontalBox();
        cutoutLine.add(serviceLabel);
        cutoutLine.add(this.serviceSelector_);
        box.add(cutoutLine);
        box.add(Box.createVerticalStrut(5));
        Box raLine = Box.createHorizontalBox();
        raLine.add(this.raSelector_);
        box.add(raLine);
        box.add(Box.createVerticalStrut(5));
        Box decLine = box.createHorizontalBox();
        decLine.add(this.decSelector_);
        box.add(decLine);
        box.add(Box.createVerticalStrut(5));
        Box npixLine = Box.createHorizontalBox();
        npixLine.add(npixLabel);
        npixLine.add(this.npixSelector_);
        npixLine.add(this.pixsizeLabel_);
        box.add(npixLine);
        CutoutService serv = (CutoutService)this.serviceSelector_.getSelectedItem();
        this.serviceSelector_.setSelectedItem(null);
        this.serviceSelector_.setSelectedItem(serv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Activator makeActivator() {
        String trouble;
        CutoutService serv = (CutoutService)this.serviceSelector_.getSelectedItem();
        if (serv != null) {
            ColumnData raData = this.raSelector_.getColumnData();
            ColumnData decData = this.decSelector_.getColumnData();
            int npix = this.npixSelector_.getValue();
            int tableID = this.tcModel_.getID();
            if (raData == null) {
                trouble = "No RA column defined";
            } else if (decData == null) {
                trouble = "No Declination column defined";
            } else {
                if (npix > 0) return serv.makeActivator(tableID, raData, decData, npix);
                trouble = "Non-positive number of pixels";
            }
        } else {
            trouble = "No Cutout Service selected";
        }
        JOptionPane.showMessageDialog(this, trouble, "Underspecified Action Error", 0);
        return null;
    }

    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < this.enablables_.length) {
            this.enablables_[i].setEnabled(enabled);
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.serviceSelector_) {
            CutoutService serv = (CutoutService)this.serviceSelector_.getSelectedItem();
            if (serv != null) {
                this.pixsizeLabel_.setText(" (" + serv.getPixelSize() + " arcsec)");
            } else {
                this.pixsizeLabel_.setText("     ");
            }
        }
    }

    private static class TwoMassCutoutService
    extends CutoutService {
        private final char band_;

        TwoMassCutoutService(char band) {
            super("2MASS Quick-Look " + band + "-band", 2.25);
            this.band_ = band;
        }

        String displayCutout(int tableID, double ra, double dec, int npix) {
            return TwoMass.image2Mass("2MASS " + Character.toUpperCase(this.band_) + " (" + tableID + ")", ra, dec, npix, Character.toLowerCase(this.band_));
        }
    }

    private static abstract class CutoutService {
        final String name_;
        final float pixelSize_;

        protected CutoutService(String name, double pixelSize) {
            this.name_ = name;
            this.pixelSize_ = (float)pixelSize;
        }

        public float getPixelSize() {
            return this.pixelSize_;
        }

        abstract String displayCutout(int var1, double var2, double var4, int var6);

        public Activator makeActivator(int tableID, ColumnData raData, ColumnData decData, int npix) {
            String activatorName = this.name_ + "($ra, $dec, " + npix + ")";
            return new Activator(this, raData, decData, tableID, npix, activatorName){
                private final /* synthetic */ ColumnData val$raData;
                private final /* synthetic */ ColumnData val$decData;
                private final /* synthetic */ int val$tableID;
                private final /* synthetic */ int val$npix;
                private final /* synthetic */ String val$activatorName;
                private final /* synthetic */ CutoutService this$0;
                {
                    this.this$0 = this$0;
                    this.val$raData = val$raData;
                    this.val$decData = val$decData;
                    this.val$tableID = val$tableID;
                    this.val$npix = val$npix;
                    this.val$activatorName = val$activatorName;
                }

                public String activateRow(long lrow) {
                    Object decObj;
                    Object raObj;
                    try {
                        raObj = this.val$raData.readValue(lrow);
                        decObj = this.val$decData.readValue(lrow);
                    }
                    catch (IOException e) {
                        return "Error reading position " + e;
                    }
                    if (raObj instanceof Number && decObj instanceof Number) {
                        double ra = ((Number)raObj).doubleValue();
                        double dec = ((Number)decObj).doubleValue();
                        if (!Double.isNaN(ra) && !Double.isNaN(dec)) {
                            return this.this$0.displayCutout(this.val$tableID, ra, dec, this.val$npix);
                        }
                    }
                    return "No position at (" + raObj + ", " + decObj + ")";
                }

                public String toString() {
                    return this.val$activatorName;
                }
            };
        }

        public String toString() {
            return this.name_;
        }
    }
}

