/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.topcat.AuxWindow;

public abstract class QueryWindow
extends AuxWindow {
    private JPanel auxControls;
    private LabelledComponentStack stack;
    private Action okAction;
    private Action cancelAction;
    private boolean configured = false;
    protected Border blankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);

    public QueryWindow(String title, Component parent) {
        this(title, parent, true, true);
    }

    public QueryWindow(String title, Component parent, boolean ok, boolean cancel) {
        super(title, parent);
        this.stack = new LabelledComponentStack();
        this.cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                QueryWindow.this.dispose();
            }
        };
        this.okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                if (QueryWindow.this.perform()) {
                    QueryWindow.this.dispose();
                }
            }
        };
        JPanel queryControls = this.getControlPanel();
        if (ok) {
            queryControls.add(new JButton(this.okAction));
        }
        if (cancel) {
            queryControls.add(new JButton(this.cancelAction));
        }
        this.auxControls = new JPanel();
        JPanel hstrut = new JPanel();
        hstrut.setPreferredSize(new Dimension(400, 0));
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.questionIcon")));
        iconBox.setBorder(this.blankBorder);
        this.stack.setBorder(this.blankBorder);
        this.auxControls.setBorder(this.blankBorder);
        this.getMainArea().add((Component)iconBox, "West");
        this.getMainArea().add((Component)this.stack, "Center");
        this.getMainArea().add((Component)this.auxControls, "South");
        this.getMainArea().add((Component)hstrut, "North");
    }

    protected abstract boolean perform();

    protected LabelledComponentStack getStack() {
        return this.stack;
    }

    public JPanel getAuxControlPanel() {
        return this.auxControls;
    }

    public void invokeOK() {
        this.okAction.actionPerformed(null);
    }

    public void invokeCancel() {
        this.cancelAction.actionPerformed(null);
    }

    private void initFocus() {
        Component ff = this.getFirstFocusableField();
        if (ff != null) {
            ff.requestFocusInWindow();
        }
    }

    private Component getFirstFocusableField() {
        Component[] fields = this.stack.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isFocusable()) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private void configureKeys() {
        Object okKey = new Object();
        KeyStroke hitEnter = KeyStroke.getKeyStroke(10, 0);
        Component[] fields = this.stack.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] instanceof JComponent) {
                JComponent field = (JComponent)fields[i];
                field.getInputMap().put(hitEnter, okKey);
                field.getActionMap().put(okKey, this.okAction);
            }
            ++i;
        }
    }

    public void setVisible(boolean isVis) {
        super.setVisible(isVis);
        if (isVis && !this.configured) {
            this.configureKeys();
            this.initFocus();
        }
    }
}

