/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class SizingScrollPane
extends JScrollPane {
    private int minWidth = 100;
    private int maxWidth = 700;
    private int defWidth = 500;
    private int minHeight = 100;
    private int maxHeight = 600;
    private int defHeight = 400;
    private int sbw;
    private int sbh;
    private int headh;

    public SizingScrollPane() {
        this(null);
    }

    public SizingScrollPane(Component view) {
        super(view);
        this.sbw = this.getVerticalScrollBar().getPreferredSize().width;
        this.sbh = this.getHorizontalScrollBar().getPreferredSize().height;
    }

    public Dimension getPreferredSize() {
        if (this.getViewport() != null && this.getViewport().getView() != null) {
            JViewport cHead;
            Dimension vdim = this.getViewport().getView().getPreferredSize();
            int vw = vdim.width + 4;
            int vh = vdim.height + 4;
            JViewport rHead = this.getRowHeader();
            if (rHead != null) {
                vw += ((Component)rHead).getPreferredSize().width;
            }
            if ((cHead = this.getColumnHeader()) != null) {
                vh += ((Component)cHead).getPreferredSize().height;
            }
            int w = Math.max(Math.min(vw, this.maxWidth), this.minWidth);
            int h = Math.max(Math.min(vh, this.maxHeight), this.minHeight);
            return new Dimension(w, h);
        }
        return new Dimension(this.defWidth, this.defHeight);
    }
}

