/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.ColumnCellRenderer;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.ttools.convert.SkySystem;
import uk.ac.starlink.ttools.convert.SkyUnits;

public class SkyColumnQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel_;
    private final InCoordSelector inSelector_;
    private final OutCoordSelector outSelector_;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$SkyColumnQueryWindow;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public SkyColumnQueryWindow(TopcatModel tcModel, Component parent) {
        super("Sky Coordinate Columns", parent);
        this.tcModel_ = tcModel;
        this.inSelector_ = new InCoordSelector();
        this.outSelector_ = new OutCoordSelector();
        this.inSelector_.getComponent().setBorder(AuxWindow.makeTitledBorder("Input Coordinates"));
        this.outSelector_.getComponent().setBorder(AuxWindow.makeTitledBorder("Output Coordinates"));
        JPanel main = this.getMainArea();
        Box box = Box.createHorizontalBox();
        this.getMainArea().add(box);
        box.add(this.inSelector_.getComponent());
        box.add(Box.createHorizontalStrut(10));
        box.add(new JLabel(ResourceIcon.FORWARD));
        box.add(Box.createHorizontalStrut(10));
        box.add(this.outSelector_.getComponent());
        this.addHelp("SkyColumnQueryWindow");
        this.pack();
        this.setVisible(true);
    }

    private int getAppendPosition() {
        return -1;
    }

    private double getEpoch() {
        return 2000.0;
    }

    protected boolean perform() {
        int ip2;
        int ip1;
        StarTableColumn[] inCols = this.inSelector_.getCoordColumns();
        String[] outNames = this.outSelector_.getCoordNames();
        SkySystem inSys = this.inSelector_.getSystem();
        SkyUnits inUnits = this.inSelector_.getUnits();
        SkySystem outSys = this.outSelector_.getSystem();
        SkyUnits outUnits = this.outSelector_.getUnits();
        double epoch = this.getEpoch();
        String msg = inCols[0] == null || inCols[1] == null ? "Input coordinates not specified" : (outNames[0] == null || outNames[1] == null || outNames[0].trim().length() == 0 || outNames[1].trim().length() == 0 ? "Output coordinates not specified" : null);
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, "Coordinate Conversion Error", 0);
            return false;
        }
        PlasticStarTable dataModel = this.tcModel_.getDataModel();
        int icol1 = inCols[0].getModelIndex();
        int icol2 = inCols[1].getModelIndex();
        final CoordConverter conv = new CoordConverter(inSys, inUnits, outSys, outUnits, epoch, (StarTable)dataModel, icol1, icol2){
            private final /* synthetic */ StarTable val$dataModel;
            private final /* synthetic */ int val$icol1;
            private final /* synthetic */ int val$icol2;
            {
                this.val$dataModel = val$dataModel;
                this.val$icol1 = val$icol1;
                this.val$icol2 = val$icol2;
                super(x0, x1, x2, x3, x4);
            }

            public Object[] getInCoords(long irow) throws IOException {
                return new Object[]{this.val$dataModel.getCell(irow, this.val$icol1), this.val$dataModel.getCell(irow, this.val$icol2)};
            }
        };
        ColumnData[] outData = new ColumnData[2];
        int i = 0;
        while (i < 2) {
            DefaultValueInfo info = new DefaultValueInfo(outNames[i]);
            info.setContentClass(outUnits.getUnitTypes()[i]);
            info.setDescription(outSys.getCoordinateDescriptions()[i]);
            info.setUnitString(outUnits.getUnitStrings()[i]);
            final int i0 = i;
            outData[i] = new ColumnData((ValueInfo)info){

                public Object readValue(long irow) {
                    return conv.getOutCoords(irow)[i0];
                }
            };
            ++i;
        }
        int ipos = this.getAppendPosition();
        if (ipos < 0) {
            ip1 = -1;
            ip2 = -1;
        } else {
            ip1 = ipos;
            ip2 = ipos + 1;
        }
        this.tcModel_.appendColumn(outData[0], ip1);
        this.tcModel_.appendColumn(outData[1], ip2);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class CoordConverter {
        private final SkySystem inSys_;
        private final SkySystem outSys_;
        private final SkyUnits inUnits_;
        private final SkyUnits outUnits_;
        private final double epoch_;
        private long irow_ = -1L;
        private Object[] outCoords_;

        CoordConverter(SkySystem inSys, SkyUnits inUnits, SkySystem outSys, SkyUnits outUnits, double epoch) {
            this.inSys_ = inSys;
            this.inUnits_ = inUnits;
            this.outSys_ = outSys;
            this.outUnits_ = outUnits;
            this.epoch_ = epoch;
        }

        abstract Object[] getInCoords(long var1) throws IOException;

        synchronized Object[] getOutCoords(long irow) {
            if (irow != this.irow_) {
                Object[] in;
                try {
                    in = this.getInCoords(irow);
                }
                catch (IOException e) {
                    in = new Object[2];
                }
                if (Tables.isBlank((Object)in[0]) || Tables.isBlank((Object)in[1])) {
                    this.outCoords_ = new Object[2];
                } else {
                    double[] inRads = this.inUnits_.decode(in[0], in[1]);
                    double[] fk5 = this.inSys_.toFK5(inRads[0], inRads[1], this.epoch_);
                    double[] outRads = this.outSys_.fromFK5(fk5[0], fk5[1], this.epoch_);
                    this.outCoords_ = this.outUnits_.encode(outRads[0], outRads[1]);
                }
                this.irow_ = irow;
            }
            return this.outCoords_;
        }
    }

    private class OutCoordSelector
    extends CoordSelector {
        private final JTextField[] coordEntries_;

        OutCoordSelector() {
            this.coordEntries_ = new JTextField[]{new JTextField(), new JTextField()};
        }

        JComponent[] getCoordChoosers() {
            return this.coordEntries_;
        }

        String[] getCoordNames() {
            return new String[]{this.coordEntries_[0].getText(), this.coordEntries_[1].getText()};
        }
    }

    private class InCoordSelector
    extends CoordSelector {
        private JComboBox[] coordChoosers_;

        private InCoordSelector() {
        }

        private JComboBox[] createCoordChoosers() {
            JComboBox[] coordChoosers = new JComboBox[2];
            int i = 0;
            while (i < 2) {
                JComboBox box = new JComboBox();
                box.setRenderer(new ColumnCellRenderer(box));
                coordChoosers[i] = box;
                ++i;
            }
            this.unitChooser_.addItemListener(new ItemListener(this, coordChoosers){
                private ComboBoxModel dummyModel;
                private final /* synthetic */ JComboBox[] val$coordChoosers;
                private final /* synthetic */ InCoordSelector this$1;
                {
                    this.this$1 = this$1;
                    this.val$coordChoosers = val$coordChoosers;
                    this.dummyModel = new DefaultComboBoxModel<E>();
                }

                public void itemStateChanged(ItemEvent evt) {
                    int state = evt.getStateChange();
                    if (state == 1) {
                        ComboBoxModel[] models = InCoordSelector.access$200(this.this$1);
                        int i = 0;
                        while (i < 2) {
                            this.val$coordChoosers[i].setModel(models[i]);
                            ++i;
                        }
                    }
                }
            });
            SkyUnits dunit = (SkyUnits)this.unitChooser_.getSelectedItem();
            this.unitChooser_.setSelectedItem(null);
            this.unitChooser_.setSelectedItem(dunit);
            return coordChoosers;
        }

        private ComboBoxModel[] getColumnModels() {
            SkyUnits units = (SkyUnits)this.unitChooser_.getSelectedItem();
            Class clazz = units == SkyUnits.SEXAGESIMAL ? (class$java$lang$String == null ? (class$java$lang$String = SkyColumnQueryWindow.class$("java.lang.String")) : class$java$lang$String) : (class$java$lang$Number == null ? (class$java$lang$Number = SkyColumnQueryWindow.class$("java.lang.Number")) : class$java$lang$Number);
            Class okClass = clazz;
            ComboBoxModel[] models = new ComboBoxModel[2];
            int i = 0;
            while (i < 2) {
                models[i] = RestrictedColumnComboBoxModel.makeClassColumnComboBoxModel(SkyColumnQueryWindow.this.tcModel_.getColumnModel(), false, okClass);
                ++i;
            }
            return models;
        }

        JComponent[] getCoordChoosers() {
            if (this.coordChoosers_ == null) {
                this.coordChoosers_ = this.createCoordChoosers();
            }
            return this.coordChoosers_;
        }

        StarTableColumn[] getCoordColumns() {
            return new StarTableColumn[]{(StarTableColumn)this.coordChoosers_[0].getSelectedItem(), (StarTableColumn)this.coordChoosers_[1].getSelectedItem()};
        }

        static /* synthetic */ ComboBoxModel[] access$200(InCoordSelector x0) {
            return x0.getColumnModels();
        }
    }

    private abstract class CoordSelector {
        LabelledComponentStack stack_;
        JComboBox sysChooser_;
        JComboBox unitChooser_;
        static final /* synthetic */ boolean $assertionsDisabled;

        private CoordSelector() {
        }

        JComponent getComponent() {
            if (this.stack_ == null) {
                this.stack_ = this.createQueryStack();
            }
            return this.stack_;
        }

        abstract JComponent[] getCoordChoosers();

        SkySystem getSystem() {
            return (SkySystem)this.sysChooser_.getSelectedItem();
        }

        SkyUnits getUnits() {
            return (SkyUnits)this.unitChooser_.getSelectedItem();
        }

        private LabelledComponentStack createQueryStack() {
            LabelledComponentStack stack = new LabelledComponentStack();
            this.sysChooser_ = new JComboBox<SkySystem>(SkySystem.getKnownSystems());
            this.unitChooser_ = new JComboBox<SkyUnits>(SkyUnits.getKnownUnits());
            JComponent[] coordChoosers = this.getCoordChoosers();
            stack.addLine("System", (Component)this.sysChooser_);
            stack.addLine("Units", (Component)this.unitChooser_);
            stack.addLine("Coord 1", (Component)coordChoosers[0]);
            stack.addLine("Coord 2", (Component)coordChoosers[1]);
            JLabel[] labels = stack.getLabels();
            JLabel c1label = labels[2];
            JLabel c2label = labels[3];
            if (!$assertionsDisabled && !c1label.getText().startsWith("Coord 1")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !c2label.getText().startsWith("Coord 2")) {
                throw new AssertionError();
            }
            this.sysChooser_.addItemListener(new ItemListener(this, c1label, c2label){
                private final /* synthetic */ JLabel val$c1label;
                private final /* synthetic */ JLabel val$c2label;
                private final /* synthetic */ CoordSelector this$1;
                {
                    this.this$1 = this$1;
                    this.val$c1label = val$c1label;
                    this.val$c2label = val$c2label;
                }

                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        SkySystem sys = (SkySystem)evt.getItem();
                        String[] cnames = sys.getCoordinateNames();
                        this.val$c1label.setText(cnames[0] + ":  ");
                        this.val$c2label.setText(cnames[1] + ":  ");
                    }
                }
            });
            SkySystem dsys = (SkySystem)this.sysChooser_.getSelectedItem();
            this.sysChooser_.setSelectedItem(null);
            this.sysChooser_.setSelectedItem(dsys);
            return stack;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$SkyColumnQueryWindow == null ? (class$uk$ac$starlink$topcat$SkyColumnQueryWindow = SkyColumnQueryWindow.class$("uk.ac.starlink.topcat.SkyColumnQueryWindow")) : class$uk$ac$starlink$topcat$SkyColumnQueryWindow).desiredAssertionStatus();
        }
    }
}

