/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.NumericCellRenderer;
import uk.ac.starlink.table.gui.ProgressBarStarTable;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.TableColumnModelAdapter;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.TopcatViewWindow;

public class StatsWindow
extends TopcatViewWindow {
    private TopcatModel tcModel;
    private StarTable dataModel;
    private TableColumnModel columnModel;
    private OptionsListModel subsets;
    private RowSubset rset = RowSubset.ALL;
    private StatsCalculator activeCalculator;
    private StatsCalculator lastCalc;
    private Map calcMap;
    private JTable jtab;
    private JProgressBar progBar;
    private JComboBox subSelector;
    private AbstractTableModel statsTableModel;
    private BitSet hideColumns = new BitSet();
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$StatsWindow;

    public StatsWindow(TopcatModel tcModel, Component parent) {
        super(tcModel, "Row statistics", parent);
        this.tcModel = tcModel;
        this.dataModel = tcModel.getDataModel();
        this.columnModel = tcModel.getColumnModel();
        this.subsets = tcModel.getSubsets();
        this.calcMap = new HashMap();
        this.statsTableModel = this.makeStatsTableModel();
        this.jtab = new JTable(this.statsTableModel);
        StatsWindow.configureJTable(this.jtab);
        this.getMainArea().add(new SizingScrollPane(this.jtab));
        MetaColumnModel statsColumnModel = new MetaColumnModel(this.jtab.getColumnModel(), this.statsTableModel);
        this.jtab.setColumnModel(statsColumnModel);
        int nstat = statsColumnModel.getColumnCount();
        int i = 0;
        while (i < nstat) {
            if (this.hideColumns.get(i)) {
                statsColumnModel.removeColumn(i);
            }
            ++i;
        }
        JPanel controlPanel = this.getControlPanel();
        this.subSelector = this.subsets.makeComboBox();
        this.subSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    StatsWindow.this.setSubset((RowSubset)evt.getItem());
                }
            }
        });
        controlPanel.add(new JLabel("Subset for calculations: "));
        controlPanel.add(this.subSelector);
        BasicAction recalcAct = new BasicAction("Recalculate", ResourceIcon.REDO, "Recalculate the statistics for the current subset"){

            public void actionPerformed(ActionEvent evt) {
                RowSubset rset = (RowSubset)StatsWindow.this.subSelector.getSelectedItem();
                StatsWindow.this.calcMap.remove(rset);
                StatsWindow.this.setSubset(rset);
            }
        };
        this.getToolBar().add(recalcAct);
        this.getToolBar().addSeparator();
        JMenu statsMenu = new JMenu("Statistics");
        statsMenu.setMnemonic(83);
        statsMenu.add(new JMenuItem(recalcAct));
        this.getJMenuBar().add(statsMenu);
        JMenu displayMenu = statsColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        this.progBar = this.placeProgressBar();
        this.addHelp("StatsWindow");
        this.subSelector.setSelectedItem(tcModel.getSelectedSubset());
        this.pack();
        this.setVisible(true);
    }

    public void setSubset(RowSubset rset) {
        this.rset = rset;
        if (this.activeCalculator != null) {
            this.activeCalculator.interrupt();
        }
        if (rset != this.subSelector.getSelectedItem()) {
            this.subSelector.setSelectedItem(rset);
            return;
        }
        if (this.calcMap.containsKey(rset)) {
            this.displayCalculations((StatsCalculator)this.calcMap.get(rset));
        } else {
            this.activeCalculator = new StatsCalculator(rset);
            this.activeCalculator.start();
        }
    }

    private void displayCalculations(StatsCalculator stats) {
        boolean firstTime = this.lastCalc == null;
        this.lastCalc = stats;
        this.statsTableModel.fireTableDataChanged();
        if (firstTime) {
            StarJTable.configureColumnWidths((JTable)this.jtab, (int)200, (int)Integer.MAX_VALUE);
        }
        RowSubset rset = stats.rset;
        long nrow = stats.ngoodrow;
        int irset = this.subsets.indexOf(rset);
        if (irset >= 0) {
            this.tcModel.getSubsetCounts().put(rset, new Long(nrow));
            this.subsets.fireContentsChanged(irset, irset);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.activeCalculator != null) {
            this.activeCalculator.interrupt();
            this.activeCalculator = null;
            this.setBusy(false);
        }
    }

    private static void configureJTable(JTable jtab) {
        jtab.setAutoResizeMode(0);
        jtab.setColumnSelectionAllowed(false);
        jtab.setRowSelectionAllowed(false);
        TableColumnModel tcm = jtab.getColumnModel();
        TableModel tmodel = jtab.getModel();
        StarJTable.configureColumnWidth((JTable)jtab, (int)200, (int)Integer.MAX_VALUE, (int)0);
        int icol = 0;
        while (icol < tcm.getColumnCount()) {
            Class clazz = tmodel.getColumnClass(icol);
            if (clazz.equals(class$java$lang$Long == null ? StatsWindow.class$("java.lang.Long") : class$java$lang$Long)) {
                clazz = class$java$lang$Integer == null ? StatsWindow.class$("java.lang.Integer") : class$java$lang$Integer;
            }
            if (clazz.equals(class$java$lang$Object == null ? StatsWindow.class$("java.lang.Object") : class$java$lang$Object)) {
                clazz = class$java$lang$Double == null ? StatsWindow.class$("java.lang.Double") : class$java$lang$Double;
            }
            NumericCellRenderer rend = new NumericCellRenderer(clazz);
            TableColumn tcol = tcm.getColumn(icol);
            tcol.setCellRenderer((TableCellRenderer)rend);
            tcol.setPreferredWidth(rend.getCellWidth());
            ++icol;
        }
    }

    private int getModelIndexFromRow(int irow) {
        return this.columnModel.getColumn(irow).getModelIndex();
    }

    public int getCardinalityLimit(long nvalue) {
        return Math.min(50, (int)Math.min((double)nvalue * 0.75, 2.147483647E9));
    }

    private AbstractTableModel makeStatsTableModel() {
        ArrayList<MetaColumn> metas = new ArrayList<MetaColumn>();
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Index", class$java$lang$Integer == null ? (class$java$lang$Integer = StatsWindow.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object getValue(int irow) {
                return new Integer(irow + 1);
            }
        });
        this.hideColumns.set(metas.size());
        final ValueInfo idInfo = TopcatUtils.COLID_INFO;
        metas.add(new MetaColumn(idInfo.getName(), class$java$lang$String == null ? (class$java$lang$String = StatsWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ((StarTableColumn)StatsWindow.this.columnModel.getColumn(irow)).getColumnInfo().getAuxDatum(idInfo).getValue();
            }
        });
        metas.add(new MetaColumn("Name", class$java$lang$String == null ? (class$java$lang$String = StatsWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                return StatsWindow.this.dataModel.getColumnInfo(jcol).getName();
            }
        });
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Sum", class$java$lang$Double == null ? (class$java$lang$Double = StatsWindow.class$("java.lang.Double")) : class$java$lang$Double){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                if (((StatsWindow)StatsWindow.this).lastCalc.isNumber[jcol]) {
                    return new Double(((StatsWindow)StatsWindow.this).lastCalc.sums[jcol]);
                }
                if (((StatsWindow)StatsWindow.this).lastCalc.isBoolean[jcol]) {
                    return new Long(((StatsWindow)StatsWindow.this).lastCalc.ntrues[jcol]);
                }
                return null;
            }
        });
        metas.add(new MetaColumn("Mean", class$java$lang$Float == null ? (class$java$lang$Float = StatsWindow.class$("java.lang.Float")) : class$java$lang$Float){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.isNumber[jcol] || ((StatsWindow)StatsWindow.this).lastCalc.isBoolean[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc.means[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("S.D.", class$java$lang$Float == null ? (class$java$lang$Float = StatsWindow.class$("java.lang.Float")) : class$java$lang$Float){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc.sdevs[jcol]) : null;
            }
        });
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Variance", class$java$lang$Float == null ? (class$java$lang$Float = StatsWindow.class$("java.lang.Float")) : class$java$lang$Float){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc.vars[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("Minimum", class$java$lang$Object == null ? (class$java$lang$Object = StatsWindow.class$("java.lang.Object")) : class$java$lang$Object){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.mins[jcol];
            }
        });
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Row of min.", class$java$lang$Long == null ? (class$java$lang$Long = StatsWindow.class$("java.lang.Long")) : class$java$lang$Long){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.mins[jcol] != null ? new Long(((StatsWindow)StatsWindow.this).lastCalc.imins[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("Maximum", class$java$lang$Object == null ? (class$java$lang$Object = StatsWindow.class$("java.lang.Object")) : class$java$lang$Object){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.maxs[jcol];
            }
        });
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Row of max.", class$java$lang$Long == null ? (class$java$lang$Long = StatsWindow.class$("java.lang.Long")) : class$java$lang$Long){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc.maxs[jcol] != null ? new Long(((StatsWindow)StatsWindow.this).lastCalc.imaxs[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("Good cells", class$java$lang$Long == null ? (class$java$lang$Long = StatsWindow.class$("java.lang.Long")) : class$java$lang$Long){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return new Long(((StatsWindow)StatsWindow.this).lastCalc.ngoods[jcol]);
            }
        });
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Bad cells", class$java$lang$Long == null ? (class$java$lang$Long = StatsWindow.class$("java.lang.Long")) : class$java$lang$Long){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                return new Long(((StatsWindow)StatsWindow.this).lastCalc.nbads[jcol]);
            }
        });
        this.hideColumns.set(metas.size());
        metas.add(new MetaColumn("Cardinality", class$java$lang$Integer == null ? (class$java$lang$Integer = StatsWindow.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc.ncol) {
                    return null;
                }
                int card = ((StatsWindow)StatsWindow.this).lastCalc.cards[jcol];
                return ((StatsWindow)StatsWindow.this).lastCalc.isCardinal[jcol] && card > 0 ? new Integer(card) : null;
            }
        });
        final MetaColumnTableModel tmodel = new MetaColumnTableModel(metas){

            public int getRowCount() {
                return StatsWindow.this.columnModel.getColumnCount();
            }
        };
        this.columnModel.addColumnModelListener(new TableColumnModelAdapter(){

            public void columnAdded(TableColumnModelEvent evt) {
                tmodel.fireTableDataChanged();
            }

            public void columnRemoved(TableColumnModelEvent evt) {
                tmodel.fireTableDataChanged();
            }

            public void columnMoved(TableColumnModelEvent evt) {
                tmodel.fireTableDataChanged();
            }
        });
        return tmodel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ StatsCalculator access$800(StatsWindow x0) {
        return x0.activeCalculator;
    }

    static /* synthetic */ void access$900(StatsWindow x0, StatsCalculator x1) {
        x0.displayCalculations(x1);
    }

    static /* synthetic */ StatsCalculator access$802(StatsWindow x0, StatsCalculator x1) {
        x0.activeCalculator = x1;
        return x0.activeCalculator;
    }

    static /* synthetic */ JProgressBar access$1000(StatsWindow x0) {
        return x0.progBar;
    }

    private class StatsCalculator
    extends Thread {
        private final RowSubset rset;
        int ncol;
        long ngoodrow;
        boolean[] isNumber;
        boolean[] isComparable;
        boolean[] isBoolean;
        boolean[] isCardinal;
        Object[] mins;
        Object[] maxs;
        long[] imins;
        long[] imaxs;
        long[] ngoods;
        long[] nbads;
        long[] ntrues;
        double[] means;
        double[] sdevs;
        double[] vars;
        double[] sums;
        double[] sum2s;
        int[] cards;
        static final /* synthetic */ boolean $assertionsDisabled;

        public StatsCalculator(RowSubset rset) {
            super("StatsCalculator");
            this.rset = rset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ StatsCalculator this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (this.this$1 == StatsWindow.access$800(StatsCalculator.access$700(this.this$1))) {
                        StatsCalculator.access$700(this.this$1).setBusy(true);
                    }
                }
            });
            try {
                try {
                    this.calculate();
                    StatsWindow.this.calcMap.put(this.rset, this);
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ StatsCalculator this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            StatsWindow.access$900(StatsCalculator.access$700(this.this$1), this.this$1);
                        }
                    });
                }
                catch (IOException e) {
                    Object var3_2 = null;
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ StatsCalculator this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (this.this$1 == StatsWindow.access$800(StatsCalculator.access$700(this.this$1))) {
                                StatsWindow.access$802(StatsCalculator.access$700(this.this$1), null);
                                StatsCalculator.access$700(this.this$1).setBusy(false);
                            }
                        }
                    });
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        /*
         * Unable to fully structure code
         */
        private void calculate() throws IOException {
            this.ncol = StatsWindow.access$500(StatsWindow.this).getColumnCount();
            this.isNumber = new boolean[this.ncol];
            this.isComparable = new boolean[this.ncol];
            this.isBoolean = new boolean[this.ncol];
            this.isCardinal = new boolean[this.ncol];
            this.mins = new Object[this.ncol];
            this.maxs = new Object[this.ncol];
            this.imins = new long[this.ncol];
            this.imaxs = new long[this.ncol];
            this.ngoods = new long[this.ncol];
            this.nbads = new long[this.ncol];
            this.ntrues = new long[this.ncol];
            this.means = new double[this.ncol];
            this.sdevs = new double[this.ncol];
            this.vars = new double[this.ncol];
            this.sums = new double[this.ncol];
            this.sum2s = new double[this.ncol];
            this.cards = new int[this.ncol];
            badcompars = new boolean[this.ncol];
            dmins = new double[this.ncol];
            dmaxs = new double[this.ncol];
            valuesets = new Set[this.ncol];
            Arrays.fill(dmins, 1.7976931348623157E308);
            Arrays.fill(dmaxs, -1.7976931348623157E308);
            icol = 0;
            while (icol < this.ncol) {
                clazz = StatsWindow.access$500(StatsWindow.this).getColumnInfo(icol).getContentClass();
                this.isNumber[icol] = (StatsWindow.class$java$lang$Number == null ? StatsWindow.class$("java.lang.Number") : StatsWindow.class$java$lang$Number).isAssignableFrom(clazz);
                this.isComparable[icol] = (StatsWindow.class$java$lang$Comparable == null ? StatsWindow.class$("java.lang.Comparable") : StatsWindow.class$java$lang$Comparable).isAssignableFrom(clazz);
                this.isBoolean[icol] = clazz.equals(StatsWindow.class$java$lang$Boolean == null ? StatsWindow.class$("java.lang.Boolean") : StatsWindow.class$java$lang$Boolean);
                v0 = this.isCardinal[icol] = clazz.equals(StatsWindow.class$java$lang$Boolean == null ? StatsWindow.class$("java.lang.Boolean") : StatsWindow.class$java$lang$Boolean) == false;
                if (this.isCardinal[icol]) {
                    valuesets[icol] = new HashSet<E>();
                }
                ++icol;
            }
            rseq = new ProgressBarStarTable(StatsWindow.access$500(StatsWindow.this), StatsWindow.access$1000(StatsWindow.this)).getRowSequence();
            cardlimit = StatsWindow.this.getCardinalityLimit(StatsWindow.access$500(StatsWindow.this).getRowCount());
            interruption = null;
            lrow = 0L;
            this.ngoodrow = 0L;
            block5: while (true) {
                block48: {
                    lrow1 = ++lrow;
                    try {
                        if (!rseq.next()) {
                        }
                        break block48;
                    }
                    catch (IOException e) {
                        interruption = e;
                    }
                    break;
                }
                if (!this.rset.isIncluded(lrow)) continue;
                ++this.ngoodrow;
                row = rseq.getRow();
                icol = 0;
                while (true) {
                    if (icol < this.ncol) ** break;
                    continue block5;
                    val = row[icol];
                    if (val == null) {
                        good = false;
                    } else {
                        if (this.isNumber[icol]) {
                            dval = NaN;
                            if (!(val instanceof Number)) {
                                System.err.println("Error in table data: not numeric at " + lrow1 + "," + icol + "(" + val + ")");
                                good = false;
                            } else {
                                dval = ((Number)val).doubleValue();
                            }
                            good = Double.isNaN(dval) == false;
                            if (good) {
                                if (dval < dmins[icol]) {
                                    dmins[icol] = dval;
                                    this.mins[icol] = val;
                                    this.imins[icol] = lrow1;
                                }
                                if (dval > dmaxs[icol]) {
                                    dmaxs[icol] = dval;
                                    this.maxs[icol] = val;
                                    this.imaxs[icol] = lrow1;
                                }
                                v1 = icol;
                                this.sums[v1] = this.sums[v1] + dval;
                                v2 = icol;
                                this.sum2s[v2] = this.sum2s[v2] + dval * dval;
                            }
                        } else if (this.isComparable[icol]) {
                            if (!(val instanceof Comparable)) {
                                System.err.println("Error in table data: not Comparable  at " + lrow1 + "," + icol + "(" + val + ")");
                                good = false;
                            } else {
                                good = true;
                            }
                            if (good) {
                                cval = (Comparable)val;
                                if (this.mins[icol] == null) {
                                    if (!StatsCalculator.$assertionsDisabled && this.maxs[icol] != null) {
                                        throw new AssertionError();
                                    }
                                    this.mins[icol] = val;
                                    this.maxs[icol] = val;
                                    this.imins[icol] = lrow1;
                                    this.imaxs[icol] = lrow1;
                                } else {
                                    try {
                                        if (cval.compareTo(this.mins[icol]) < 0) {
                                            this.mins[icol] = val;
                                            this.imins[icol] = lrow1;
                                        } else if (cval.compareTo(this.maxs[icol]) > 0) {
                                            this.maxs[icol] = val;
                                            this.imaxs[icol] = lrow1;
                                        }
                                    }
                                    catch (ClassCastException e) {
                                        badcompars[icol] = true;
                                    }
                                }
                            }
                        } else if (this.isBoolean[icol]) {
                            if (!(val instanceof Boolean)) {
                                System.err.println("Error in table data: not boolean at " + lrow1 + "," + icol + "(" + val + ")");
                                good = false;
                            } else {
                                good = true;
                            }
                            if (good && (bval = ((Boolean)val).booleanValue())) {
                                v3 = icol;
                                this.ntrues[v3] = this.ntrues[v3] + 1L;
                            }
                        } else {
                            good = true;
                        }
                        if (good) {
                            v4 = icol;
                            this.ngoods[v4] = this.ngoods[v4] + 1L;
                        }
                    }
                    if (good && this.isCardinal[icol]) {
                        valuesets[icol].add(val);
                        if (valuesets[icol].size() > cardlimit) {
                            this.isCardinal[icol] = false;
                            valuesets[icol] = null;
                        }
                    }
                    ++icol;
                }
                break;
            }
            rseq.close();
            nrow = lrow;
            icol = 0;
            while (icol < this.ncol) {
                ngood = this.ngoods[icol];
                this.nbads[icol] = this.ngoodrow - ngood;
                if (ngood > 0L) {
                    if (this.isNumber[icol]) {
                        this.means[icol] = mean = this.sums[icol] / (double)ngood;
                        this.vars[icol] = var = this.sum2s[icol] / (double)ngood - mean * mean;
                        this.sdevs[icol] = Math.sqrt(var);
                    } else if (this.isBoolean[icol]) {
                        this.means[icol] = (double)this.ntrues[icol] / (double)ngood;
                    }
                    if (this.isCardinal[icol]) {
                        card = valuesets[icol].size();
                        if (card <= StatsWindow.this.getCardinalityLimit(ngood)) {
                            this.cards[icol] = card;
                        } else {
                            this.cards[icol] = 0;
                            this.isCardinal[icol] = false;
                            valuesets[icol] = null;
                        }
                    }
                } else {
                    this.means[icol] = NaN;
                    this.sdevs[icol] = NaN;
                    this.vars[icol] = NaN;
                }
                if (badcompars[icol]) {
                    this.mins[icol] = null;
                    this.maxs[icol] = null;
                    this.imins[icol] = -1L;
                    this.imaxs[icol] = -1L;
                }
                ++icol;
            }
            if (interruption != null) {
                throw interruption;
            }
        }

        static /* synthetic */ StatsWindow access$700(StatsCalculator x0) {
            return x0.StatsWindow.this;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$StatsWindow == null ? (class$uk$ac$starlink$topcat$StatsWindow = StatsWindow.class$("uk.ac.starlink.topcat.StatsWindow")) : class$uk$ac$starlink$topcat$StatsWindow).desiredAssertionStatus();
        }
    }
}

