/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BooleanColumnRowSubset;
import uk.ac.starlink.topcat.InverseRowSubset;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.SyntheticColumnQueryWindow;
import uk.ac.starlink.topcat.SyntheticRowSubset;
import uk.ac.starlink.topcat.SyntheticSubsetQueryWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.TopcatViewWindow;

public class SubsetWindow
extends TopcatViewWindow
implements ListDataListener {
    private final TopcatModel tcModel;
    private final OptionsListModel subsets;
    private final Map subsetCounts;
    private final PlasticStarTable dataModel;
    private final MetaColumnTableModel subsetsTableModel;
    private final Action addAct;
    private final Action tocolAct;
    private final Action countAct;
    private final Action invertAct;
    private JTable jtab;
    private JProgressBar progBar;
    private SubsetCounter activeCounter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public SubsetWindow(TopcatModel tcModel, Component parent) {
        super(tcModel, "Row Subsets", parent);
        this.tcModel = tcModel;
        this.subsets = tcModel.getSubsets();
        this.subsetCounts = tcModel.getSubsetCounts();
        this.dataModel = tcModel.getDataModel();
        this.subsetsTableModel = this.makeTableModel();
        this.subsets.addListDataListener(this);
        this.progBar = this.placeProgressBar();
        this.jtab = new JTable(this.subsetsTableModel);
        this.jtab.setColumnSelectionAllowed(false);
        this.jtab.setRowSelectionAllowed(true);
        TableColumnModel tcm = this.jtab.getColumnModel();
        int icol = 0;
        tcm.getColumn(icol++).setPreferredWidth(64);
        tcm.getColumn(icol++).setPreferredWidth(200);
        tcm.getColumn(icol++).setPreferredWidth(80);
        tcm.getColumn(icol++).setPreferredWidth(200);
        tcm.getColumn(icol++).setPreferredWidth(80);
        MetaColumnModel metaColumnModel = new MetaColumnModel(this.jtab.getColumnModel(), this.subsetsTableModel);
        metaColumnModel.purgeEmptyColumns();
        this.jtab.setColumnModel(metaColumnModel);
        this.getMainArea().add(new SizingScrollPane(this.jtab));
        this.addAct = new SubsetAction("New subset", ResourceIcon.ADD, "Define a new subset using algebraic expression");
        this.addAct.setEnabled(TopcatUtils.canJel());
        this.tocolAct = new SubsetAction("To column", ResourceIcon.TO_COLUMN, "Create new boolean column from selected subset");
        this.countAct = new SubsetAction("Count rows", ResourceIcon.COUNT, "Count the number of rows in each subset");
        this.invertAct = new SubsetAction("Invert subset", ResourceIcon.INVERT, "Create new subset complementary to selected subset");
        ListSelectionListener selList = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                int nsel = SubsetWindow.this.jtab.getSelectedRowCount();
                boolean hasUniqueSelection = nsel == 1;
                SubsetWindow.this.tocolAct.setEnabled(hasUniqueSelection);
                SubsetWindow.this.invertAct.setEnabled(hasUniqueSelection);
            }
        };
        ListSelectionModel selectionModel = this.jtab.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(selList);
        selList.valueChanged(null);
        this.getToolBar().add(this.addAct);
        this.getToolBar().add(this.invertAct);
        this.getToolBar().add(this.tocolAct);
        this.getToolBar().add(this.countAct);
        this.getToolBar().addSeparator();
        JMenu subsetsMenu = new JMenu("Subsets");
        subsetsMenu.setMnemonic(83);
        subsetsMenu.add(this.addAct);
        subsetsMenu.add(this.invertAct);
        subsetsMenu.add(this.tocolAct);
        subsetsMenu.add(this.countAct);
        this.getJMenuBar().add(subsetsMenu);
        JMenu displayMenu = metaColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        this.addHelp("SubsetWindow");
        this.pack();
        this.setVisible(true);
    }

    public MetaColumnTableModel makeTableModel() {
        MetaColumn idCol = new MetaColumn("_ID", class$java$lang$String == null ? (class$java$lang$String = SubsetWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return SubsetWindow.this.getSubsetID(irow);
            }
        };
        MetaColumn nameCol = new MetaColumn("Name", class$java$lang$String == null ? (class$java$lang$String = SubsetWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return SubsetWindow.this.getSubsetName(irow);
            }
        };
        MetaColumn sizeCol = new MetaColumn("Size", class$java$lang$Long == null ? (class$java$lang$Long = SubsetWindow.class$("java.lang.Long")) : class$java$lang$Long){

            public Object getValue(int irow) {
                return SubsetWindow.this.getSubsetSize(irow);
            }
        };
        MetaColumn exprCol = new MetaColumn("Expression", class$java$lang$String == null ? (class$java$lang$String = SubsetWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                if (rset instanceof SyntheticRowSubset) {
                    return ((SyntheticRowSubset)rset).getExpression();
                }
                return null;
            }

            public boolean isEditable(int irow) {
                return SubsetWindow.this.getSubset(irow) instanceof SyntheticRowSubset;
            }

            public void setValue(int irow, Object value) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                try {
                    SyntheticRowSubset newSet = new SyntheticRowSubset((StarTable)SubsetWindow.this.dataModel, SubsetWindow.this.subsets, rset.getName(), value.toString());
                    SubsetWindow.this.subsets.set(irow, newSet);
                    SubsetWindow.this.tcModel.getViewModel().fireTableDataChanged();
                }
                catch (CompilationException e) {
                    String[] msg = new String[]{"Syntax error in algebraic subset expression \"" + value + "\":", e.getMessage()};
                    JOptionPane.showMessageDialog(SubsetWindow.this, msg, "Expression Syntax Error", 0);
                }
            }
        };
        String ccname = "Column $ID";
        MetaColumn colCol = new MetaColumn(ccname, class$java$lang$String == null ? (class$java$lang$String = SubsetWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                if (rset instanceof BooleanColumnRowSubset) {
                    ColumnInfo cinfo = ((BooleanColumnRowSubset)rset).getColumnInfo();
                    return " " + SubsetWindow.this.tcModel.getColumnID(cinfo);
                }
                return null;
            }
        };
        ArrayList<MetaColumn> cols = new ArrayList<MetaColumn>();
        cols.add(idCol);
        cols.add(nameCol);
        cols.add(sizeCol);
        cols.add(exprCol);
        cols.add(colCol);
        return new MetaColumnTableModel(cols){

            public int getRowCount() {
                return SubsetWindow.this.subsets.size();
            }
        };
    }

    private RowSubset getSubset(int irow) {
        return (RowSubset)this.subsets.get(irow);
    }

    private String getSubsetID(int irow) {
        return '_' + Integer.toString(irow + 1);
    }

    private String getSubsetName(int irow) {
        return this.getSubset(irow).getName();
    }

    private Object getSubsetSize(int irow) {
        RowSubset rset = this.getSubset(irow);
        Number count = (Number)this.subsetCounts.get(rset);
        return count == null || count.longValue() < 0L ? (Number)null : (Number)count;
    }

    public void dispose() {
        super.dispose();
        if (this.activeCounter != null) {
            this.activeCounter.interrupt();
            this.activeCounter = null;
            this.setBusy(false);
            this.progBar.setValue(0);
        }
    }

    public void contentsChanged(ListDataEvent evt) {
        this.subsetsTableModel.fireTableDataChanged();
    }

    public void intervalAdded(ListDataEvent evt) {
        this.subsetsTableModel.fireTableDataChanged();
    }

    public void intervalRemoved(ListDataEvent evt) {
        this.subsetsTableModel.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Map access$1600(SubsetWindow x0) {
        return x0.subsetCounts;
    }

    private class SubsetCounter
    extends Thread {
        private long currentRow;

        public SubsetCounter() {
            super("Subset counter");
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SubsetCounter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (SubsetWindow.access$1200(SubsetCounter.access$1300(this.this$1)) == this.this$1) {
                        SubsetCounter.access$1300(this.this$1).setBusy(true);
                    }
                }
            });
            this.count();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SubsetCounter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (SubsetWindow.access$1200(SubsetCounter.access$1300(this.this$1)) == this.this$1) {
                        SubsetWindow.access$1202(SubsetCounter.access$1300(this.this$1), null);
                        SubsetCounter.access$1300(this.this$1).setBusy(false);
                    }
                }
            });
        }

        void count() {
            RowSubset[] rsets = SubsetWindow.this.subsets == null ? new RowSubset[]{} : SubsetWindow.this.subsets.toArray(new RowSubset[0]);
            int nrset = rsets.length;
            long[] counts = new long[nrset];
            long nrow = SubsetWindow.this.dataModel.getRowCount();
            SubsetWindow.this.progBar.setMaximum((int)Math.min(Integer.MAX_VALUE, nrow));
            Runnable updater = new Runnable(this){
                private final /* synthetic */ SubsetCounter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (SubsetWindow.access$1200(SubsetCounter.access$1300(this.this$1)) == this.this$1) {
                        SubsetWindow.access$1400(SubsetCounter.access$1300(this.this$1)).setValue((int)SubsetCounter.access$1500(this.this$1));
                    }
                }
            };
            long every = nrow / 200L;
            long counter = 0L;
            this.currentRow = 0L;
            while (this.currentRow < nrow && !Thread.interrupted()) {
                if (--counter < 0L) {
                    SwingUtilities.invokeLater(updater);
                    counter = every;
                }
                int i = 0;
                while (i < nrset) {
                    RowSubset rset = rsets[i];
                    if (rset.isIncluded(this.currentRow)) {
                        int n = i;
                        counts[n] = counts[n] + 1L;
                    }
                    ++i;
                }
                ++this.currentRow;
            }
            SwingUtilities.invokeLater(updater);
            if (this.currentRow == nrow) {
                SwingUtilities.invokeLater(new Runnable(this, nrset, rsets, counts){
                    private final /* synthetic */ int val$nrset;
                    private final /* synthetic */ RowSubset[] val$rsets;
                    private final /* synthetic */ long[] val$counts;
                    private final /* synthetic */ SubsetCounter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$nrset = val$nrset;
                        this.val$rsets = val$rsets;
                        this.val$counts = val$counts;
                    }

                    public void run() {
                        int i = 0;
                        while (i < this.val$nrset) {
                            SubsetWindow.access$1600(SubsetCounter.access$1300(this.this$1)).put(this.val$rsets[i], new Long(this.val$counts[i]));
                            ++i;
                        }
                        SubsetWindow.access$800(SubsetCounter.access$1300(this.this$1)).fireContentsChanged(0, this.val$nrset - 1);
                        if (SubsetWindow.access$1200(SubsetCounter.access$1300(this.this$1)) == this.this$1) {
                            SubsetWindow.access$1400(SubsetCounter.access$1300(this.this$1)).setValue(0);
                        }
                    }
                });
            }
        }

        static /* synthetic */ SubsetWindow access$1300(SubsetCounter x0) {
            return x0.SubsetWindow.this;
        }

        static /* synthetic */ long access$1500(SubsetCounter x0) {
            return x0.currentRow;
        }
    }

    private class SubsetAction
    extends BasicAction {
        SubsetAction(String name, Icon icon, String description) {
            super(name, icon, description);
        }

        public void actionPerformed(ActionEvent evt) {
            SubsetWindow parent = SubsetWindow.this;
            if (this == SubsetWindow.this.addAct) {
                new SyntheticSubsetQueryWindow(SubsetWindow.this.tcModel, (Component)parent);
            } else if (this == SubsetWindow.this.tocolAct) {
                SyntheticColumnQueryWindow colwin = new SyntheticColumnQueryWindow(SubsetWindow.this.tcModel, -1, parent);
                int irow = SubsetWindow.this.jtab.getSelectedRow();
                colwin.setExpression(SubsetWindow.this.getSubsetID(irow));
                colwin.setName(SubsetWindow.this.getSubsetName(irow));
            } else if (this == SubsetWindow.this.countAct) {
                if (SubsetWindow.this.activeCounter != null) {
                    SubsetWindow.this.activeCounter.interrupt();
                }
                SubsetCounter sc = new SubsetCounter();
                SubsetWindow.this.activeCounter = sc;
                sc.start();
            } else if (this == SubsetWindow.this.invertAct) {
                int irow = SubsetWindow.this.jtab.getSelectedRow();
                SubsetWindow.this.subsets.add(new InverseRowSubset(SubsetWindow.this.getSubset(irow)));
            } else {
                throw new AssertionError();
            }
        }
    }
}

