/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import gnu.jel.Parser;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatJELRowReader;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.ttools.JELRowReader;

public class SyntheticColumn
extends ColumnData {
    private StarTable stable;
    private List subsets;
    private String expression;
    private CompiledExpression compEx;
    private TopcatJELRowReader rowReader;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.topcat");

    public SyntheticColumn(ValueInfo vinfo, StarTable stable, List subsets, String expression, Class resultType) throws CompilationException {
        super(vinfo);
        this.stable = stable;
        this.subsets = subsets;
        this.setExpression(expression, resultType);
    }

    public void setExpression(String expression, Class resultType) throws CompilationException {
        RowSubset[] subsetArray = this.subsets == null ? new RowSubset[]{} : this.subsets.toArray(new RowSubset[0]);
        this.rowReader = new TopcatJELRowReader(this.stable, subsetArray);
        Library lib = TopcatJELUtils.getLibrary((JELRowReader)this.rowReader, false);
        this.compEx = Evaluator.compile((String)expression, (Library)lib, (Class)resultType);
        Class actualType = new Parser((String)expression, (Library)lib).parse((Class)resultType).resType;
        if (actualType.isPrimitive()) {
            actualType = TopcatJELUtils.wrapPrimitiveClass(actualType);
        }
        ColumnInfo colinfo = this.getColumnInfo();
        colinfo.setContentClass(actualType);
        ValueInfo exprInfo = TopcatUtils.EXPR_INFO;
        colinfo.setAuxDatum(new DescribedValue(exprInfo, (Object)expression));
        ValueInfo basedescInfo = TopcatUtils.BASE_DESCRIPTION_INFO;
        DescribedValue basedescValue = colinfo.getAuxDatum(basedescInfo);
        if (basedescValue == null) {
            basedescValue = new DescribedValue(basedescInfo, (Object)colinfo.getDescription());
            colinfo.setAuxDatum(basedescValue);
        }
        colinfo.setDescription(basedescValue.getValue() + " (" + expression + ")");
    }

    public Object readValue(long lrow) throws IOException {
        try {
            return this.rowReader.evaluateAtRow(this.compEx, lrow);
        }
        catch (RuntimeException e) {
            logger.info(e.toString());
            return null;
        }
        catch (Throwable th) {
            throw (IOException)new IOException(th.getMessage()).initCause(th);
        }
    }
}

