/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import gnu.jel.DVResolver;
import gnu.jel.Library;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.ttools.JELRowReader;
import uk.ac.starlink.ttools.JELUtils;

public class TopcatJELUtils
extends JELUtils {
    private static List activationStaticClasses;
    public static final String ACTIVATION_CLASSES_PROPERTY = "jel.classes.activation";
    private static Logger logger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Output;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$System;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Image;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Spectrum;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$BasicImageDisplay;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Sog;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Splat;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Browsers;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Mgc;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$Sdss;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$SuperCosmos;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$func$TwoQZ;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static Library getLibrary(JELRowReader rowReader, boolean activation) {
        ArrayList statix = new ArrayList(JELUtils.getStaticClasses());
        if (activation) {
            statix.addAll(TopcatJELUtils.getActivationStaticClasses());
        }
        Class[] staticLib = statix.toArray(new Class[0]);
        Class[] dynamicLib = new Class[]{rowReader.getClass()};
        Class[] dotClasses = new Class[]{};
        JELRowReader resolver = rowReader;
        Hashtable cnmap = null;
        Library lib = new Library(staticLib, dynamicLib, dotClasses, (DVResolver)resolver, cnmap);
        if (activation) {
            try {
                int i = 1;
                while (i <= 4) {
                    Object[] argClasses = new Class[i];
                    Arrays.fill(argClasses, class$java$lang$String == null ? TopcatJELUtils.class$("java.lang.String") : class$java$lang$String);
                    lib.markStateDependent("exec", (Class[])argClasses);
                    ++i;
                }
            }
            catch (CompilationException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
            }
        }
        return lib;
    }

    public static List getActivationStaticClasses() {
        if (activationStaticClasses == null) {
            ArrayList<Class> classList = new ArrayList<Class>();
            classList.add(class$uk$ac$starlink$topcat$func$Output == null ? (class$uk$ac$starlink$topcat$func$Output = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Output")) : class$uk$ac$starlink$topcat$func$Output);
            classList.add(class$uk$ac$starlink$topcat$func$System == null ? (class$uk$ac$starlink$topcat$func$System = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.System")) : class$uk$ac$starlink$topcat$func$System);
            classList.add(class$uk$ac$starlink$topcat$func$Image == null ? (class$uk$ac$starlink$topcat$func$Image = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Image")) : class$uk$ac$starlink$topcat$func$Image);
            classList.add(class$uk$ac$starlink$topcat$func$Spectrum == null ? (class$uk$ac$starlink$topcat$func$Spectrum = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Spectrum")) : class$uk$ac$starlink$topcat$func$Spectrum);
            classList.add(class$uk$ac$starlink$topcat$func$BasicImageDisplay == null ? (class$uk$ac$starlink$topcat$func$BasicImageDisplay = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.BasicImageDisplay")) : class$uk$ac$starlink$topcat$func$BasicImageDisplay);
            if (TopcatUtils.canSog()) {
                classList.add(class$uk$ac$starlink$topcat$func$Sog == null ? (class$uk$ac$starlink$topcat$func$Sog = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Sog")) : class$uk$ac$starlink$topcat$func$Sog);
            }
            if (TopcatUtils.canSplat()) {
                classList.add(class$uk$ac$starlink$topcat$func$Splat == null ? (class$uk$ac$starlink$topcat$func$Splat = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Splat")) : class$uk$ac$starlink$topcat$func$Splat);
            }
            classList.add(class$uk$ac$starlink$topcat$func$Browsers == null ? (class$uk$ac$starlink$topcat$func$Browsers = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Browsers")) : class$uk$ac$starlink$topcat$func$Browsers);
            classList.add(class$uk$ac$starlink$topcat$func$Mgc == null ? (class$uk$ac$starlink$topcat$func$Mgc = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Mgc")) : class$uk$ac$starlink$topcat$func$Mgc);
            classList.add(class$uk$ac$starlink$topcat$func$Sdss == null ? (class$uk$ac$starlink$topcat$func$Sdss = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.Sdss")) : class$uk$ac$starlink$topcat$func$Sdss);
            classList.add(class$uk$ac$starlink$topcat$func$SuperCosmos == null ? (class$uk$ac$starlink$topcat$func$SuperCosmos = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.SuperCosmos")) : class$uk$ac$starlink$topcat$func$SuperCosmos);
            classList.add(class$uk$ac$starlink$topcat$func$TwoQZ == null ? (class$uk$ac$starlink$topcat$func$TwoQZ = TopcatJELUtils.class$("uk.ac.starlink.topcat.func.TwoQZ")) : class$uk$ac$starlink$topcat$func$TwoQZ);
            try {
                String auxClasses = System.getProperty(ACTIVATION_CLASSES_PROPERTY);
                if (auxClasses != null && auxClasses.trim().length() > 0) {
                    String[] cs = auxClasses.split(":");
                    int i = 0;
                    while (i < cs.length) {
                        String className = cs[i].trim();
                        Class clazz = TopcatJELUtils.classForName(className);
                        if (clazz != null) {
                            if (!classList.contains(clazz)) {
                                classList.add(clazz);
                            }
                        } else {
                            logger.warning("Class not found: " + className);
                        }
                        ++i;
                    }
                }
            }
            catch (SecurityException e) {
                logger.info("Security manager prevents loading auxiliary JEL classes");
            }
            activationStaticClasses = classList;
        }
        return activationStaticClasses;
    }

    public static Class wrapPrimitiveClass(Class prim) {
        if (prim == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TopcatJELUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (prim == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = TopcatJELUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (prim == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = TopcatJELUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (prim == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = TopcatJELUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (prim == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = TopcatJELUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (prim == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = TopcatJELUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (prim == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = TopcatJELUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (prim == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = TopcatJELUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        throw new IllegalArgumentException(prim + " is not primitive");
    }

    public static Class classForName(String cname) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(cname, true, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.topcat");
    }
}

