/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.topcat.ActivationQueryWindow;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BooleanColumnRowSubset;
import uk.ac.starlink.topcat.ColumnInfoWindow;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.ColumnSelectorModel;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.JELActivator;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.ParameterWindow;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SaveQueryWindow;
import uk.ac.starlink.topcat.SortOrder;
import uk.ac.starlink.topcat.StatsWindow;
import uk.ac.starlink.topcat.SubsetWindow;
import uk.ac.starlink.topcat.SyntheticSubsetQueryWindow;
import uk.ac.starlink.topcat.TableViewerWindow;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.ViewerTableModel;
import uk.ac.starlink.topcat.WindowAction;
import uk.ac.starlink.topcat.plot.PlotWindow;

public class TopcatModel {
    private final PlasticStarTable dataModel;
    private final ViewerTableModel viewModel;
    private final TableColumnModel columnModel;
    private final ColumnList columnList;
    private final OptionsListModel subsets;
    private final Map subsetCounts;
    private final OptionsListModel activators;
    private final ComboBoxModel sortSelectionModel;
    private final ComboBoxModel subsetSelectionModel;
    private final SortSenseModel sortSenseModel;
    private final Collection listeners;
    private final Map columnSelectorMap;
    private final int id;
    private final ControlWindow controlWindow;
    private String location;
    private String label;
    private Activator activator;
    private TableViewerWindow viewerWindow;
    private ParameterWindow paramWindow;
    private ColumnInfoWindow colinfoWindow;
    private StatsWindow statsWindow;
    private SubsetWindow subsetWindow;
    private PlotWindow plotWindow;
    private ActivationQueryWindow activationWindow;
    private SaveQueryWindow saveWindow;
    private Action newsubsetAct;
    private Action unsortAct;
    private TopcatWindowAction viewerAct;
    private TopcatWindowAction paramAct;
    private TopcatWindowAction colinfoAct;
    private TopcatWindowAction statsAct;
    private TopcatWindowAction subsetAct;
    private TopcatWindowAction plotAct;
    private TopcatWindowAction activationAct;
    private TopcatWindowAction saveAct;
    private TopcatWindowAction[] windowActions;
    private static int instanceCount = 0;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$TopcatModel;
    static /* synthetic */ Class class$java$lang$Comparable;

    public TopcatModel(StarTable startab, String location, ControlWindow controlWindow) {
        this.controlWindow = controlWindow;
        if (!startab.isRandom()) {
            throw new IllegalArgumentException("Can't use non-random table");
        }
        this.location = location;
        this.label = location;
        this.id = ++instanceCount;
        if (this.label == null) {
            this.label = startab.getName();
        }
        if (this.label == null) {
            this.label = "(table)";
        }
        this.dataModel = new PlasticStarTable(startab);
        this.viewModel = new ViewerTableModel(this.dataModel);
        this.columnModel = new DefaultTableColumnModel();
        int icol = 0;
        while (icol < this.dataModel.getColumnCount()) {
            ColumnInfo cinfo = this.dataModel.getColumnInfo(icol);
            StarTableColumn tcol = new StarTableColumn(cinfo, icol);
            this.columnModel.addColumn((TableColumn)tcol);
            ++icol;
        }
        this.columnList = new ColumnList(this.columnModel);
        this.sortSelectionModel = new SortSelectionModel();
        this.sortSenseModel = new SortSenseModel();
        this.subsets = new OptionsListModel();
        this.subsets.add(RowSubset.ALL);
        this.subsetSelectionModel = new SubsetSelectionModel();
        this.subsetCounts = new HashMap();
        this.subsetCounts.put(RowSubset.NONE, new Long(0L));
        this.subsetCounts.put(RowSubset.ALL, new Long(startab.getRowCount()));
        int ncol = this.dataModel.getColumnCount();
        int icol2 = 0;
        while (icol2 < ncol) {
            ColumnInfo cinfo = this.dataModel.getColumnInfo(icol2);
            if (cinfo.getContentClass() == (class$java$lang$Boolean == null ? TopcatModel.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                int jcol = icol2;
                BooleanColumnRowSubset yes = new BooleanColumnRowSubset((StarTable)this.dataModel, icol2);
                this.subsets.add(yes);
            }
            ++icol2;
        }
        this.activator = Activator.NOP;
        this.columnSelectorMap = new HashMap();
        this.activators = new OptionsListModel();
        this.viewerAct = new TopcatWindowAction("Table browser", ResourceIcon.VIEWER, "Display table cell data");
        this.paramAct = new TopcatWindowAction("Table parameters", ResourceIcon.PARAMS, "Display table metadata");
        this.colinfoAct = new TopcatWindowAction("Column metadata", ResourceIcon.COLUMNS, "Display metadata for each column");
        this.statsAct = new TopcatWindowAction("Column statistics", ResourceIcon.STATS, "Display statistics for each column");
        this.subsetAct = new TopcatWindowAction("Row subsets", ResourceIcon.SUBSETS, "Display row subsets");
        this.plotAct = new TopcatWindowAction("Plot", ResourceIcon.PLOT, "Plot columns from this table");
        this.windowActions = new TopcatWindowAction[]{this.viewerAct, this.paramAct, this.colinfoAct, this.statsAct, this.subsetAct, this.plotAct};
        this.newsubsetAct = new ModelAction("New Subset Expression", null, "Define a new row subset");
        this.unsortAct = new ModelAction("Unsort", ResourceIcon.UNSORT, "Use natural row order");
        this.activationAct = new TopcatWindowAction("Set Activation Action", null, "Set what happens when a row/point is clicked on");
        this.saveAct = new TopcatWindowAction("Save Table", ResourceIcon.SAVE, "Write out the current table");
        this.listeners = new ArrayList();
    }

    public String getLocation() {
        return this.location;
    }

    public String getLabel() {
        return this.label;
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        return this.id + ": " + this.getLabel();
    }

    public void setLabel(String label) {
        if (!TopcatModel.equalObject(label, this.label)) {
            this.label = label;
            this.fireModelChanged(1);
        }
    }

    public void setActivator(Activator activator) {
        if (!TopcatModel.equalObject(activator, this.activator)) {
            this.activator = activator;
            if (activator != null && activator != Activator.NOP) {
                List params = this.dataModel.getParameters();
                params.remove(this.dataModel.getParameterByName(TopcatUtils.ACTIVATORS_INFO.getName()));
                params.add(new DescribedValue(TopcatUtils.ACTIVATORS_INFO, (Object)activator.toString()));
            }
            this.fireModelChanged(2);
        }
    }

    public Activator getActivator() {
        return this.activator;
    }

    public OptionsListModel getActivatorList() {
        return this.activators;
    }

    public Activator makeActivator(String actstr) throws CompilationException {
        if (actstr == null || actstr.trim().length() == 0 || actstr.equals(Activator.NOP.toString())) {
            return Activator.NOP;
        }
        return new JELActivator(this, actstr);
    }

    public PlasticStarTable getDataModel() {
        return this.dataModel;
    }

    public ViewerTableModel getViewModel() {
        return this.viewModel;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public ColumnList getColumnList() {
        return this.columnList;
    }

    public OptionsListModel getSubsets() {
        return this.subsets;
    }

    public Map getSubsetCounts() {
        return this.subsetCounts;
    }

    public ComboBoxModel getSortSelectionModel() {
        return this.sortSelectionModel;
    }

    public JToggleButton.ToggleButtonModel getSortSenseModel() {
        return this.sortSenseModel;
    }

    public ComboBoxModel getSubsetSelectionModel() {
        return this.subsetSelectionModel;
    }

    public RowSubset getSelectedSubset() {
        return (RowSubset)this.subsetSelectionModel.getSelectedItem();
    }

    public SortOrder getSelectedSort() {
        return (SortOrder)this.sortSelectionModel.getSelectedItem();
    }

    public ColumnSelectorModel getColumnSelectorModel(ValueInfo info) {
        if (!this.columnSelectorMap.containsKey(info)) {
            this.columnSelectorMap.put(info, new ColumnSelectorModel(this, info));
        }
        return (ColumnSelectorModel)this.columnSelectorMap.get(info);
    }

    public void addTopcatListener(TopcatListener listener) {
        this.listeners.add(listener);
    }

    public void removeTopcatListener(TopcatListener listener) {
        this.listeners.remove(listener);
    }

    public void fireModelChanged(int code) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((TopcatListener)it.next()).modelChanged(this, code);
        }
    }

    public void highlightRow(long lrow) {
        String msg;
        if (this.plotWindow != null) {
            this.plotWindow.highlightRow(lrow);
        }
        if (this.viewerWindow != null) {
            this.viewerWindow.highlightRow(lrow);
        }
        if (this.activator != null && (msg = this.activator.activateRow(lrow)) != null && msg.trim().length() > 0) {
            System.out.println(msg);
        }
    }

    public WindowAction getViewerAction() {
        return this.viewerAct;
    }

    public WindowAction getParameterAction() {
        return this.paramAct;
    }

    public WindowAction getColumnInfoAction() {
        return this.colinfoAct;
    }

    public WindowAction getStatsAction() {
        return this.statsAct;
    }

    public WindowAction getSubsetAction() {
        return this.subsetAct;
    }

    public WindowAction getPlotAction() {
        return this.plotAct;
    }

    public Action getNewSubsetAction() {
        return this.newsubsetAct;
    }

    public Action getUnsortAction() {
        return this.unsortAct;
    }

    public Action getActivationAction() {
        return this.activationAct;
    }

    public Action getSaveAction() {
        return this.saveAct;
    }

    public Action getSortAction(final SortOrder order, final boolean ascending) {
        TableColumn tcol = order.getColumn();
        return new BasicAction("Sort " + (ascending ? "up" : "down"), ascending ? ResourceIcon.UP : ResourceIcon.DOWN, "Sort rows by " + (ascending ? "a" : "de") + "scending order of " + tcol.getIdentifier()){

            public void actionPerformed(ActionEvent evt) {
                TopcatModel.this.sortBy(order, ascending);
            }
        };
    }

    public String enquireSubsetName(Component parent) {
        String name = JOptionPane.showInputDialog(parent, "New subset name", "Subset Name Input", 3);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return name;
    }

    public void hideWindows() {
        int i = 0;
        while (i < this.windowActions.length) {
            TopcatWindowAction act = this.windowActions[i];
            act.putValue("VISIBLE", Boolean.FALSE);
            ++i;
        }
    }

    public void revealWindows() {
        int i = 0;
        while (i < this.windowActions.length) {
            TopcatWindowAction act = this.windowActions[i];
            if (act.hasWindow()) {
                act.putValue("VISIBLE", Boolean.TRUE);
            }
            ++i;
        }
    }

    public String getColumnID(ColumnInfo cinfo) {
        return cinfo.getAuxDatum(TopcatUtils.COLID_INFO).getValue().toString();
    }

    public void appendColumn(ColumnData col, int colIndex) {
        if (colIndex > this.dataModel.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        this.dataModel.addColumn(col);
        int modelIndex = this.dataModel.getColumnCount() - 1;
        StarTableColumn tc = new StarTableColumn(col.getColumnInfo(), modelIndex);
        this.columnModel.addColumn((TableColumn)tc);
        if (colIndex >= 0) {
            this.columnModel.moveColumn(this.columnModel.getColumnCount() - 1, colIndex);
        } else {
            colIndex = this.columnModel.getColumnCount() - 1;
        }
    }

    public void appendColumn(ColumnData col) {
        this.appendColumn(col, -1);
    }

    public void appendColumns(final StarTable colTable) {
        int i = 0;
        while (i < colTable.getColumnCount()) {
            final int icol = i;
            ColumnData cdata = new ColumnData(colTable.getColumnInfo(i)){

                public Object readValue(long lrow) throws IOException {
                    return colTable.getCell(lrow, icol);
                }
            };
            this.appendColumn(cdata, -1);
            ++i;
        }
    }

    public void renameColumn(TableColumn tcol, String name) {
        tcol.setHeaderValue(name);
        if (tcol instanceof StarTableColumn) {
            ((StarTableColumn)tcol).getColumnInfo().setName(name);
        }
        int i = 0;
        while (i < this.columnModel.getColumnCount()) {
            if (this.columnModel.getColumn(i) == tcol) {
                this.columnModel.moveColumn(i, i);
            }
            ++i;
        }
    }

    public void addSubset(RowSubset rset) {
        this.subsets.add(rset);
    }

    public void addParameter(DescribedValue param) {
        this.dataModel.getParameters().add(param);
        this.fireModelChanged(3);
    }

    public boolean removeParameter(DescribedValue param) {
        if (this.dataModel.getParameters().remove(param)) {
            this.fireModelChanged(3);
            return true;
        }
        return false;
    }

    public void sortBy(SortOrder order, boolean ascending) {
        if (order != SortOrder.NONE) {
            this.sortSenseModel.setSelected(ascending);
        }
        this.sortSelectionModel.setSelectedItem(order);
    }

    public void applySubset(RowSubset rset) {
        this.subsetSelectionModel.setSelectedItem(rset);
    }

    private int[] getSortOrder(int icol, boolean ascending) throws IOException {
        int sense = ascending ? 1 : -1;
        int nrow = AbstractStarTable.checkedLongToInt((long)this.dataModel.getRowCount());
        ColumnData coldata = this.dataModel.getColumnData(icol);
        class Item
        implements Comparable {
            int rank;
            Comparable value;
            private final /* synthetic */ int val$sense;
            private final /* synthetic */ TopcatModel this$0;

            Item(TopcatModel this$0, int val$sense) {
                this.this$0 = this$0;
                this.val$sense = val$sense;
            }

            public int compareTo(Object o) {
                Comparable oval = ((Item)o).value;
                if (this.value != null && oval != null) {
                    return this.val$sense * this.value.compareTo(oval);
                }
                if (this.value == null && oval == null) {
                    return 0;
                }
                return this.val$sense * (this.value == null ? 1 : -1);
            }
        }
        Object[] items = new Item[nrow];
        int i = 0;
        while (i < nrow) {
            Item item = new Item(this, sense);
            item.rank = i;
            item.value = (Comparable)coldata.readValue((long)i);
            items[i] = item;
            ++i;
        }
        Arrays.sort(items);
        int[] rowMap = new int[nrow];
        int i2 = 0;
        while (i2 < nrow) {
            rowMap[i2] = ((Item)items[i2]).rank;
            ++i2;
        }
        return rowMap;
    }

    public StarTable getApparentStarTable() {
        int ncol = this.columnModel.getColumnCount();
        int[] colMap = new int[ncol];
        int icol = 0;
        while (icol < ncol) {
            colMap[icol] = this.columnModel.getColumn(icol).getModelIndex();
            ++icol;
        }
        return new ColumnPermutedStarTable(this.viewModel.getSnapshot(), colMap);
    }

    private static boolean equalObject(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SubsetSelectionModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private RowSubset lastSubset = RowSubset.ALL;

        SubsetSelectionModel() {
            TopcatModel.this.subsets.addListDataListener(this);
        }

        public Object getSelectedItem() {
            return this.lastSubset;
        }

        public void setSelectedItem(Object item) {
            RowSubset rset = (RowSubset)item;
            if (rset == null) {
                return;
            }
            if (rset.equals(this.lastSubset)) {
                return;
            }
            TopcatModel.this.viewModel.setSubset(rset);
            TopcatModel.this.subsetCounts.put(rset, new Long(TopcatModel.this.viewModel.getRowCount()));
            int irset = TopcatModel.this.subsets.indexOf(rset);
            if (irset >= 0) {
                TopcatModel.this.subsets.fireContentsChanged(irset, irset);
            }
            this.lastSubset = rset;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getElementAt(int index) {
            return TopcatModel.this.subsets.getElementAt(index);
        }

        public int getSize() {
            return TopcatModel.this.subsets.getSize();
        }

        public void contentsChanged(ListDataEvent evt) {
            this.fireContentsChanged(this, evt.getIndex0(), evt.getIndex1());
        }

        public void intervalAdded(ListDataEvent evt) {
            this.fireIntervalAdded(this, evt.getIndex0(), evt.getIndex1());
        }

        public void intervalRemoved(ListDataEvent evt) {
            this.fireIntervalRemoved(this, evt.getIndex0(), evt.getIndex1());
        }
    }

    private class SortSelectionModel
    extends RestrictedColumnComboBoxModel {
        private SortOrder lastSort;

        SortSelectionModel() {
            super(TopcatModel.this.columnModel, true);
            this.lastSort = SortOrder.NONE;
        }

        public Object getElementAt(int index) {
            return new SortOrder((TableColumn)super.getElementAt(index));
        }

        public boolean acceptColumn(ColumnInfo cinfo) {
            Class clazz = cinfo.getContentClass();
            return (class$java$lang$Comparable == null ? (class$java$lang$Comparable = TopcatModel.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(clazz);
        }

        public Object getSelectedItem() {
            return this.lastSort;
        }

        public void setSelectedItem(Object item) {
            int[] rowMap;
            SortOrder order = (SortOrder)item;
            if (order == null) {
                return;
            }
            if (order.equals(this.lastSort)) {
                return;
            }
            if (order.equals(SortOrder.NONE)) {
                rowMap = null;
            } else {
                TableColumn tcol = order.getColumn();
                try {
                    rowMap = TopcatModel.this.getSortOrder(tcol.getModelIndex(), TopcatModel.this.sortSenseModel.isSelected());
                }
                catch (IOException e) {
                    Toolkit.getDefaultToolkit().beep();
                    e.printStackTrace(System.err);
                    this.setSelectedItem(SortOrder.NONE);
                    return;
                }
            }
            TopcatModel.this.viewModel.setOrder(rowMap);
            this.lastSort = order;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class SortSenseModel
    extends JToggleButton.ToggleButtonModel {
        boolean lastAscending = true;

        private SortSenseModel() {
        }

        public void setSelected(boolean ascending) {
            if (ascending != this.lastAscending) {
                int[] rowMap = TopcatModel.this.viewModel.getRowMap();
                if (rowMap != null) {
                    int i = 0;
                    int j = rowMap.length - 1;
                    while (i < j) {
                        int c = rowMap[i];
                        rowMap[i] = rowMap[j];
                        rowMap[j] = c;
                        ++i;
                        --j;
                    }
                    TopcatModel.this.viewModel.setRowMap(rowMap);
                }
                this.lastAscending = ascending;
                this.fireStateChanged();
            }
        }

        public boolean isSelected() {
            return this.lastAscending;
        }
    }

    private class TopcatWindowAction
    extends WindowAction {
        TopcatWindowAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public boolean hasWindow() {
            if (this == TopcatModel.this.viewerAct) {
                return TopcatModel.this.viewerWindow != null;
            }
            if (this == TopcatModel.this.paramAct) {
                return TopcatModel.this.paramWindow != null;
            }
            if (this == TopcatModel.this.colinfoAct) {
                return TopcatModel.this.colinfoWindow != null;
            }
            if (this == TopcatModel.this.statsAct) {
                return TopcatModel.this.statsWindow != null;
            }
            if (this == TopcatModel.this.subsetAct) {
                return TopcatModel.this.subsetWindow != null;
            }
            if (this == TopcatModel.this.plotAct) {
                return TopcatModel.this.plotWindow != null;
            }
            if (this == TopcatModel.this.activationAct) {
                return TopcatModel.this.activationWindow != null;
            }
            if (this == TopcatModel.this.saveAct) {
                return TopcatModel.this.saveWindow != null;
            }
            throw new AssertionError();
        }

        public Window getWindow(Component parent) {
            TopcatModel tcModel = TopcatModel.this;
            if (this == TopcatModel.this.viewerAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.viewerWindow = new TableViewerWindow(tcModel, parent);
                }
                return TopcatModel.this.viewerWindow;
            }
            if (this == TopcatModel.this.paramAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.paramWindow = new ParameterWindow(tcModel, parent);
                }
                return TopcatModel.this.paramWindow;
            }
            if (this == TopcatModel.this.colinfoAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.colinfoWindow = new ColumnInfoWindow(tcModel, parent);
                }
                return TopcatModel.this.colinfoWindow;
            }
            if (this == TopcatModel.this.statsAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.statsWindow = new StatsWindow(tcModel, parent);
                }
                return TopcatModel.this.statsWindow;
            }
            if (this == TopcatModel.this.subsetAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.subsetWindow = new SubsetWindow(tcModel, parent);
                }
                return TopcatModel.this.subsetWindow;
            }
            if (this == TopcatModel.this.plotAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.plotWindow = new PlotWindow(tcModel, parent);
                }
                return TopcatModel.this.plotWindow;
            }
            if (this == TopcatModel.this.activationAct) {
                if (!this.hasWindow()) {
                    TopcatModel.this.activationWindow = new ActivationQueryWindow(tcModel, parent);
                }
                return TopcatModel.this.activationWindow;
            }
            if (this == TopcatModel.this.saveAct) {
                if (!this.hasWindow()) {
                    StarTableOutput sto = TopcatModel.this.controlWindow.getTableOutput();
                    TableLoadChooser loadChooser = TopcatModel.this.controlWindow.getLoadChooser();
                    TopcatModel.this.saveWindow = new SaveQueryWindow(tcModel, sto, loadChooser, parent);
                }
                return TopcatModel.this.saveWindow;
            }
            throw new AssertionError();
        }
    }

    private class ModelAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        ModelAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            Component parent = this.getEventWindow(evt);
            TopcatModel model = TopcatModel.this;
            if (this == TopcatModel.this.newsubsetAct) {
                new SyntheticSubsetQueryWindow(model, parent);
            } else if (this == TopcatModel.this.unsortAct) {
                TopcatModel.this.sortBy(SortOrder.NONE, false);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$TopcatModel == null ? (class$uk$ac$starlink$topcat$TopcatModel = TopcatModel.class$("uk.ac.starlink.topcat.TopcatModel")) : class$uk$ac$starlink$topcat$TopcatModel).desiredAssertionStatus();
        }
    }
}

