/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.doc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.ttools.build.XmlDoclet;

public class SummaryXmlDoclet
extends XmlDoclet {
    private boolean discardOutput_;
    private Class[] classes_;

    public static boolean start(RootDoc root) throws IOException {
        return new SummaryXmlDoclet(root).process();
    }

    public static int optionLength(String option) {
        if (option.equals("-gen")) {
            return 1;
        }
        if (option.equals("-act")) {
            return 1;
        }
        return XmlDoclet.optionLength((String)option);
    }

    protected SummaryXmlDoclet(RootDoc root) throws IOException {
        super(root);
        String[][] options = root.options();
        int i = 0;
        while (i < options.length) {
            String opt = options[i][0];
            if (opt.equals("-gen")) {
                this.classes_ = TopcatJELUtils.getStaticClasses().toArray(new Class[0]);
            } else if (opt.equals("-act")) {
                this.classes_ = TopcatJELUtils.getActivationStaticClasses().toArray(new Class[0]);
            }
            ++i;
        }
    }

    protected boolean process() throws IOException {
        this.out("<dl>");
        boolean ret = super.process();
        this.out("</dl>");
        this.flush();
        return ret;
    }

    protected void startClass(ClassDoc clazz) throws IOException {
        this.discardOutput_ = !this.useClass(clazz);
        this.out("<dt>" + clazz.name() + "</dt>");
        this.out("<dd>");
        String comment = clazz.commentText();
        if (comment != null) {
            this.out(XmlDoclet.doctorText((String)comment));
        }
        this.out("<p><dl>");
    }

    protected void endClass() throws IOException {
        this.out("</dl></p>");
        this.out("</dd>");
        this.discardOutput_ = false;
    }

    protected void startMember(MemberDoc mem, String memType, String memName) throws IOException {
        this.out("<dt>" + memName + "</dt>");
        String comment = mem.commentText();
        if (comment != null) {
            this.out("<dd>" + XmlDoclet.doctorText((String)comment) + "</dd>");
        }
    }

    protected void endMember() {
    }

    private boolean useClass(ClassDoc classDoc) {
        if (this.classes_ == null) {
            return true;
        }
        String cname = classDoc.qualifiedName();
        int i = 0;
        while (i < this.classes_.length) {
            if (this.classes_[i].getName().equals(cname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void out(String line) throws IOException {
        if (!this.discardOutput_) {
            super.out(line);
        }
    }
}

