/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import java.io.IOException;
import java.io.InputStream;

abstract class Executor {
    private boolean done_;
    private String out_;
    private String err_;

    Executor() {
    }

    abstract Process getProcess() throws IOException;

    abstract String getLine();

    public String getOut() {
        return this.out_;
    }

    public String getErr() {
        return this.err_;
    }

    public int executeSynchronously() throws IOException, InterruptedException {
        if (this.done_) {
            throw new IllegalStateException();
        }
        this.done_ = true;
        Process proc = this.getProcess();
        ReaderThread outReader = new ReaderThread(proc.getInputStream());
        ReaderThread errReader = new ReaderThread(proc.getErrorStream());
        outReader.start();
        errReader.start();
        int status = proc.waitFor();
        outReader.join(500L);
        errReader.join(500L);
        outReader.interrupt();
        errReader.interrupt();
        this.out_ = outReader.getData();
        this.err_ = errReader.getData();
        return status;
    }

    public String toString() {
        return this.getLine();
    }

    public static Executor createExecutor(final String line) {
        return new Executor(){

            public Process getProcess() throws IOException {
                return Runtime.getRuntime().exec(line);
            }

            public String getLine() {
                return line;
            }
        };
    }

    public static Executor createExecutor(final String[] argv) {
        return new Executor(){

            public Process getProcess() throws IOException {
                return Runtime.getRuntime().exec(argv);
            }

            public String getLine() {
                StringBuffer sbuf = new StringBuffer();
                int i = 0;
                while (i < argv.length) {
                    if (i > 0) {
                        sbuf.append(' ');
                    }
                    sbuf.append(argv[i]);
                    ++i;
                }
                return sbuf.toString();
            }
        };
    }

    private static class ReaderThread
    extends Thread {
        final InputStream strm_;
        final StringBuffer buf_;

        ReaderThread(InputStream strm) {
            this.strm_ = strm;
            this.buf_ = new StringBuffer();
        }

        public String getData() {
            return this.buf_.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block10: {
                if (true) ** GOTO lbl7
                do {
                    this.buf_.append((char)var1_1);
lbl7:
                    // 2 sources

                    c = this.strm_.read();
                    if (c < 0) break;
                } while (!this.isInterrupted());
                var3_3 = null;
                try {
                    this.strm_.close();
                }
                catch (IOException e) {}
                break block10;
                {
                    catch (IOException e) {
                        var3_4 = null;
                        try {
                            this.strm_.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (Throwable var2_9) {
                    var3_5 = null;
                    try {
                        this.strm_.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var2_9;
                }
            }
        }
    }
}

