/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.join.MatchSpec;
import uk.ac.starlink.topcat.join.TupleSelector;

public class IntraMatchSpec
extends MatchSpec {
    private final TupleSelector tupleSelector;
    private final JSpinner widthSelector;
    private final MatchEngine engine;
    private StarTable result;
    private int matchCount;
    private static final Logger logger;
    private static final String IDENTIFY = "Mark Groups of Rows";
    private static final String ELIMINATE_0 = "Eliminate All Grouped Rows";
    private static final String ELIMINATE_1 = "Eliminate All But First of Each Group";
    private static final String WIDE = "New Table With Groups of Size ";
    private static final String[] OPTIONS;
    private String option;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$join$IntraMatchSpec;

    public IntraMatchSpec(MatchEngine engine) {
        this.engine = engine;
        Box main = Box.createVerticalBox();
        this.add(main);
        this.tupleSelector = new TupleSelector(engine);
        this.tupleSelector.setBorder(AuxWindow.makeTitledBorder("Table"));
        main.add(this.tupleSelector);
        SpinnerNumberModel widthModel = new SpinnerNumberModel();
        widthModel.setValue(new Integer(2));
        widthModel.setMinimum(new Integer(2));
        this.widthSelector = new JSpinner(widthModel);
        Box actBox = Box.createVerticalBox();
        ButtonGroup buttGrp = new ButtonGroup();
        int i = 0;
        while (i < OPTIONS.length) {
            final String opt = OPTIONS[i];
            AbstractAction buttAct = new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    IntraMatchSpec.this.option = opt;
                    IntraMatchSpec.this.widthSelector.setEnabled(opt == IntraMatchSpec.WIDE);
                }
            };
            JRadioButton butt = new JRadioButton(buttAct);
            buttGrp.add(butt);
            Box line = Box.createHorizontalBox();
            line.add(butt);
            line.add(new JLabel(" " + opt));
            if (opt.equals(WIDE)) {
                line.add(this.widthSelector);
            }
            line.add(Box.createHorizontalGlue());
            actBox.add(line);
            if (i == 0) {
                butt.doClick();
            }
            ++i;
        }
        actBox.setBorder(AuxWindow.makeTitledBorder("Action"));
        main.add(actBox);
    }

    public void checkArguments() {
        this.tupleSelector.getEffectiveTable();
    }

    private String getOption() {
        return this.option;
    }

    private int getTableWideness() {
        return ((Number)this.widthSelector.getValue()).intValue();
    }

    public void calculate(ProgressIndicator indicator) throws IOException, InterruptedException {
        this.result = null;
        StarTable effTable = this.tupleSelector.getEffectiveTable();
        StarTable appTable = this.tupleSelector.getTable().getApparentStarTable();
        RowMatcher matcher = new RowMatcher(this.engine, new StarTable[]{effTable});
        matcher.setIndicator(indicator);
        LinkSet matches = matcher.findInternalMatches(false);
        if (!matches.sort()) {
            logger.warning("Can't sort matches - matched table rows may be in an unhelpful order");
        }
        this.matchCount = matches.size();
        this.result = this.matchCount == 0 ? null : this.makeResultTable(appTable, matches, this.option);
    }

    private StarTable makeResultTable(StarTable inTable, LinkSet matches, String option) {
        if (option.equals(IDENTIFY)) {
            long nrow = inTable.getRowCount();
            StarTable grpTable = MatchStarTables.makeInternalMatchTable((int)0, (LinkSet)matches, (long)nrow);
            JoinFixAction[] fixActs = new JoinFixAction[]{JoinFixAction.makeRenameDuplicatesAction((String)"_old"), JoinFixAction.NO_ACTION};
            return new JoinStarTable(new StarTable[]{inTable, grpTable}, fixActs);
        }
        if (option.equals(ELIMINATE_0) || option.equals(ELIMINATE_1)) {
            int i;
            int startFrom = option.equals(ELIMINATE_0) ? 0 : 1;
            BitSet bits = new BitSet();
            bits.set(0, IntraMatchSpec.checkedLongToInt(inTable.getRowCount()));
            Iterator it = matches.iterator();
            while (it.hasNext()) {
                RowLink link = (RowLink)it.next();
                int nref = link.size();
                if (!$assertionsDisabled && nref <= 1) {
                    throw new AssertionError();
                }
                i = startFrom;
                while (i < nref) {
                    RowRef ref = link.getRef(i);
                    if (!$assertionsDisabled && ref.getTableIndex() != 0) {
                        throw new AssertionError();
                    }
                    bits.clear(IntraMatchSpec.checkedLongToInt(ref.getRowIndex()));
                    ++i;
                }
            }
            int nbit = bits.cardinality();
            long[] rowMap = new long[nbit];
            i = 0;
            int ipos = bits.nextSetBit(0);
            while (ipos >= 0) {
                rowMap[i++] = ipos;
                ipos = bits.nextSetBit(ipos + 1);
            }
            if (!$assertionsDisabled && i != nbit) {
                throw new AssertionError();
            }
            return new RowPermutedStarTable(inTable, rowMap);
        }
        if (option.equals(WIDE)) {
            int width = this.getTableWideness();
            return MatchStarTables.makeParallelMatchTable((StarTable)inTable, (int)0, (LinkSet)matches, (int)width, (int)width, (int)width, (JoinFixAction[])this.getDefaultFixActions(width));
        }
        throw new AssertionError();
    }

    public void matchSuccess(Component parent) {
        String[] msg;
        String title = "Match Successful";
        int msgType = 1;
        if (this.result == null || this.result.getRowCount() == 0L) {
            msg = "No internal matches were found";
            title = "Match Failed";
            msgType = 2;
        } else {
            TopcatModel tcModel = ControlWindow.getInstance().addTable(this.result, "matched", true);
            msg = new String[]{this.matchCount + " match groups located", "New table created by match: " + tcModel};
            title = "Match Successful";
            msgType = 1;
        }
        JOptionPane.showMessageDialog(parent, msg, title, msgType);
    }

    private static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt((long)lval);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$join$IntraMatchSpec == null ? (class$uk$ac$starlink$topcat$join$IntraMatchSpec = IntraMatchSpec.class$("uk.ac.starlink.topcat.join.IntraMatchSpec")) : class$uk$ac$starlink$topcat$join$IntraMatchSpec).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.topcat.join");
        OPTIONS = new String[]{IDENTIFY, ELIMINATE_0, ELIMINATE_1, WIDE};
    }
}

