/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.join.ValueConverter;
import uk.ac.starlink.util.gui.ErrorDialog;

public class ParameterEditor
extends JComponent
implements ActionListener,
FocusListener {
    private final DescribedValue dval_;
    private final JTextField field_;
    private final JComboBox conversionChooser_;
    private final ValueConverter converter0_;

    public ParameterEditor(DescribedValue dval) {
        this.dval_ = dval;
        ValueInfo info = dval.getInfo();
        String descrip = info.getDescription();
        String units = info.getUnitString();
        this.field_ = new JTextField(16);
        if (descrip != null && descrip.trim().length() > 0) {
            this.field_.setToolTipText(descrip);
        }
        this.field_.addActionListener(this);
        this.field_.addFocusListener(this);
        ValueConverter[] converters = ValueConverter.getConverters(info);
        if (converters.length > 1) {
            this.converter0_ = null;
            this.conversionChooser_ = new JComboBox<ValueConverter>(converters);
            this.conversionChooser_.setSelectedIndex(0);
            this.conversionChooser_.addActionListener(this);
            this.conversionChooser_.setToolTipText("Units for " + info.getName());
        } else {
            this.conversionChooser_ = null;
            this.converter0_ = converters[0];
        }
        this.field_.setText(this.getConverter().formatValue(this.dval_.getValue(), 16));
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.field_);
        if (this.conversionChooser_ != null) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.conversionChooser_);
        } else if (units != null && units.trim().length() > 0) {
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(" (" + units.trim() + ")"));
        }
    }

    private ValueConverter getConverter() {
        if (this.converter0_ != null) {
            return this.converter0_;
        }
        return (ValueConverter)this.conversionChooser_.getSelectedItem();
    }

    private void updateValue() {
        ValueConverter converter = this.getConverter();
        String text = this.field_.getText();
        try {
            this.dval_.setValue(converter.unformatString(text));
        }
        catch (RuntimeException e) {
            this.field_.setText(converter.formatValue(this.dval_.getValue(), 16));
            String msg = "Illegal value \"" + text + "\" for parameter " + this.dval_.getInfo();
            ErrorDialog.showError((Component)this, (String)"Value Error", (Throwable)e, (String)msg);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    public void focusGained(FocusEvent evt) {
        this.updateValue();
    }

    public void focusLost(FocusEvent evt) {
        this.updateValue();
    }
}

