/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import uk.ac.starlink.table.ValueInfo;

public abstract class ValueConverter {
    static /* synthetic */ Class class$java$lang$Number;

    public abstract Object unformatString(String var1);

    public abstract String formatValue(Object var1, int var2);

    public static ValueConverter[] getConverters(ValueInfo info) {
        Class clazz;
        String units = info.getUnitString();
        if ((class$java$lang$Number == null ? (class$java$lang$Number = ValueConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz = info.getContentClass()) && units != null && (units.equalsIgnoreCase("radian") || units.equalsIgnoreCase("radians"))) {
            return new ValueConverter[]{new FactorConverter(info, "arcsec", 4.84813681109536E-6), new FactorConverter(info, "arcmin", 2.908882086657216E-4), new FactorConverter(info, "degree", Math.PI / 180), new FactorConverter(info, "radian", 1.0)};
        }
        return new ValueConverter[]{new UnitConverter(info)};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FactorConverter
    extends ValueConverter {
        private final ValueInfo info_;
        private final String name_;
        private final double factor_;
        private final double rotcaf_;

        public FactorConverter(ValueInfo info, String name, double factor) {
            this.info_ = info;
            this.name_ = name;
            this.factor_ = factor;
            this.rotcaf_ = 1.0 / factor;
        }

        public Object unformatString(String text) {
            return FactorConverter.multiplyObject(this.info_.unformatString(text), this.factor_);
        }

        public String formatValue(Object value, int maxLength) {
            return this.info_.formatValue(FactorConverter.multiplyObject(value, this.rotcaf_), maxLength);
        }

        public String toString() {
            return this.name_;
        }

        private static Object multiplyObject(Object value, double factor) {
            if (value instanceof Number) {
                double dval = ((Number)value).doubleValue() * factor;
                if (value instanceof Float) {
                    return new Float((float)dval);
                }
                return new Double(dval);
            }
            return value;
        }
    }

    private static class UnitConverter
    extends ValueConverter {
        private final ValueInfo info_;

        public UnitConverter(ValueInfo info) {
            this.info_ = info;
        }

        public Object unformatString(String text) {
            return this.info_.unformatString(text);
        }

        public String formatValue(Object value, int maxLength) {
            return this.info_.formatValue(value, maxLength);
        }
    }
}

