/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;

public abstract class MarkStyle {
    private Color color_;

    protected MarkStyle() {
        this(Color.BLACK);
    }

    protected MarkStyle(Color color) {
        this.color_ = color;
    }

    protected abstract void drawShape(Graphics var1);

    public abstract int getMaximumRadius();

    protected void drawLegendShape(Graphics g) {
        this.drawShape(g);
    }

    public void drawMarker(Graphics g, int x, int y) {
        Color col = g.getColor();
        g.setColor(this.color_);
        g.translate(x, y);
        this.drawShape(g);
        g.translate(-x, -y);
        g.setColor(col);
    }

    public void drawLegendMarker(Graphics g, int x, int y) {
        Color col = g.getColor();
        g.setColor(this.color_);
        g.translate(x, y);
        this.drawLegendShape(g);
        g.translate(-x, -y);
        g.setColor(col);
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public Icon getIcon(final int width, final int height) {
        return new Icon(){

            public int getIconHeight() {
                return height;
            }

            public int getIconWidth() {
                return width;
            }

            public void paintIcon(Component c, Graphics g, int xoff, int yoff) {
                int x = xoff + width / 2;
                int y = yoff + height / 2;
                MarkStyle.this.drawMarker(g, x, y);
            }
        };
    }

    public boolean equals(Object o) {
        if (o instanceof MarkStyle) {
            MarkStyle other = (MarkStyle)o;
            return this.getClass().equals(other.getClass()) && this.color_.equals(other.color_);
        }
        return false;
    }

    public int hashCode() {
        int code = 5;
        code = code * 23 + this.getClass().hashCode();
        code = code * 23 + this.color_.hashCode();
        return code;
    }

    private static int getMaxRadius(Shape shape) {
        Rectangle rect = shape.getBounds();
        int[] bounds = new int[]{rect.x, rect.x + rect.width, rect.y, rect.y + rect.height};
        int maxr = 1;
        int i = 0;
        while (i < bounds.length) {
            maxr = Math.max(maxr, Math.abs(bounds[i]));
            ++i;
        }
        return maxr;
    }

    public static MarkStyle openCircleStyle(Color color, int size) {
        final int off = -size;
        final int diam = size * 2;
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                g.drawOval(off, off, diam, diam);
            }
        };
    }

    public static MarkStyle filledCircleStyle(Color color, int size) {
        final int off = -size;
        final int diam = size * 2;
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                g.fillOval(off, off, diam, diam);
                g.drawOval(off, off, diam, diam);
            }
        };
    }

    public static MarkStyle openSquareStyle(Color color, int size) {
        final int off = -size;
        final int height = size * 2;
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                g.drawRect(off, off, height, height);
            }
        };
    }

    public static MarkStyle filledSquareStyle(Color color, int size) {
        final int off = -size;
        final int height = size * 2 + 1;
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                g.fillRect(off, off, height, height);
            }
        };
    }

    public static MarkStyle crossStyle(Color color, int size) {
        final int off = size;
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                g.drawLine(-off, 0, off, 0);
                g.drawLine(0, -off, 0, off);
            }
        };
    }

    public static MarkStyle xStyle(Color color, int size) {
        final int off = size;
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                g.drawLine(-off, -off, off, off);
                g.drawLine(off, -off, -off, off);
            }
        };
    }

    public static MarkStyle openDiamondStyle(Color color, int size) {
        return MarkStyle.openShapeStyle(color, MarkStyle.diamond(size));
    }

    public static MarkStyle filledDiamondStyle(Color color, final int size) {
        final int off = size;
        final Shape di = MarkStyle.diamond(size);
        return new ConvenienceMarkStyle(color, new Integer(size), size + 1){

            protected void drawShape(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.fill(di);
                    g2.draw(di);
                } else {
                    g.drawRect(-off, -off, size * 2, size * 2);
                }
            }
        };
    }

    public static MarkStyle openTriangleStyle(Color color, int size, boolean up) {
        return MarkStyle.openShapeStyle(color, MarkStyle.triangle(size, up));
    }

    public static MarkStyle filledTriangleStyle(Color color, int size, boolean up) {
        return MarkStyle.filledShapeStyle(color, MarkStyle.triangle(size, up));
    }

    public static MarkStyle openShapeStyle(Color color, final Shape shape) {
        return new ConvenienceMarkStyle(color, shape, MarkStyle.getMaxRadius(shape)){

            protected void drawShape(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.draw(shape);
                } else {
                    g.drawRect(-1, -1, 2, 2);
                }
            }
        };
    }

    public static MarkStyle filledShapeStyle(Color color, final Shape shape) {
        return new ConvenienceMarkStyle(color, shape, MarkStyle.getMaxRadius(shape)){

            protected void drawShape(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.fill(shape);
                } else {
                    g.fillRect(-1, -1, 2, 2);
                }
            }
        };
    }

    public static MarkStyle pointStyle(Color color) {
        return new ConvenienceMarkStyle(color, new Integer(23), 1){

            protected void drawShape(Graphics g) {
                g.drawLine(0, 0, 0, 0);
            }

            protected void drawLegendShape(Graphics g) {
                g.fillOval(-1, -1, 2, 2);
                g.drawOval(-1, -1, 2, 2);
            }
        };
    }

    public static MarkStyle compositeMarkStyle(final MarkStyle normalStyle, final MarkStyle legendStyle) {
        return new MarkStyle(){

            public void drawMarker(Graphics g, int x, int y) {
                normalStyle.drawMarker(g, x, y);
            }

            public void drawLegendMarker(Graphics g, int x, int y) {
                legendStyle.drawLegendMarker(g, x, y);
            }

            protected void drawShape(Graphics g) {
                normalStyle.drawShape(g);
            }

            protected void drawLegendShape(Graphics g) {
                legendStyle.drawLegendShape(g);
            }

            public int getMaximumRadius() {
                return Math.max(normalStyle.getMaximumRadius(), legendStyle.getMaximumRadius());
            }
        };
    }

    private static Shape diamond(int size) {
        return new Polygon(new int[]{-size, 0, size, 0}, new int[]{0, -size, 0, size}, 4);
    }

    private static Shape triangle(int size, boolean up) {
        double scale = (double)size * 1.5;
        int c = (int)Math.round(scale * Math.sqrt(3.0) / 2.0);
        int s = (int)Math.round(scale * 0.5);
        int r = (int)Math.round(scale);
        return up ? new Polygon(new int[]{-c, 0, c}, new int[]{-s, r, -s}, 3) : new Polygon(new int[]{-c, 0, c}, new int[]{s, -r, s}, 3);
    }

    private static abstract class ConvenienceMarkStyle
    extends MarkStyle {
        final Object otherAtts_;
        final int maxr_;

        ConvenienceMarkStyle(Color color, Object otherAtts, int maxr) {
            super(color);
            this.otherAtts_ = otherAtts;
            this.maxr_ = maxr;
        }

        public int getMaximumRadius() {
            return this.maxr_;
        }

        public boolean equals(Object o) {
            return super.equals(o) ? ((ConvenienceMarkStyle)o).otherAtts_.equals(this.otherAtts_) : false;
        }

        public int hashCode() {
            return super.hashCode() * 23 + this.otherAtts_.hashCode();
        }
    }
}

