/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.plot.MarkStyle;
import uk.ac.starlink.topcat.plot.PlotBox;
import uk.ac.starlink.topcat.plot.PlotState;
import uk.ac.starlink.topcat.plot.PlotSurface;
import uk.ac.starlink.topcat.plot.SurfaceListener;

public class PtPlotSurface
extends PlotBox
implements PlotSurface {
    private PlotState state_;
    private SurfaceListener surfListener_;
    private static int PAD_PIXELS = 10;

    public PtPlotSurface(SurfaceListener surfListener) {
        this.surfListener_ = surfListener;
        this.setColor(false);
        this._setPadding(0.0);
    }

    public void setState(PlotState state) {
        this.state_ = state;
        if (this.state_ != null) {
            this.configure(this.state_);
        }
    }

    public void setDataRange(double xlo, double ylo, double xhi, double yhi) {
        if (this._xlog) {
            xlo = xlo > 0.0 ? Math.log(xlo) * PlotBox._LOG10SCALE : 0.0;
            double d = xhi = xhi > 0.0 ? Math.log(xhi) * PlotBox._LOG10SCALE : 1.0;
        }
        if (this._ylog) {
            ylo = ylo > 0.0 ? Math.log(ylo) * PlotBox._LOG10SCALE : 0.0;
            double d = yhi = yhi > 0.0 ? Math.log(yhi) * PlotBox._LOG10SCALE : 1.0;
        }
        if (this._xflip) {
            double xl = -xhi;
            double xh = -xlo;
            xlo = xl;
            xhi = xh;
        }
        if (this._yflip) {
            double yl = -yhi;
            double yh = -ylo;
            ylo = yl;
            yhi = yh;
        }
        int width = this._lrx - this._ulx;
        int height = this._lry - this._uly;
        double xpad = (xhi - xlo) * (double)PAD_PIXELS / (double)width;
        double ypad = (yhi - ylo) * (double)PAD_PIXELS / (double)height;
        this.setXRange(xlo - xpad, xhi + xpad);
        this.setYRange(ylo - ypad, yhi + ypad);
        this.checkInvariants();
    }

    public Point dataToGraphics(double dx, double dy, boolean insideOnly) {
        if (Double.isNaN(dx) || Double.isInfinite(dx) || Double.isNaN(dy) || Double.isInfinite(dy)) {
            return null;
        }
        if (this._xlog) {
            if (dx > 0.0) {
                dx = Math.log(dx) * PlotBox._LOG10SCALE;
            } else {
                return null;
            }
        }
        if (this._ylog) {
            if (dy > 0.0) {
                dy = Math.log(dy) * PlotBox._LOG10SCALE;
            } else {
                return null;
            }
        }
        if (this._xflip) {
            dx = -dx;
        }
        if (this._yflip) {
            dy = -dy;
        }
        if (!insideOnly || dx >= this._xMin && dx <= this._xMax && dy >= this._yMin && dy <= this._yMax) {
            int px = this._ulx + (int)((dx - this._xMin) * this._xscale);
            int py = this._lry - (int)((dy - this._yMin) * this._yscale);
            return new Point(px, py);
        }
        return null;
    }

    public Shape getClip() {
        int width = this._lrx - this._ulx;
        int height = this._lry - this._uly;
        return new Rectangle(this._ulx, this._uly, width, height);
    }

    public JComponent getComponent() {
        return this;
    }

    public void paintSurface(Graphics g) {
        this.paintComponent(g);
    }

    protected void _zoom(int x, int y) {
        double oldXMin = this._xMin;
        double oldXMax = this._xMax;
        double oldYMin = this._yMin;
        double oldYMax = this._yMax;
        super._zoom(x, y);
        if (this._xMin != oldXMin || this._xMax != oldXMax || this._yMin != oldYMin || this._yMax != oldYMax) {
            this.checkInvariants();
            this.surfListener_.surfaceChanged();
        }
    }

    private void checkInvariants() {
        this._drawPlot(null, true);
    }

    protected void _drawPoint(Graphics g, int dataset, long xpos, long ypos, boolean clip) {
        this.state_.getStyles()[dataset].drawLegendMarker(g, (int)xpos, (int)ypos);
    }

    private void configure(PlotState state) {
        this.clearLegends();
        RowSubset[] rsets = state.getSubsets();
        MarkStyle[] styles = state.getStyles();
        int nrset = rsets.length;
        int iset = 0;
        while (iset < nrset) {
            this.addLegend(iset, rsets[iset].getName());
            ++iset;
        }
        ColumnInfo xCol = state.getXColumn().getColumnInfo();
        ColumnInfo yCol = state.getYColumn().getColumnInfo();
        String xName = xCol.getName();
        String yName = yCol.getName();
        String xUnit = xCol.getUnitString();
        String yUnit = yCol.getUnitString();
        String xLabel = xName;
        String yLabel = yName;
        if (xUnit != null && xUnit.trim().length() > 0) {
            xLabel = xLabel + " / " + xUnit;
        }
        if (yUnit != null && yUnit.trim().length() > 0) {
            yLabel = yLabel + " / " + yUnit;
        }
        this.setXLabel(xLabel);
        this.setYLabel(yLabel);
        this.setXLog(state.isXLog());
        this.setYLog(state.isYLog());
        this.setXFlip(state.isXFlip());
        this.setYFlip(state.isYFlip());
        this.setGrid(state.hasGrid());
        this.checkInvariants();
    }
}

