/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.soap;

import java.io.IOException;
import java.net.ConnectException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import uk.ac.starlink.soap.util.RemoteUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.votable.soap.VOTableSerialization;

public class TopcatSOAPClient {
    private String cookie_;
    private String endpoint_;

    public TopcatSOAPClient() throws ConnectException {
        Object[] tcServ = RemoteUtilities.readContactFile((String)"topcat");
        if (tcServ == null) {
            throw new ConnectException("No contact file for TOPCAT");
        }
        String host = (String)tcServ[0];
        int port = (Integer)tcServ[1];
        String cookie = (String)tcServ[2];
        this.init(host, port, cookie);
    }

    public TopcatSOAPClient(String host, int port, String cookie) {
        this.init(host, port, cookie);
    }

    private void init(String host, int port, String cookie) {
        this.cookie_ = cookie;
        this.endpoint_ = "http://" + host + ":" + port + "/services/TopcatSOAPServices";
    }

    private Call createTopcatCall() throws IOException {
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.endpoint_);
            return call;
        }
        catch (ServiceException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void displayTableByLocation(String location, String handler) throws IOException {
        Call call = this.createTopcatCall();
        call.setOperationName("displayTableByLocation");
        call.addParameter("cookie", XMLType.SOAP_STRING, ParameterMode.IN);
        call.addParameter("location", XMLType.SOAP_STRING, ParameterMode.IN);
        call.addParameter("handler", XMLType.SOAP_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{this.cookie_, location, handler});
    }

    public void displayTable(StarTable table, String location) throws IOException {
        Call call = this.createTopcatCall();
        VOTableSerialization.configureCall((Call)call);
        call.setOperationName("displayTable");
        call.addParameter("cookie", XMLType.SOAP_STRING, ParameterMode.IN);
        call.addParameter("table", VOTableSerialization.QNAME_VOTABLE, ParameterMode.IN);
        call.addParameter("location", XMLType.SOAP_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{this.cookie_, table, location});
    }
}

