/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

public class Range {
    protected double lower;
    protected double upper;

    public Range(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException("Range(double, double): require lower<=upper.");
        }
        this.lower = d;
        this.upper = d2;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double d) {
        return d >= this.lower && d <= this.upper;
    }

    public static Range combine(Range range, Range range2) {
        Range range3 = null;
        if (range != null && range2 == null) {
            range3 = range;
        } else if (range == null && range2 != null) {
            range3 = range2;
        } else {
            double d = Math.min(range.getLowerBound(), range2.getLowerBound());
            double d2 = Math.max(range.getUpperBound(), range2.getUpperBound());
            range3 = new Range(d, d2);
        }
        return range3;
    }
}

