/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimeSeriesDataPair;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class TimeSeriesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    protected List data = new ArrayList();
    protected Calendar workingCalendar;
    protected int position;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimeSeriesCollection(BasicTimeSeries basicTimeSeries) {
        this(basicTimeSeries, TimeZone.getDefault());
    }

    public TimeSeriesCollection(BasicTimeSeries basicTimeSeries, TimeZone timeZone) {
        if (basicTimeSeries != null) {
            this.data.add(basicTimeSeries);
            basicTimeSeries.addChangeListener(this);
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.position = 0;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public BasicTimeSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimeSeriesDataset.getSeries(...): index outside valid range.");
        }
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        return basicTimeSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public void addSeries(BasicTimeSeries basicTimeSeries) {
        if (basicTimeSeries == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.add(basicTimeSeries);
        basicTimeSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        TimePeriod timePeriod = timeSeriesDataPair.getPeriod();
        long l = 0L;
        switch (this.position) {
            case 0: {
                l = timePeriod.getStart(this.workingCalendar);
                break;
            }
            case 1: {
                l = timePeriod.getMiddle(this.workingCalendar);
                break;
            }
            case 2: {
                l = timePeriod.getEnd(this.workingCalendar);
                break;
            }
            default: {
                l = timePeriod.getMiddle(this.workingCalendar);
            }
        }
        return new Long(l);
    }

    public Number getStartXValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getStart(this.workingCalendar));
    }

    public Number getEndXValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getEnd(this.workingCalendar));
    }

    public Number getYValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return timeSeriesDataPair.getValue();
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }
}

