/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image;

import java.io.IOException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class ImageTiler {
    RandomAccess f;
    long fileOffset;
    int[] dims;
    Class base;

    public ImageTiler(RandomAccess f, long fileOffset, int[] dims, Class base) {
        this.f = f;
        this.fileOffset = fileOffset;
        this.dims = dims;
        this.base = base;
    }

    public Object getMemoryImage() {
        return null;
    }

    public Object getTile(int[] corners, int[] lengths) throws IOException {
        if (corners.length != this.dims.length || lengths.length != this.dims.length) {
            throw new IOException("Inconsistent sub-image request");
        }
        int arraySize = 1;
        int i = 0;
        while (i < this.dims.length) {
            if (corners[i] < 0 || lengths[i] < 0 || corners[i] + lengths[i] > this.dims[i]) {
                throw new IOException("Sub-image not within image");
            }
            arraySize *= lengths[i];
            ++i;
        }
        Object outArray = ArrayFuncs.newInstance(this.base, arraySize);
        this.getTile(outArray, corners, lengths);
        return outArray;
    }

    public void getTile(Object outArray, int[] corners, int[] lengths) throws IOException {
        Object data = this.getMemoryImage();
        if (data == null && this.f == null) {
            throw new IOException("No data source for tile subset");
        }
        this.fillTile(data, outArray, this.dims, corners, lengths);
    }

    protected void fillTile(Object data, Object o, int[] dims, int[] corners, int[] lengths) throws IOException {
        int n = dims.length;
        int[] posits = new int[n];
        int baseLength = ArrayFuncs.getBaseLength(o);
        int segment = lengths[n - 1];
        System.arraycopy(corners, 0, posits, 0, n);
        long currentOffset = 0L;
        if (data == null) {
            currentOffset = this.f.getFilePointer();
        }
        int outputOffset = 0;
        do {
            int mx;
            boolean validSegment;
            boolean bl = validSegment = posits[mx = dims.length - 1] + lengths[mx] >= 0 && posits[mx] < dims[mx];
            if (validSegment) {
                int i = 0;
                while (i < mx) {
                    if (posits[i] < 0 || posits[i] >= dims[i]) {
                        validSegment = false;
                        break;
                    }
                    ++i;
                }
            }
            if (validSegment) {
                if (data != null) {
                    this.fillMemData(data, posits, segment, o, outputOffset, 0);
                } else {
                    int offset = ImageTiler.getOffset(dims, posits) * baseLength;
                    int actualLen = segment;
                    int actualOffset = offset;
                    int actualOutput = outputOffset;
                    if (posits[mx] < 0) {
                        actualOffset -= posits[mx] * baseLength;
                        actualOutput -= posits[mx];
                        actualLen += posits[mx];
                    }
                    if (posits[mx] + segment > dims[mx]) {
                        actualLen -= posits[mx] + segment - dims[mx];
                    }
                    this.fillFileData(o, actualOffset, actualOutput, actualLen);
                }
            }
            outputOffset += segment;
        } while (ImageTiler.incrementPosition(corners, posits, lengths));
        if (data == null) {
            this.f.seek(currentOffset);
        }
    }

    protected void fillMemData(Object data, int[] posits, int length, Object output, int outputOffset, int dim) {
        if (data instanceof Object[]) {
            Object[] xo = (Object[])data;
            this.fillMemData(xo[posits[dim]], posits, length, output, outputOffset, dim + 1);
        } else {
            int startFrom = posits[dim];
            int startTo = outputOffset;
            int copyLength = length;
            if (posits[dim] < 0) {
                startFrom -= posits[dim];
                startTo -= posits[dim];
                copyLength += posits[dim];
            }
            if (posits[dim] + length > this.dims[dim]) {
                copyLength -= posits[dim] + length - this.dims[dim];
            }
            System.arraycopy(data, startFrom, output, startTo, copyLength);
        }
    }

    protected void fillFileData(Object output, int delta, int outputOffset, int segment) throws IOException {
        this.f.seek(this.fileOffset + (long)delta);
        if (this.base == Float.TYPE) {
            this.f.read((float[])output, outputOffset, segment);
        } else if (this.base == Integer.TYPE) {
            this.f.read((int[])output, outputOffset, segment);
        } else if (this.base == Short.TYPE) {
            this.f.read((short[])output, outputOffset, segment);
        } else if (this.base == Double.TYPE) {
            this.f.read((double[])output, outputOffset, segment);
        } else if (this.base == Byte.TYPE) {
            this.f.read((byte[])output, outputOffset, segment);
        } else if (this.base == Character.TYPE) {
            this.f.read((char[])output, outputOffset, segment);
        } else if (this.base == Long.TYPE) {
            this.f.read((long[])output, outputOffset, segment);
        } else {
            throw new IOException("Invalid type for tile array");
        }
    }

    protected static boolean incrementPosition(int[] start, int[] current, int[] lengths) {
        int i = start.length - 2;
        while (i >= 0) {
            if (current[i] - start[i] < lengths[i] - 1) {
                int n = i;
                current[n] = current[n] + 1;
                int j = i + 1;
                while (j < start.length - 1) {
                    current[j] = start[j];
                    ++j;
                }
                return true;
            }
            --i;
        }
        return false;
    }

    public static final int getOffset(int[] dims, int[] pos) {
        int offset = 0;
        int i = 0;
        while (i < dims.length) {
            if (i > 0) {
                offset *= dims[i];
            }
            offset += pos[i];
            ++i;
        }
        return offset;
    }

    public Object getCompleteImage() throws IOException {
        if (this.f == null) {
            throw new IOException("Attempt to read from null file");
        }
        long currentOffset = this.f.getFilePointer();
        Object o = ArrayFuncs.newInstance(this.base, this.dims);
        this.f.seek(this.fileOffset);
        this.f.readArray(o);
        this.f.seek(currentOffset);
        return o;
    }
}

