/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import nom.tam.util.PrimitiveInfo;

public class ArrayFuncs
implements PrimitiveInfo {
    public static int computeSize(Object o) {
        if (o == null) {
            return 0;
        }
        int size = 0;
        String classname = o.getClass().getName();
        if (classname.substring(0, 2).equals("[[") || classname.equals("[Ljava.lang.String;") || classname.equals("[Ljava.lang.Object;")) {
            int i = 0;
            while (i < ((Object[])o).length) {
                size += ArrayFuncs.computeSize(((Object[])o)[i]);
                ++i;
            }
            return size;
        }
        if (classname.charAt(0) == '[' && classname.charAt(1) != 'L') {
            char c = classname.charAt(1);
            int i = 0;
            while (i < PrimitiveInfo.suffixes.length) {
                if (c == PrimitiveInfo.suffixes[i]) {
                    return Array.getLength(o) * PrimitiveInfo.sizes[i];
                }
                ++i;
            }
            return 0;
        }
        if (classname.substring(0, 10).equals("java.lang.")) {
            if ((classname = classname.substring(10, classname.length() - 1)).equals("Int") || classname.equals("Float")) {
                return 4;
            }
            if (classname.equals("Double") || classname.equals("Long")) {
                return 8;
            }
            if (classname.equals("Short") || classname.equals("Char")) {
                return 2;
            }
            if (classname.equals("Byte") || classname.equals("Boolean")) {
                return 1;
            }
            if (classname.equals("String")) {
                return ((String)o).length();
            }
            return 0;
        }
        return 0;
    }

    public static int nElements(Object o) {
        String classname = o.getClass().getName();
        if (classname.charAt(1) == '[') {
            int count = 0;
            int i = 0;
            while (i < ((Object[])o).length) {
                count += ArrayFuncs.nElements(((Object[])o)[i]);
                ++i;
            }
            return count;
        }
        if (classname.charAt(0) == '[') {
            return Array.getLength(o);
        }
        return 1;
    }

    public static Object deepClone(Object o) {
        Class<?> baseClass;
        if (o == null) {
            return null;
        }
        String classname = o.getClass().getName();
        if (classname.charAt(0) != '[') {
            return ArrayFuncs.genericClone(o);
        }
        if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
            try {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return ((byte[])o).clone();
                    }
                    case 'Z': {
                        return ((boolean[])o).clone();
                    }
                    case 'C': {
                        return ((char[])o).clone();
                    }
                    case 'S': {
                        return ((short[])o).clone();
                    }
                    case 'I': {
                        return ((int[])o).clone();
                    }
                    case 'J': {
                        return ((long[])o).clone();
                    }
                    case 'F': {
                        return ((float[])o).clone();
                    }
                    case 'D': {
                        return ((double[])o).clone();
                    }
                }
                System.err.println("Unknown primtive array class:" + classname);
                return null;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        int ndim = 1;
        while (classname.charAt(ndim) == '[') {
            ++ndim;
        }
        if (classname.charAt(ndim) != 'L') {
            baseClass = ArrayFuncs.getBaseClass(o);
        } else {
            try {
                baseClass = Class.forName(classname.substring(ndim + 1, classname.length() - 1), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                System.err.println("Internal error: class definition inconsistency: " + classname);
                return null;
            }
        }
        int[] dims = new int[ndim];
        dims[0] = Array.getLength(o);
        int i = 1;
        while (i < ndim) {
            dims[i] = 0;
            ++i;
        }
        Object copy = ArrayFuncs.newInstance(baseClass, dims);
        int i2 = 0;
        while (i2 < dims[0]) {
            Array.set(copy, i2, ArrayFuncs.deepClone(Array.get(o, i2)));
            ++i2;
        }
        return copy;
    }

    public static Object genericClone(Object o) {
        if (!(o instanceof Cloneable)) {
            return null;
        }
        Class[] argTypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            return o.getClass().getMethod("clone", argTypes).invoke(o, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyArray(Object original, Object copy) {
        String cname;
        String oname = original.getClass().getName();
        if (!oname.equals(cname = copy.getClass().getName())) {
            return;
        }
        if (oname.charAt(0) != '[') {
            return;
        }
        if (oname.charAt(1) == '[') {
            Object[] x = (Object[])original;
            Object[] y = (Object[])copy;
            if (x.length != y.length) {
                return;
            }
            int i = 0;
            while (i < x.length) {
                ArrayFuncs.copyArray(x, y);
                ++i;
            }
        }
        int len = Array.getLength(original);
        System.arraycopy(original, 0, copy, 0, len);
    }

    public static int[] getDimensions(Object o) {
        if (o == null) {
            return null;
        }
        String classname = o.getClass().getName();
        int ndim = 0;
        while (classname.charAt(ndim) == '[') {
            ++ndim;
        }
        int[] dimens = new int[ndim];
        int i = 0;
        while (i < ndim) {
            dimens[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < ndim) {
            dimens[i2] = Array.getLength(o);
            if (dimens[i2] == 0) {
                return dimens;
            }
            if (i2 != ndim - 1 && (o = ((Object[])o)[0]) == null) {
                return dimens;
            }
            ++i2;
        }
        return dimens;
    }

    public static Object getBaseArray(Object o) {
        String cname = o.getClass().getName();
        if (cname.charAt(1) == '[') {
            return ArrayFuncs.getBaseArray(((Object[])o)[0]);
        }
        return o;
    }

    public static Class getBaseClass(Object o) {
        if (o == null) {
            return Void.TYPE;
        }
        String className = o.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return o.getClass();
        }
        char c = className.charAt(dims);
        int i = 0;
        while (i < PrimitiveInfo.suffixes.length) {
            if (c == PrimitiveInfo.suffixes[i]) {
                return PrimitiveInfo.classes[i];
            }
            ++i;
        }
        if (c == 'L') {
            try {
                return Class.forName(className.substring(dims + 1, className.length() - 1), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static int getBaseLength(Object o) {
        if (o == null) {
            return 0;
        }
        String className = o.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return -1;
        }
        char c = className.charAt(dims);
        int i = 0;
        while (i < PrimitiveInfo.suffixes.length) {
            if (c == PrimitiveInfo.suffixes[i]) {
                return PrimitiveInfo.sizes[i];
            }
            ++i;
        }
        return -1;
    }

    public static Object generateArray(Class baseType, int[] dims) {
        Object x = ArrayFuncs.newInstance(baseType, dims);
        ArrayFuncs.testPattern(x, (byte)0);
        return x;
    }

    public static byte testPattern(Object o, byte start) {
        block3: {
            int[] dims;
            block2: {
                dims = ArrayFuncs.getDimensions(o);
                if (dims.length <= 1) break block2;
                int i = 0;
                while (i < ((Object[])o).length) {
                    start = ArrayFuncs.testPattern(((Object[])o)[i], start);
                    ++i;
                }
                break block3;
            }
            if (dims.length != 1) break block3;
            int i = 0;
            while (i < dims[0]) {
                Array.setByte(o, i, start);
                start = (byte)(start + 1);
                ++i;
            }
        }
        return start;
    }

    public static String arrayDescription(Object o) {
        Class base = ArrayFuncs.getBaseClass(o);
        if (base == Void.TYPE) {
            return "NULL";
        }
        int[] dims = ArrayFuncs.getDimensions(o);
        StringBuffer desc = new StringBuffer();
        boolean found = false;
        int i = 0;
        while (i < PrimitiveInfo.classes.length) {
            if (base == PrimitiveInfo.classes[i]) {
                found = true;
                desc.append(PrimitiveInfo.types[i]);
                break;
            }
            ++i;
        }
        if (!found) {
            desc.append(base.getName());
        }
        if (dims != null) {
            desc.append("[");
            int i2 = 0;
            while (i2 < dims.length) {
                desc.append("" + dims[i2]);
                if (i2 < dims.length - 1) {
                    desc.append("][");
                }
                ++i2;
            }
            desc.append("]");
        }
        return new String(desc);
    }

    public static void examinePrimitiveArray(Object o) {
        String className = o.getClass().getName();
        if (className.substring(0, 2).equals("[[") || className.equals("[Ljava.lang.Object;")) {
            System.out.println("[");
            int i = 0;
            while (i < ((Object[])o).length) {
                ArrayFuncs.examinePrimitiveArray(((Object[])o)[i]);
                ++i;
            }
            System.out.print("]");
        } else if (className.charAt(0) != '[') {
            System.out.println(className);
        } else {
            System.out.println("[" + Array.getLength(o) + "]" + className.substring(1));
        }
    }

    public static Object flatten(Object input) {
        int[] dimens = ArrayFuncs.getDimensions(input);
        if (dimens.length <= 1) {
            return input;
        }
        int size = 1;
        int i = 0;
        while (i < dimens.length) {
            size *= dimens[i];
            ++i;
        }
        Object flat = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(input), size);
        if (size == 0) {
            return flat;
        }
        int offset = 0;
        ArrayFuncs.doFlatten(input, flat, offset);
        return flat;
    }

    protected static int doFlatten(Object input, Object output, int offset) {
        String classname = input.getClass().getName();
        if (classname.charAt(0) != '[') {
            throw new RuntimeException("Attempt to flatten non-array");
        }
        int size = Array.getLength(input);
        if (classname.charAt(1) != '[') {
            System.arraycopy(input, 0, output, offset, size);
            return size;
        }
        int total = 0;
        Object[] xx = (Object[])input;
        int i = 0;
        while (i < size) {
            int len = ArrayFuncs.doFlatten(xx[i], output, offset + total);
            total += len;
            ++i;
        }
        return total;
    }

    public static Object curl(Object input, int[] dimens) {
        String classname = input.getClass().getName();
        if (classname.charAt(0) != '[' || classname.charAt(1) == '[') {
            throw new RuntimeException("Attempt to curl non-1D array");
        }
        int size = Array.getLength(input);
        int test = 1;
        int i = 0;
        while (i < dimens.length) {
            test *= dimens[i];
            ++i;
        }
        if (test != size) {
            throw new RuntimeException("Curled array does not fit desired dimensions");
        }
        Class base = ArrayFuncs.getBaseClass(input);
        Object newArray = ArrayFuncs.newInstance(base, dimens);
        int offset = 0;
        ArrayFuncs.doCurl(input, newArray, dimens, offset);
        return newArray;
    }

    protected static int doCurl(Object input, Object output, int[] dimens, int offset) {
        if (dimens.length == 1) {
            System.arraycopy(input, offset, output, 0, dimens[0]);
            return dimens[0];
        }
        int total = 0;
        int[] xdimens = new int[dimens.length - 1];
        int i = 1;
        while (i < dimens.length) {
            xdimens[i - 1] = dimens[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < dimens[0]) {
            total += ArrayFuncs.doCurl(input, ((Object[])output)[i2], xdimens, offset + total);
            ++i2;
        }
        return total;
    }

    public static Object mimicArray(Object array, Class newType) {
        Object mimic;
        String classname = array.getClass().getName();
        if (classname.charAt(0) != '[') {
            return null;
        }
        int dims = 1;
        while (classname.charAt(dims) == '[') {
            ++dims;
        }
        if (dims > 1) {
            Object[] xarray = (Object[])array;
            int[] dimens = new int[dims];
            dimens[0] = xarray.length;
            mimic = ArrayFuncs.newInstance(newType, dimens);
            int i = 0;
            while (i < xarray.length) {
                Object temp;
                ((Object[])mimic)[i] = temp = ArrayFuncs.mimicArray(xarray[i], newType);
                ++i;
            }
        } else {
            mimic = ArrayFuncs.newInstance(newType, Array.getLength(array));
        }
        return mimic;
    }

    public static Object convertArray(Object array, Class newType) {
        Object mimic = ArrayFuncs.mimicArray(array, newType);
        if (mimic == null) {
            return mimic;
        }
        ArrayFuncs.copyInto(array, mimic);
        return mimic;
    }

    public static void copyInto(Object array, Object mimic) {
        String classname = array.getClass().getName();
        if (classname.charAt(0) != '[') {
            return;
        }
        if (classname.charAt(1) == '[') {
            int i = 0;
            while (i < ((Object[])array).length) {
                ArrayFuncs.copyInto(((Object[])array)[i], ((Object[])mimic)[i]);
                ++i;
            }
        } else {
            Class base = ArrayFuncs.getBaseClass(array);
            Class newType = ArrayFuncs.getBaseClass(mimic);
            if (base == Byte.TYPE) {
                byte[] barr = (byte[])array;
                if (newType == Byte.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, barr.length);
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    int i = 0;
                    while (i < barr.length) {
                        xsarr[i] = barr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    int i = 0;
                    while (i < barr.length) {
                        xcarr[i] = (char)barr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    int i = 0;
                    while (i < barr.length) {
                        xiarr[i] = barr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    int i = 0;
                    while (i < barr.length) {
                        xlarr[i] = barr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    int i = 0;
                    while (i < barr.length) {
                        xfarr[i] = barr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    int i = 0;
                    while (i < barr.length) {
                        xdarr[i] = barr[i];
                        ++i;
                    }
                }
            } else if (base == Short.TYPE) {
                short[] sarr = (short[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    int i = 0;
                    while (i < sarr.length) {
                        xbarr[i] = (byte)sarr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, sarr.length);
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    int i = 0;
                    while (i < sarr.length) {
                        xcarr[i] = (char)sarr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    int i = 0;
                    while (i < sarr.length) {
                        xiarr[i] = sarr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    int i = 0;
                    while (i < sarr.length) {
                        xlarr[i] = sarr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    int i = 0;
                    while (i < sarr.length) {
                        xfarr[i] = sarr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    int i = 0;
                    while (i < sarr.length) {
                        xdarr[i] = sarr[i];
                        ++i;
                    }
                }
            } else if (base == Character.TYPE) {
                char[] carr = (char[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    int i = 0;
                    while (i < carr.length) {
                        xbarr[i] = (byte)carr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    int i = 0;
                    while (i < carr.length) {
                        xsarr[i] = (short)carr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, carr.length);
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    int i = 0;
                    while (i < carr.length) {
                        xiarr[i] = carr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    int i = 0;
                    while (i < carr.length) {
                        xlarr[i] = carr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    int i = 0;
                    while (i < carr.length) {
                        xfarr[i] = carr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    int i = 0;
                    while (i < carr.length) {
                        xdarr[i] = carr[i];
                        ++i;
                    }
                }
            } else if (base == Integer.TYPE) {
                int[] iarr = (int[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    int i = 0;
                    while (i < iarr.length) {
                        xbarr[i] = (byte)iarr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    int i = 0;
                    while (i < iarr.length) {
                        xsarr[i] = (short)iarr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    int i = 0;
                    while (i < iarr.length) {
                        xcarr[i] = (char)iarr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, iarr.length);
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    int i = 0;
                    while (i < iarr.length) {
                        xlarr[i] = iarr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    int i = 0;
                    while (i < iarr.length) {
                        xfarr[i] = iarr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    int i = 0;
                    while (i < iarr.length) {
                        xdarr[i] = iarr[i];
                        ++i;
                    }
                }
            } else if (base == Long.TYPE) {
                long[] larr = (long[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    int i = 0;
                    while (i < larr.length) {
                        xbarr[i] = (byte)larr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    int i = 0;
                    while (i < larr.length) {
                        xsarr[i] = (short)larr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    int i = 0;
                    while (i < larr.length) {
                        xcarr[i] = (char)larr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    int i = 0;
                    while (i < larr.length) {
                        xiarr[i] = (int)larr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, larr.length);
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    int i = 0;
                    while (i < larr.length) {
                        xfarr[i] = larr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    int i = 0;
                    while (i < larr.length) {
                        xdarr[i] = larr[i];
                        ++i;
                    }
                }
            } else if (base == Float.TYPE) {
                float[] farr = (float[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    int i = 0;
                    while (i < farr.length) {
                        xbarr[i] = (byte)farr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    int i = 0;
                    while (i < farr.length) {
                        xsarr[i] = (short)farr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    int i = 0;
                    while (i < farr.length) {
                        xcarr[i] = (char)farr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    int i = 0;
                    while (i < farr.length) {
                        xiarr[i] = (int)farr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    int i = 0;
                    while (i < farr.length) {
                        xlarr[i] = (long)farr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, farr.length);
                } else if (newType == Double.TYPE) {
                    double[] xdarr = (double[])mimic;
                    int i = 0;
                    while (i < farr.length) {
                        xdarr[i] = farr[i];
                        ++i;
                    }
                }
            } else if (base == Double.TYPE) {
                double[] darr = (double[])array;
                if (newType == Byte.TYPE) {
                    byte[] xbarr = (byte[])mimic;
                    int i = 0;
                    while (i < darr.length) {
                        xbarr[i] = (byte)darr[i];
                        ++i;
                    }
                } else if (newType == Short.TYPE) {
                    short[] xsarr = (short[])mimic;
                    int i = 0;
                    while (i < darr.length) {
                        xsarr[i] = (short)darr[i];
                        ++i;
                    }
                } else if (newType == Character.TYPE) {
                    char[] xcarr = (char[])mimic;
                    int i = 0;
                    while (i < darr.length) {
                        xcarr[i] = (char)darr[i];
                        ++i;
                    }
                } else if (newType == Integer.TYPE) {
                    int[] xiarr = (int[])mimic;
                    int i = 0;
                    while (i < darr.length) {
                        xiarr[i] = (int)darr[i];
                        ++i;
                    }
                } else if (newType == Long.TYPE) {
                    long[] xlarr = (long[])mimic;
                    int i = 0;
                    while (i < darr.length) {
                        xlarr[i] = (long)darr[i];
                        ++i;
                    }
                } else if (newType == Float.TYPE) {
                    float[] xfarr = (float[])mimic;
                    int i = 0;
                    while (i < darr.length) {
                        xfarr[i] = (float)darr[i];
                        ++i;
                    }
                } else if (newType == Double.TYPE) {
                    System.arraycopy(array, 0, mimic, 0, darr.length);
                }
            }
        }
    }

    public static Object newInstance(Class cl, int dim) {
        Object o = Array.newInstance(cl, dim);
        if (o == null) {
            String desc = cl + "[" + dim + "]";
            throw new OutOfMemoryError("Unable to allocate array: " + desc);
        }
        return o;
    }

    public static Object newInstance(Class cl, int[] dims) {
        Object o = Array.newInstance(cl, dims);
        if (o == null) {
            String desc = cl + "[";
            String comma = "";
            int i = 0;
            while (i < dims.length) {
                desc = desc + comma + dims[i];
                comma = ",";
                ++i;
            }
            desc = desc + "]";
            throw new OutOfMemoryError("Unable to allocate array: " + desc);
        }
        return o;
    }
}

