/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;
import nom.tam.util.HashedListElement;

public class HashedList
implements Collection {
    private HashMap hash = new HashMap();
    private HashedListElement first = null;
    private HashedListElement last = null;
    private int numElements = 0;

    public boolean add(Object reference) {
        this.add(null, null, reference);
        return true;
    }

    public boolean add(Object key, Object reference) {
        this.add(null, key, reference);
        return true;
    }

    HashedListElement add(HashedListElement pos, Object key, Object reference) {
        if (key != null) {
            this.remove((HashedListElement)this.hash.get(key));
        }
        HashedListElement e = new HashedListElement();
        e.key = key;
        e.reference = reference;
        if (pos == null) {
            e.prev = this.last;
            if (this.last != null) {
                this.last.next = e;
            } else {
                this.first = e;
            }
            this.last = e;
            e.next = null;
        } else if (pos.prev == null) {
            e.next = pos;
            e.prev = null;
            pos.prev = e;
            this.first = e;
        } else {
            e.next = pos;
            e.prev = pos.prev;
            pos.prev = e;
            e.prev.next = e;
        }
        ++this.numElements;
        if (key != null) {
            this.hash.put(key, e);
        }
        return e;
    }

    public boolean removeKey(Object key) {
        HashedListElement h = (HashedListElement)this.hash.get(key);
        if (h != null) {
            this.remove(h);
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(o)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    private void remove(HashedListElement e) {
        if (e == null) {
            return;
        }
        if (e.prev != null) {
            e.prev.next = e.next;
        } else {
            this.first = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        } else {
            this.last = e.prev;
        }
        if (e.key != null) {
            this.hash.remove(e.key);
        }
        --this.numElements;
    }

    public Iterator iterator() {
        return new HashedListIterator(this.first);
    }

    public HashedListIterator iterator(Object key) throws NoSuchElementException {
        return new HashedListIterator((HashedListElement)this.hash.get(key));
    }

    public HashedListIterator iterator(int n) throws NoSuchElementException {
        if (n == 0 && this.numElements == 0) {
            return new HashedListIterator(this.first);
        }
        HashedListElement e = this.getElement(n);
        HashedListIterator i = (HashedListIterator)this.iterator();
        i.setCurrent(e);
        return i;
    }

    public Object get(Object key) {
        if (!this.hash.containsKey(key)) {
            return null;
        }
        return ((HashedListElement)this.hash.get((Object)key)).reference;
    }

    public Object get(int n) throws NoSuchElementException {
        HashedListElement e = this.getElement(n);
        return e.reference;
    }

    public boolean replaceKey(Object oldKey, Object newKey) {
        if (!this.hash.containsKey(oldKey) || this.hash.containsKey(newKey)) {
            return false;
        }
        HashedListElement e = (HashedListElement)this.hash.get(oldKey);
        e.key = newKey;
        this.hash.remove(oldKey);
        this.hash.put(newKey, e);
        return true;
    }

    HashedListElement getElement(int n) throws NoSuchElementException {
        if (n < 0) {
            throw new NoSuchElementException("Invalid index");
        }
        HashedListElement current = this.first;
        while (n > 0 && current.next != null) {
            --n;
            current = current.next;
        }
        if (n > 0) {
            throw new NoSuchElementException("Index beyond end of list");
        }
        if (current == null) {
            throw new NoSuchElementException("Empty list");
        }
        return current;
    }

    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    public int size() {
        return this.numElements;
    }

    public boolean addAll(Collection c) {
        Object[] array = c.toArray();
        int i = 0;
        while (i < array.length) {
            this.add(array[i]);
            ++i;
        }
        return true;
    }

    public void clear() {
        this.numElements = 0;
        this.first = null;
        this.last = null;
        this.hash.clear();
    }

    public boolean contains(Object o) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Object[] o = c.toArray();
        int i = 0;
        while (i < o.length) {
            if (!this.contains(o[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.numElements == 0;
    }

    public boolean removeAll(Collection c) {
        Object[] o = c.toArray();
        boolean result = false;
        int i = 0;
        while (i < o.length) {
            result |= this.remove(o[i]);
            ++i;
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        Iterator iter = this.iterator();
        boolean result = false;
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public Object[] toArray() {
        Object[] o = new Object[this.numElements];
        return this.toArray(o);
    }

    public Object[] toArray(Object[] o) {
        if (Array.getLength(o) < this.numElements) {
            o = (Object[])ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(o), this.numElements);
        }
        Iterator iter = this.iterator();
        int p = 0;
        while (iter.hasNext()) {
            o[p] = iter.next();
            ++p;
        }
        if (o.length > this.numElements) {
            o[this.numElements] = null;
        }
        return o;
    }

    public class HashedListIterator
    implements Cursor {
        private HashedListElement current;
        private HashedListElement last;

        HashedListIterator(HashedListElement start) {
            this.current = start;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public boolean hasPrev() {
            if (this.current == null) {
                return this.last != null;
            }
            return this.current.prev != null;
        }

        public Object next() throws NoSuchElementException {
            if (this.current != null) {
                this.last = this.current;
                this.current = this.current.next;
                return this.last.reference;
            }
            throw new NoSuchElementException("Beyond end of list");
        }

        public Object prev() throws NoSuchElementException {
            this.last = null;
            if (this.current == null) {
                if (this.last == null) {
                    throw new NoSuchElementException("Empty list");
                }
                this.current = this.last;
                return this.current.reference;
            }
            if (this.current.prev == null) {
                throw new NoSuchElementException("Before beginning of list");
            }
            this.current = this.current.prev;
            return this.current.reference;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("Removed called in invalid iterator state");
            }
            HashedList.this.remove(this.last);
            this.last = null;
        }

        public void add(Object ref) {
            HashedListElement newObj = HashedList.this.add(this.current, null, ref);
            this.current = newObj.next;
        }

        public void add(Object key, Object ref) {
            HashedListElement newObj = HashedList.this.add(this.current, key, ref);
            this.current = newObj.next;
        }

        public void setKey(Object key) {
            if (HashedList.this.containsKey(key)) {
                this.setCurrent((HashedListElement)HashedList.this.hash.get(key));
            } else {
                this.current = null;
            }
        }

        void setCurrent(HashedListElement newPos) {
            this.current = newPos;
        }
    }
}

