/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstAxes
extends AbstractPlotControlsModel {
    protected boolean isXSet;
    protected boolean isYSet;
    protected boolean showX;
    protected boolean showY;
    protected boolean logX;
    protected boolean logY;
    protected boolean interior;
    protected double xLabelAt;
    protected double yLabelAt;
    protected Color xColour;
    protected Color yColour;
    protected int xStyle;
    protected int yStyle;
    protected double xWidth;
    protected double yWidth;
    public static int MIN_WIDTH = 1;
    public static int MAX_WIDTH = 20;

    public AstAxes() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.isXSet = true;
        this.isYSet = true;
        this.showX = true;
        this.showY = true;
        this.logX = false;
        this.logY = false;
        this.xLabelAt = DefaultGrf.BAD;
        this.yLabelAt = DefaultGrf.BAD;
        this.yColour = this.xColour = Color.black;
        this.xStyle = 1;
        this.yStyle = 1;
        this.xWidth = 1.0;
        this.yWidth = 1.0;
        this.interior = false;
        this.fireChanged();
    }

    public void setXState(boolean isXSet) {
        this.isXSet = isXSet;
    }

    public boolean getXState() {
        return this.isXSet;
    }

    public void setYState(boolean isYSet) {
        this.isYSet = isYSet;
    }

    public boolean getYState() {
        return this.isYSet;
    }

    public void setXShown(boolean showX) {
        this.showX = showX;
        this.setXState(true);
        this.fireChanged();
    }

    public boolean getXShown() {
        return this.showX;
    }

    public void setYShown(boolean showY) {
        this.showY = showY;
        this.setYState(true);
        this.fireChanged();
    }

    public boolean getYShown() {
        return this.showY;
    }

    public void setXLog(boolean logX) {
        this.logX = logX;
        this.setXState(true);
        this.fireChanged();
    }

    public boolean getXLog() {
        return this.logX;
    }

    public void setYLog(boolean logY) {
        this.logY = logY;
        this.setYState(true);
        this.fireChanged();
    }

    public boolean getYLog() {
        return this.logY;
    }

    public void setXLabelAt(double xLabelAt) {
        this.xLabelAt = xLabelAt;
        if (xLabelAt != DefaultGrf.BAD) {
            this.setXState(true);
        }
        this.fireChanged();
    }

    public double getXLabelAt() {
        return this.xLabelAt;
    }

    public void setYLabelAt(double yLabelAt) {
        this.yLabelAt = yLabelAt;
        if (yLabelAt != DefaultGrf.BAD) {
            this.setYState(true);
        }
        this.fireChanged();
    }

    public double getYLabelAt() {
        return this.yLabelAt;
    }

    public void setXColour(Color xColour) {
        this.xColour = xColour;
        if (xColour != null) {
            this.setXState(true);
        }
        this.fireChanged();
    }

    public Color getXColour() {
        return this.xColour;
    }

    public void setYColour(Color yColour) {
        this.yColour = yColour;
        if (yColour != null) {
            this.setYState(true);
        }
        this.fireChanged();
    }

    public Color getYColour() {
        return this.yColour;
    }

    public void setXWidth(double xWidth) {
        this.xWidth = xWidth;
        if (xWidth != DefaultGrf.BAD) {
            this.setXState(true);
        }
        this.fireChanged();
    }

    public double getXWidth() {
        return this.xWidth;
    }

    public void setYWidth(double yWidth) {
        this.yWidth = yWidth;
        if (yWidth != DefaultGrf.BAD) {
            this.setYState(true);
        }
        this.fireChanged();
    }

    public double getYWidth() {
        return this.yWidth;
    }

    public void setXStyle(int xStyle) {
        this.xStyle = xStyle;
        this.setXState(true);
        this.fireChanged();
    }

    public int getXStyle() {
        return this.xStyle;
    }

    public void setYStyle(int yStyle) {
        this.yStyle = yStyle;
        this.setYState(true);
        this.fireChanged();
    }

    public int getYStyle() {
        return this.yStyle;
    }

    public void setInterior(boolean interior) {
        this.interior = interior;
        this.fireChanged();
    }

    public boolean getInterior() {
        return this.interior;
    }

    public String getAstOptions() {
        int value;
        if (!this.isXSet && !this.isYSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.interior) {
            buffer.append("Labelling=interior");
        } else {
            buffer.append("Labelling=exterior");
        }
        if (this.isXSet) {
            if (this.showX) {
                buffer.append(",DrawAxes(1)=1");
                if (this.logX) {
                    buffer.append(",LogPlot(1)=1");
                }
                if (this.xColour != null) {
                    buffer.append(",Colour(axis1)=");
                    value = DefaultGrf.encodeColor(this.xColour);
                    buffer.append(value);
                }
                if (this.xWidth != DefaultGrf.BAD) {
                    buffer.append(",Width(axis1)=");
                    buffer.append(this.xWidth);
                }
                buffer.append(",Style(axis1)=");
                buffer.append(this.xStyle);
                if (this.xLabelAt != DefaultGrf.BAD) {
                    buffer.append(",LabelAt(1)=");
                    buffer.append(this.xLabelAt);
                }
            } else {
                buffer.append(",DrawAxes(1)=0");
            }
        }
        if (this.isYSet) {
            if (this.showY) {
                buffer.append(",DrawAxes(2)=1");
                if (this.logY) {
                    buffer.append(",LogPlot(2)=1");
                }
                if (this.yColour != null) {
                    buffer.append(",Colour(axis2)=");
                    value = DefaultGrf.encodeColor(this.yColour);
                    buffer.append(value);
                }
                if (this.yWidth != DefaultGrf.BAD) {
                    buffer.append(",Width(axis2)=");
                    buffer.append(this.yWidth);
                }
                buffer.append(",Style(axis2)=");
                buffer.append(this.yStyle);
                if (this.yLabelAt != DefaultGrf.BAD) {
                    buffer.append(",LabelAt(2)=");
                    buffer.append(this.yLabelAt);
                }
            } else {
                buffer.append(",DrawAxes(2)=0");
            }
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "axes";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "interior", this.interior);
        this.addChildElement(rootElement, "isXSet", this.isXSet);
        this.addChildElement(rootElement, "showX", this.showX);
        this.addChildElement(rootElement, "xLog", this.logX);
        this.addChildElement(rootElement, "xLabelAt", this.xLabelAt);
        if (this.xColour != null) {
            this.addChildElement(rootElement, "xColour", this.xColour);
        }
        this.addChildElement(rootElement, "xStyle", this.xStyle);
        this.addChildElement(rootElement, "xWidth", this.xWidth);
        this.addChildElement(rootElement, "isYSet", this.isYSet);
        this.addChildElement(rootElement, "showY", this.showY);
        this.addChildElement(rootElement, "yLog", this.logY);
        this.addChildElement(rootElement, "yLabelAt", this.yLabelAt);
        if (this.yColour != null) {
            this.addChildElement(rootElement, "yColour", this.yColour);
        }
        this.addChildElement(rootElement, "yStyle", this.yStyle);
        this.addChildElement(rootElement, "yWidth", this.yWidth);
    }

    public void setFromString(String name, String value) {
        if (name.equals("interior")) {
            this.setInterior(this.booleanFromString(value));
            return;
        }
        if (name.equals("isXSet")) {
            this.setXState(this.booleanFromString(value));
            return;
        }
        if (name.equals("showX")) {
            this.setXShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("xLog")) {
            this.setXLog(this.booleanFromString(value));
            return;
        }
        if (name.equals("xLabelAt")) {
            this.setXLabelAt(this.doubleFromString(value));
            return;
        }
        if (name.equals("xColour")) {
            this.setXColour(this.colorFromString(value));
            return;
        }
        if (name.equals("xStyle")) {
            this.setXStyle(this.intFromString(value));
            return;
        }
        if (name.equals("xWidth")) {
            this.setXWidth(this.doubleFromString(value));
            return;
        }
        if (name.equals("isYSet")) {
            this.setYState(this.booleanFromString(value));
            return;
        }
        if (name.equals("showY")) {
            this.setYShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("yLog")) {
            this.setYLog(this.booleanFromString(value));
            return;
        }
        if (name.equals("yLabelAt")) {
            this.setYLabelAt(this.doubleFromString(value));
            return;
        }
        if (name.equals("yColour")) {
            this.setYColour(this.colorFromString(value));
            return;
        }
        if (name.equals("yStyle")) {
            this.setYStyle(this.intFromString(value));
            return;
        }
        if (name.equals("yWidth")) {
            this.setYWidth(this.doubleFromString(value));
            return;
        }
        System.err.println("AstAxes: unknown configuration property: " + name + " (" + value + ")");
    }
}

