/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import uk.ac.starlink.ast.Frame;

public class AstDouble
extends Number
implements Comparable {
    private double value = 0.0;
    private Frame frame = null;
    private int axis = 0;
    public static final double BAD = -1.7976931348623157E308;

    public AstDouble(double value, Frame frame, int axis) {
        this.value = value;
        this.frame = frame;
        this.axis = axis;
    }

    public AstDouble(String value, Frame frame, int axis) throws NumberFormatException {
        this(AstDouble.valueOf(value, frame, axis).doubleValue(), frame, axis);
    }

    public boolean isBad() {
        return this.doubleValue() == -1.7976931348623157E308;
    }

    public static boolean isBad(double value) {
        return value == -1.7976931348623157E308;
    }

    public static double parseDouble(String value, Frame frame, int axis) {
        return frame.unformat(axis, value);
    }

    public String toString() {
        return this.frame.format(this.axis, this.value);
    }

    public static String toString(double value, Frame frame, int axis) {
        return frame.format(axis, value);
    }

    public AstDouble valueOf(String value) {
        double dvalue = AstDouble.parseDouble(value, this.frame, this.axis);
        return new AstDouble(dvalue, this.frame, this.axis);
    }

    public static AstDouble valueOf(String value, Frame frame, int axis) {
        double dvalue = AstDouble.parseDouble(value, frame, axis);
        return new AstDouble(dvalue, frame, axis);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int compareTo(Object o) {
        AstDouble d = (AstDouble)o;
        Double newO = new Double(d.doubleValue());
        return new Double(this.value).compareTo(newO);
    }
}

