/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Font;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.grf.DefaultGrfFontManager;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstStrings
extends AbstractPlotControlsModel {
    protected boolean isSet;
    protected Font font;
    protected Color colour;
    protected DefaultGrfFontManager grfFontManager = DefaultGrfFontManager.getReference();

    public AstStrings() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.isSet = false;
        this.colour = Color.black;
        this.font = null;
        this.fireChanged();
    }

    public void setState(boolean isSet) {
        this.isSet = isSet;
        this.fireChanged();
    }

    public boolean getState() {
        return this.isSet;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.setState(true);
            this.grfFontManager.add(font);
        }
        if (this.font != null) {
            this.grfFontManager.remove(this.font);
        }
        this.font = font;
        this.fireChanged();
    }

    public Font getFont() {
        return this.font;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public Color getColour() {
        return this.colour;
    }

    public String getAstOptions() {
        if (!this.isSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.font != null) {
            buffer.append("Font(strings)=");
            buffer.append(this.grfFontManager.getIndex(this.font));
            buffer.append(",");
        }
        if (this.colour != null) {
            buffer.append("Colour(strings)=");
            int value = DefaultGrf.encodeColor(this.colour);
            if (value == -1) {
                value = 0;
            }
            buffer.append(value);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "text";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "isSet", this.isSet);
        if (this.font != null) {
            this.addChildElement(rootElement, "font", this.font);
        }
        if (this.colour != null) {
            this.addChildElement(rootElement, "colour", this.colour);
        }
    }

    public void setFromString(String name, String value) {
        if (name.equals("isSet")) {
            this.setState(this.booleanFromString(value));
            return;
        }
        if (name.equals("font")) {
            this.setFont(this.fontFromString(value));
            return;
        }
        if (name.equals("colour")) {
            this.setColour(this.colorFromString(value));
            return;
        }
        System.err.println("AstStrings: unknown configuration property:" + name + " (" + value + ")");
    }
}

